/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;

public class IngredientComponentStorageWrapped<T, M>
implements IIngredientComponentStorage<T, M> {
    private final IIngredientComponentStorage<T, M> ingredientComponentStorage;
    private final boolean read;
    private final boolean insert;
    private final boolean extract;

    public IngredientComponentStorageWrapped(IIngredientComponentStorage<T, M> ingredientComponentStorage, boolean read, boolean insert, boolean extract) {
        this.ingredientComponentStorage = ingredientComponentStorage;
        this.read = read;
        this.insert = insert;
        this.extract = extract;
    }

    protected IIngredientComponentStorage<T, M> getIngredientComponentStorage() {
        return this.ingredientComponentStorage;
    }

    protected boolean isRead() {
        return this.read;
    }

    protected boolean isInsert() {
        return this.insert;
    }

    protected boolean isExtract() {
        return this.extract;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.getIngredientComponentStorage().getComponent();
    }

    public Iterator<T> iterator() {
        if (!this.isRead()) {
            return Iterators.forArray((Object[])new Object[0]);
        }
        return this.getIngredientComponentStorage().iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        if (!this.isRead()) {
            return Iterators.forArray((Object[])new Object[0]);
        }
        return this.getIngredientComponentStorage().iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        if (!this.isRead()) {
            return 0L;
        }
        return this.getIngredientComponentStorage().getMaxQuantity();
    }

    public T insert(@Nonnull T ingredient, boolean simulate) {
        if (!this.isInsert()) {
            return ingredient;
        }
        return (T)this.getIngredientComponentStorage().insert(ingredient, simulate);
    }

    public T extract(@Nonnull T prototype, M matchCondition, boolean simulate) {
        if (!this.isExtract()) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        return (T)this.getIngredientComponentStorage().extract(prototype, matchCondition, simulate);
    }

    public T extract(long maxQuantity, boolean simulate) {
        if (!this.isExtract()) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        return (T)this.getIngredientComponentStorage().extract(maxQuantity, simulate);
    }
}

