/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.tile;

import java.util.List;
import mob_grinding_utils.ModItems;
import mob_grinding_utils.blocks.BlockFan;
import mob_grinding_utils.items.ItemFanUpgrade;
import mob_grinding_utils.tile.TileEntityInventoryHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFan
extends TileEntityInventoryHelper
implements ITickable {
    private static final int[] SLOTS = new int[]{0, 1, 2};
    public boolean showRenderBox;
    float xPos;
    float yPos;
    float zPos;
    float xNeg;
    float yNeg;
    float zNeg;

    public TileEntityFan() {
        super(3);
    }

    public void func_73660_a() {
        if (this.func_145831_w().func_82737_E() % 2L == 0L && this.func_145831_w().func_180495_p(this.func_174877_v()).func_177230_c() != null && ((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockFan.POWERED)).booleanValue()) {
            this.activateBlock();
        }
        if (!this.func_145831_w().field_72995_K) {
            this.setAABBWithModifiers();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getWidthModifier() {
        return this.hasWidthUpgrade() ? ((ItemStack)this.getItems().get(0)).func_190916_E() : 0;
    }

    public int getHeightModifier() {
        return this.hasHeightUpgrade() ? ((ItemStack)this.getItems().get(1)).func_190916_E() : 0;
    }

    public int getSpeedModifier() {
        return this.hasSpeedUpgrade() ? ((ItemStack)this.getItems().get(2)).func_190916_E() : 0;
    }

    public void setAABBWithModifiers() {
        IBlockState state2;
        int distance;
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFan.field_176387_N);
        for (distance = 1; distance < 5 + this.getSpeedModifier() && (state2 = this.func_145831_w().func_180495_p(this.func_174877_v().func_177967_a(facing, distance))) == Blocks.field_150350_a.func_176223_P(); ++distance) {
        }
        if (facing == EnumFacing.UP) {
            this.yPos = distance;
            this.yNeg = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == EnumFacing.DOWN) {
            this.yNeg = distance;
            this.yPos = -1.0f;
            this.xPos = this.getHeightModifier();
            this.xNeg = this.getHeightModifier();
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
        }
        if (facing == EnumFacing.WEST) {
            this.xNeg = distance;
            this.xPos = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == EnumFacing.EAST) {
            this.xPos = distance;
            this.xNeg = -1.0f;
            this.zPos = this.getWidthModifier();
            this.zNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == EnumFacing.NORTH) {
            this.zNeg = distance;
            this.zPos = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        if (facing == EnumFacing.SOUTH) {
            this.zPos = distance;
            this.zNeg = -1.0f;
            this.xPos = this.getWidthModifier();
            this.xNeg = this.getWidthModifier();
            this.yPos = this.getHeightModifier();
            this.yNeg = this.getHeightModifier();
        }
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
    }

    public AxisAlignedBB getAABBWithModifiers() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.xNeg), (double)((float)this.func_174877_v().func_177956_o() - this.yNeg), (double)((float)this.func_174877_v().func_177952_p() - this.zNeg), (double)this.func_174877_v().func_177958_n() + 1.0 + (double)this.xPos, (double)this.func_174877_v().func_177956_o() + 1.0 + (double)this.yPos, (double)this.func_174877_v().func_177952_p() + 1.0 + (double)this.zPos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getAABBForRender() {
        return new AxisAlignedBB((double)(-this.xNeg), (double)(-this.yNeg), (double)(-this.zNeg), 1.0 + (double)this.xPos, 1.0 + (double)this.yPos, 1.0 + (double)this.zPos);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - this.xNeg), (double)((float)this.func_174877_v().func_177956_o() - this.yNeg), (double)((float)this.func_174877_v().func_177952_p() - this.zNeg), (double)this.func_174877_v().func_177958_n() + 1.0 + (double)this.xPos, (double)this.func_174877_v().func_177956_o() + 1.0 + (double)this.yPos, (double)this.func_174877_v().func_177952_p() + 1.0 + (double)this.zPos);
    }

    public void toggleRenderBox() {
        this.showRenderBox = !this.showRenderBox;
        this.func_70296_d();
    }

    protected Entity activateBlock() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFan.field_176387_N);
        List list = this.func_145831_w().func_72872_a(EntityLivingBase.class, this.getAABBWithModifiers());
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || !(entity instanceof EntityLivingBase)) continue;
            if (facing != EnumFacing.UP && facing != EnumFacing.DOWN) {
                entity.func_70024_g((double)MathHelper.func_76126_a((float)(facing.func_176734_d().func_185119_l() * 3.141593f / 180.0f)) * 0.5, 0.0, (double)(-MathHelper.func_76134_b((float)(facing.func_176734_d().func_185119_l() * 3.141593f / 180.0f))) * 0.5);
                continue;
            }
            if (facing == EnumFacing.UP) {
                entity.field_70181_x += 0.125;
                entity.func_70024_g(0.0, 0.25, 0.0);
                entity.field_70143_R = 0.0f;
                continue;
            }
            if (facing != EnumFacing.DOWN) continue;
            entity.func_70024_g(0.0, -0.2, 0.0);
        }
        return null;
    }

    private boolean hasWidthUpgrade() {
        return !((ItemStack)this.getItems().get(0)).func_190926_b() && ((ItemStack)this.getItems().get(0)).func_77973_b() == ModItems.FAN_UPGRADE && ((ItemStack)this.getItems().get(0)).func_77952_i() == 0;
    }

    private boolean hasHeightUpgrade() {
        return !((ItemStack)this.getItems().get(1)).func_190926_b() && ((ItemStack)this.getItems().get(1)).func_77973_b() == ModItems.FAN_UPGRADE && ((ItemStack)this.getItems().get(1)).func_77952_i() == 1;
    }

    private boolean hasSpeedUpgrade() {
        return !((ItemStack)this.getItems().get(2)).func_190926_b() && ((ItemStack)this.getItems().get(2)).func_77973_b() == ModItems.FAN_UPGRADE && ((ItemStack)this.getItems().get(2)).func_77952_i() == 2;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("showRenderBox", this.showRenderBox);
        nbt.func_74776_a("xPos", this.xPos);
        nbt.func_74776_a("yPos", this.yPos);
        nbt.func_74776_a("zPos", this.zPos);
        nbt.func_74776_a("xNeg", this.xNeg);
        nbt.func_74776_a("yNeg", this.yNeg);
        nbt.func_74776_a("zNeg", this.zNeg);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.showRenderBox = nbt.func_74767_n("showRenderBox");
        this.xPos = nbt.func_74760_g("xPos");
        this.yPos = nbt.func_74760_g("yPos");
        this.zPos = nbt.func_74760_g("zPos");
        this.xNeg = nbt.func_74760_g("xNeg");
        this.yNeg = nbt.func_74760_g("yNeg");
        this.zNeg = nbt.func_74760_g("zNeg");
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        return this.func_189515_b(nbt);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        this.onContentsChanged();
    }

    public void onContentsChanged() {
        if (this != null && !this.func_145831_w().field_72995_K) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.setAABBWithModifiers();
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 8);
            this.func_70296_d();
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFanUpgrade;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.getItems(), (int)index);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public int[] func_180463_a(EnumFacing side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

