/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.network.gui.INumberReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.IEnergyDisplay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityFireworkBox
extends TileEntityBase
implements IEnergyDisplay,
INumberReactor {
    public static final int USE_PER_SHOT = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(20000, 200, 0);
    public int intValuePlay = 2;
    public int chargeAmount = 2;
    public int flightTime = 2;
    public float trailOrFlickerChance = 0.65f;
    public float flickerChance = 0.25f;
    public int colorAmount = 3;
    public float typeChance0 = 1.0f;
    public float typeChance1 = 0.0f;
    public float typeChance2 = 0.0f;
    public float typeChance3 = 0.0f;
    public float typeChance4 = 0.0f;
    public int areaOfEffect = 2;
    private int timeUntilNextFirework;
    private int oldEnergy;

    public TileEntityFireworkBox() {
        super("fireworkBox");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Play", this.intValuePlay);
            compound.func_74768_a("ChargeAmount", this.chargeAmount);
            compound.func_74768_a("FlightTime", this.flightTime);
            compound.func_74776_a("TrailFlickerChance", this.trailOrFlickerChance);
            compound.func_74776_a("FlickerChance", this.flickerChance);
            compound.func_74768_a("ColorAmount", this.colorAmount);
            compound.func_74776_a("TypeChance0", this.typeChance0);
            compound.func_74776_a("TypeChance1", this.typeChance1);
            compound.func_74776_a("TypeChance2", this.typeChance2);
            compound.func_74776_a("TypeChance3", this.typeChance3);
            compound.func_74776_a("TypeChance4", this.typeChance4);
            compound.func_74768_a("Area", this.areaOfEffect);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.intValuePlay = compound.func_74762_e("Play");
            this.chargeAmount = compound.func_74762_e("ChargeAmount");
            this.flightTime = compound.func_74762_e("FlightTime");
            this.trailOrFlickerChance = compound.func_74760_g("TrailFlickerChance");
            this.flickerChance = compound.func_74760_g("FlickerChance");
            this.colorAmount = compound.func_74762_e("ColorAmount");
            this.typeChance0 = compound.func_74760_g("TypeChance0");
            this.typeChance1 = compound.func_74760_g("TypeChance1");
            this.typeChance2 = compound.func_74760_g("TypeChance2");
            this.typeChance3 = compound.func_74760_g("TypeChance3");
            this.typeChance4 = compound.func_74760_g("TypeChance4");
            this.areaOfEffect = compound.func_74762_e("Area");
        }
    }

    @Override
    public void onNumberReceived(double number, int id, EntityPlayer player) {
        switch (id) {
            case 0: {
                this.intValuePlay = (int)number;
                break;
            }
            case 1: {
                this.chargeAmount = (int)number;
                break;
            }
            case 2: {
                this.flightTime = (int)number;
                break;
            }
            case 3: {
                this.trailOrFlickerChance = (float)number;
                break;
            }
            case 4: {
                this.flickerChance = (float)number;
                break;
            }
            case 5: {
                this.colorAmount = (int)number;
                break;
            }
            case 6: {
                this.typeChance0 = (float)number;
                break;
            }
            case 7: {
                this.typeChance1 = (float)number;
                break;
            }
            case 8: {
                this.typeChance2 = (float)number;
                break;
            }
            case 9: {
                this.typeChance3 = (float)number;
                break;
            }
            case 10: {
                this.typeChance4 = (float)number;
                break;
            }
            case 11: {
                this.areaOfEffect = (int)number;
            }
        }
        this.sendUpdate();
    }

    public void spawnFireworks(World world, double x, double y, double z) {
        double newZ;
        ItemStack firework = this.makeFirework();
        double newX = x + this.getRandomAoe();
        if (world.func_175667_e(new BlockPos(newX, y, newZ = z + this.getRandomAoe()))) {
            EntityFireworkRocket rocket = new EntityFireworkRocket(world, newX, y + 1.0, newZ, firework);
            world.func_72838_d((Entity)rocket);
        }
    }

    private double getRandomAoe() {
        if (this.areaOfEffect <= 0) {
            return 0.5;
        }
        return MathHelper.func_82716_a((Random)this.field_145850_b.field_73012_v, (double)0.0, (double)(this.areaOfEffect * 2)) - (double)this.areaOfEffect;
    }

    private ItemStack makeFirework() {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.getRandomWithPlay(this.chargeAmount); ++i) {
            list.func_74742_a((NBTBase)this.makeFireworkCharge());
        }
        NBTTagCompound compound1 = new NBTTagCompound();
        compound1.func_74782_a("Explosions", (NBTBase)list);
        compound1.func_74774_a("Flight", (byte)this.getRandomWithPlay(this.flightTime));
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Fireworks", (NBTBase)compound1);
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        firework.func_77982_d(compound);
        return firework;
    }

    private NBTTagCompound makeFireworkCharge() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.field_145850_b.field_73012_v.nextFloat() <= this.trailOrFlickerChance) {
            if (this.field_145850_b.field_73012_v.nextFloat() <= this.flickerChance) {
                compound.func_74757_a("Flicker", true);
            } else {
                compound.func_74757_a("Trail", true);
            }
        }
        int[] colors = new int[this.getRandomWithPlay(this.colorAmount)];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[this.field_145850_b.field_73012_v.nextInt(ItemDye.field_150922_c.length)];
        }
        compound.func_74783_a("Colors", colors);
        compound.func_74774_a("Type", (byte)this.getRandomType());
        return compound;
    }

    private int getRandomWithPlay(int value) {
        return MathHelper.func_76125_a((int)MathHelper.func_76136_a((Random)this.field_145850_b.field_73012_v, (int)(value - this.intValuePlay), (int)(value + this.intValuePlay)), (int)1, (int)6);
    }

    private int getRandomType() {
        ArrayList<WeightedFireworkType> possible = new ArrayList<WeightedFireworkType>();
        possible.add(new WeightedFireworkType(0, this.typeChance0));
        possible.add(new WeightedFireworkType(1, this.typeChance1));
        possible.add(new WeightedFireworkType(2, this.typeChance2));
        possible.add(new WeightedFireworkType(3, this.typeChance3));
        possible.add(new WeightedFireworkType(4, this.typeChance4));
        int weight = WeightedRandom.func_76272_a(possible);
        if (weight <= 0) {
            return 0;
        }
        return ((WeightedFireworkType)WeightedRandom.func_76273_a((Random)this.field_145850_b.field_73012_v, possible, (int)weight)).type;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isRedstonePowered && !this.isPulseMode) {
                if (this.timeUntilNextFirework > 0) {
                    --this.timeUntilNextFirework;
                    if (this.timeUntilNextFirework <= 0) {
                        this.doWork();
                    }
                } else {
                    this.timeUntilNextFirework = 100;
                }
            }
            if (this.oldEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.oldEnergy = this.storage.getEnergyStored();
            }
        }
    }

    private void doWork() {
        if (this.storage.getEnergyStored() >= 500) {
            this.spawnFireworks(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            this.storage.extractEnergyInternal(500, false);
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }

    @Override
    public CustomEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    @Override
    public boolean needsHoldShift() {
        return false;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }

    private static class WeightedFireworkType
    extends WeightedRandom.Item {
        public final int type;

        public WeightedFireworkType(int type, float chance) {
            super((int)(chance * 100.0f));
            this.type = type;
        }
    }
}

