/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityDropper
extends TileEntityInventoryBase {
    private int currentTime;

    public TileEntityDropper() {
        super(9, "dropper");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.isPulseMode)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 5;
            }
        }
    }

    private void doWork() {
        ItemStack theoreticalRemove = this.removeFromInventory(false);
        if (StackUtil.isValid(theoreticalRemove)) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            ItemStack drop = theoreticalRemove.func_77946_l();
            drop.func_190920_e(1);
            WorldUtil.dropItemAtSide(WorldUtil.getDirectionByPistonRotation(state), this.field_145850_b, this.field_174879_c, drop);
            this.removeFromInventory(true);
        }
    }

    public ItemStack removeFromInventory(boolean actuallyDo) {
        for (int i = 0; i < this.inv.getSlots(); ++i) {
            if (!StackUtil.isValid(this.inv.getStackInSlot(i))) continue;
            ItemStack slot = this.inv.getStackInSlot(i).func_77946_l();
            if (actuallyDo) {
                this.inv.setStackInSlot(i, StackUtil.shrink(this.inv.getStackInSlot(i), 1));
                this.func_70296_d();
            }
            return slot;
        }
        return StackUtil.getEmpty();
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

