/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBreaker
extends TileEntityInventoryBase {
    public boolean isPlacer;
    private int currentTime;

    public TileEntityBreaker(int slots, String name) {
        super(slots, name);
    }

    public TileEntityBreaker() {
        super(9, "breaker");
        this.isPlacer = false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.isPulseMode)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 15;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> !automation;
    }

    private void doWork() {
        EnumFacing side = WorldUtil.getDirectionByPistonRotation(this.field_145850_b.func_180495_p(this.field_174879_c));
        BlockPos breakCoords = this.field_174879_c.func_177972_a(side);
        IBlockState stateToBreak = this.field_145850_b.func_180495_p(breakCoords);
        Block blockToBreak = stateToBreak.func_177230_c();
        if (!this.isPlacer && blockToBreak != Blocks.field_150350_a && !(blockToBreak instanceof BlockLiquid) && !(blockToBreak instanceof IFluidBlock) && stateToBreak.func_185887_b(this.field_145850_b, breakCoords) >= 0.0f) {
            NonNullList drops = NonNullList.func_191196_a();
            blockToBreak.getDrops(drops, (IBlockAccess)this.field_145850_b, breakCoords, stateToBreak, 0);
            float chance = WorldUtil.fireFakeHarvestEventsForDropChance(this, (NonNullList<ItemStack>)drops, this.field_145850_b, breakCoords);
            if (chance > 0.0f && this.field_145850_b.field_73012_v.nextFloat() <= chance && StackUtil.canAddAll(this.inv, (List<ItemStack>)drops, false)) {
                this.field_145850_b.func_175655_b(breakCoords, false);
                StackUtil.addAll(this.inv, (List<ItemStack>)drops, false);
                this.func_70296_d();
            }
        } else if (this.isPlacer) {
            int slot = StackUtil.findFirstFilled((IItemHandler)this.inv);
            if (slot == -1) {
                return;
            }
            this.inv.setStackInSlot(slot, WorldUtil.useItemAtSide(side, this.field_145850_b, this.field_174879_c, this.inv.getStackInSlot(slot)));
        }
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

