/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.items;

import de.ellpeck.actuallyadditions.api.tile.IPhantomTile;
import de.ellpeck.actuallyadditions.mod.items.base.ItemBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ItemPhantomConnector
extends ItemBase {
    public ItemPhantomConnector(String name) {
        super(name);
        this.func_77625_d(1);
    }

    public static World getStoredWorld(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            return DimensionManager.getWorld((int)tag.func_74762_e("WorldOfTileStored"));
        }
        return null;
    }

    public static BlockPos getStoredPosition(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            int x = tag.func_74762_e("XCoordOfTileStored");
            int y = tag.func_74762_e("YCoordOfTileStored");
            int z = tag.func_74762_e("ZCoordOfTileStored");
            if (x != 0 || y != 0 || z != 0) {
                return new BlockPos(x, y, z);
            }
        }
        return null;
    }

    public static void clearStorage(ItemStack stack, String ... keys) {
        if (stack.func_77942_o()) {
            NBTTagCompound compound = stack.func_77978_p();
            for (String key : keys) {
                compound.func_82580_o(key);
            }
        }
    }

    public static void storeConnection(ItemStack stack, int x, int y, int z, World world) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a("XCoordOfTileStored", x);
        tag.func_74768_a("YCoordOfTileStored", y);
        tag.func_74768_a("ZCoordOfTileStored", z);
        tag.func_74768_a("WorldOfTileStored", world.field_73011_w.getDimension());
        stack.func_77982_d(tag);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing par7, float par8, float par9, float par10) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof IPhantomTile) {
                BlockPos stored = ItemPhantomConnector.getStoredPosition(stack);
                if (stored != null && ItemPhantomConnector.getStoredWorld(stack) == world) {
                    ((IPhantomTile)tile).setBoundPosition(stored);
                    if (tile instanceof TileEntityBase) {
                        ((TileEntityBase)tile).sendUpdate();
                    }
                    ItemPhantomConnector.clearStorage(stack, "XCoordOfTileStored", "YCoordOfTileStored", "ZCoordOfTileStored", "WorldOfTileStored");
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.actuallyadditions.phantom.connected.desc", new Object[0]), true);
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.FAIL;
            }
            ItemPhantomConnector.storeConnection(stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), world);
            player.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.actuallyadditions.phantom.stored.desc", new Object[0]), true);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean func_77651_p() {
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World playerIn, List<String> list, ITooltipFlag advanced) {
        BlockPos coords = ItemPhantomConnector.getStoredPosition(stack);
        if (coords != null) {
            list.add(StringUtil.localize("tooltip.actuallyadditions.boundTo.desc") + ":");
            list.add("X: " + coords.func_177958_n());
            list.add("Y: " + coords.func_177956_o());
            list.add("Z: " + coords.func_177952_p());
            list.add(TextFormatting.ITALIC + StringUtil.localize("tooltip.actuallyadditions.clearStorage.desc"));
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

