/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.data;

import de.ellpeck.actuallyadditions.api.booklet.IBookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.misc.BookletUtils;
import de.ellpeck.actuallyadditions.mod.data.WorldData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PlayerData {
    public static PlayerSave getDataFromPlayer(EntityPlayer player) {
        PlayerSave save;
        WorldData worldData = WorldData.get(player.func_130014_f_());
        ConcurrentHashMap<UUID, PlayerSave> data = worldData.playerSaveData;
        UUID id = player.func_110124_au();
        if (data.containsKey(id) && (save = data.get(id)) != null && save.id != null && save.id.equals(id)) {
            return save;
        }
        save = new PlayerSave(id);
        data.put(id, save);
        worldData.func_76185_a();
        return save;
    }

    public static class PlayerSave {
        public UUID id;
        public boolean bookGottenAlready;
        public boolean didBookTutorial;
        public boolean hasBatWings;
        public boolean shouldDisableBatWings;
        public int batWingsFlyTime;
        public IBookletPage[] bookmarks = new IBookletPage[12];
        public List<String> completedTrials = new ArrayList<String>();
        @SideOnly(value=Side.CLIENT)
        public GuiBooklet lastOpenBooklet;

        public PlayerSave(UUID id) {
            this.id = id;
        }

        public void readFromNBT(NBTTagCompound compound, boolean savingToFile) {
            this.bookGottenAlready = compound.func_74767_n("BookGotten");
            this.didBookTutorial = compound.func_74767_n("DidTutorial");
            this.hasBatWings = compound.func_74767_n("HasBatWings");
            this.batWingsFlyTime = compound.func_74762_e("BatWingsFlyTime");
            NBTTagList bookmarks = compound.func_150295_c("Bookmarks", 8);
            this.loadBookmarks(bookmarks);
            NBTTagList trials = compound.func_150295_c("Trials", 8);
            this.loadTrials(trials);
            if (!savingToFile) {
                this.shouldDisableBatWings = compound.func_74767_n("ShouldDisableWings");
            }
        }

        public void writeToNBT(NBTTagCompound compound, boolean savingToFile) {
            compound.func_74757_a("BookGotten", this.bookGottenAlready);
            compound.func_74757_a("DidTutorial", this.didBookTutorial);
            compound.func_74757_a("HasBatWings", this.hasBatWings);
            compound.func_74768_a("BatWingsFlyTime", this.batWingsFlyTime);
            compound.func_74782_a("Bookmarks", (NBTBase)this.saveBookmarks());
            compound.func_74782_a("Trials", (NBTBase)this.saveTrials());
            if (!savingToFile) {
                compound.func_74757_a("ShouldDisableWings", this.shouldDisableBatWings);
            }
        }

        public NBTTagList saveBookmarks() {
            NBTTagList bookmarks = new NBTTagList();
            for (IBookletPage bookmark : this.bookmarks) {
                bookmarks.func_74742_a((NBTBase)new NBTTagString(bookmark == null ? "" : bookmark.getIdentifier()));
            }
            return bookmarks;
        }

        public void loadBookmarks(NBTTagList bookmarks) {
            for (int i = 0; i < bookmarks.func_74745_c(); ++i) {
                IBookletPage page;
                String strg = bookmarks.func_150307_f(i);
                this.bookmarks[i] = strg != null && !strg.isEmpty() ? (page = BookletUtils.getBookletPageById(strg)) : null;
            }
        }

        public NBTTagList saveTrials() {
            NBTTagList trials = new NBTTagList();
            for (String trial : this.completedTrials) {
                trials.func_74742_a((NBTBase)new NBTTagString(trial));
            }
            return trials;
        }

        public void loadTrials(NBTTagList trials) {
            this.completedTrials.clear();
            for (int i = 0; i < trials.func_74745_c(); ++i) {
                String strg = trials.func_150307_f(i);
                if (strg == null || strg.isEmpty()) continue;
                this.completedTrials.add(strg);
            }
        }
    }
}

