/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.OreDictionary;

public class UnformedItemStack {
    public static final UnformedItemStack EMPTY = new UnformedItemStack();
    public List<ItemStack> possibleStacks = new ArrayList<ItemStack>();

    public UnformedItemStack() {
    }

    public UnformedItemStack(String ... lst) {
        for (String s : lst) {
            this.possibleStacks.addAll(Lists.transform((List)OreDictionary.getOres((String)s, (boolean)false), UnformedItemStack::copyAndSetCountToOne));
        }
        this.sort();
    }

    public UnformedItemStack(ItemStack is) {
        this.possibleStacks.add(UnformedItemStack.copyAndSetCountToOne(is));
        this.sort();
    }

    public UnformedItemStack(String oreDictName) {
        this.possibleStacks.addAll(Lists.transform((List)OreDictionary.getOres((String)oreDictName, (boolean)false), UnformedItemStack::copyAndSetCountToOne));
        this.sort();
    }

    public UnformedItemStack(List<?> lst) {
        for (Object obj1 : lst) {
            this.possibleStacks.addAll(this.getItemStacks(obj1));
        }
        this.sort();
    }

    public UnformedItemStack(ItemStack ... stk) {
        this.possibleStacks.addAll(Lists.transform(Arrays.asList(stk), UnformedItemStack::copyAndSetCountToOne));
        this.sort();
    }

    public UnformedItemStack(Block b) {
        this.possibleStacks.add(new ItemStack(b, 1, Short.MAX_VALUE));
        this.sort();
    }

    public UnformedItemStack(Item i) {
        this.possibleStacks.add(new ItemStack(i, 1, Short.MAX_VALUE));
        this.sort();
    }

    public UnformedItemStack(Object obj) {
        this.possibleStacks.addAll(this.getItemStacks(obj));
        this.sort();
    }

    public UnformedItemStack(Object ... lst) {
        for (Object obj1 : lst) {
            this.possibleStacks.addAll(this.getItemStacks(obj1));
        }
        this.sort();
    }

    public List<ItemStack> getItemStacks(Object obj) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (obj instanceof Object[]) {
            for (Object obj1 : (Object[])obj) {
                stacks.addAll(this.getItemStacks(obj1));
            }
        } else if (obj instanceof List) {
            for (Object obj1 : (List)obj) {
                stacks.addAll(this.getItemStacks(obj1));
            }
        } else if (obj instanceof ItemStack) {
            ItemStack stk = UnformedItemStack.copyAndSetCountToOne((ItemStack)obj);
            stacks.add(stk);
        } else if (obj instanceof Block) {
            stacks.add(new ItemStack((Block)obj, 1, Short.MAX_VALUE));
        } else if (obj instanceof Item) {
            stacks.add(new ItemStack((Item)obj, 1, Short.MAX_VALUE));
        } else if (obj instanceof String) {
            stacks.addAll(Lists.transform((List)OreDictionary.getOres((String)((String)obj), (boolean)false), UnformedItemStack::copyAndSetCountToOne));
        }
        return stacks;
    }

    public boolean matches(UnformedItemStack uis) {
        return this.possibleStacks.equals(uis.possibleStacks);
    }

    public boolean isEmpty() {
        if (this == EMPTY) {
            return true;
        }
        return this.possibleStacks.isEmpty();
    }

    public boolean itemStackMatches(ItemStack is) {
        if (is.func_190926_b()) {
            return false;
        }
        return this.possibleStacks.stream().anyMatch(s -> is.func_77973_b() == s.func_77973_b() && (s.func_77952_i() == Short.MAX_VALUE || is.func_77952_i() == s.func_77952_i() && ItemStack.func_77970_a((ItemStack)s, (ItemStack)is)));
    }

    public static ItemStack copyAndSetCountToOne(ItemStack stk) {
        stk = stk.func_77946_l();
        stk.func_190920_e(1);
        return stk;
    }

    public String toString() {
        String str = "";
        for (ItemStack s : this.possibleStacks) {
            str = str + s;
        }
        return str;
    }

    public UnformedItemStack copy() {
        return new UnformedItemStack(this.possibleStacks);
    }

    public void nullify() {
        this.possibleStacks.clear();
    }

    public void sort() {
        ArrayList<ItemStack> possibleStacksCopy = new ArrayList<ItemStack>();
        possibleStacksCopy.addAll(this.possibleStacks);
        this.possibleStacks.clear();
        for (int i = 0; i < possibleStacksCopy.size(); ++i) {
            ItemStack is = (ItemStack)possibleStacksCopy.get(i);
            if (is == null || is.func_190926_b() || this.possibleStacks.contains(is)) continue;
            this.possibleStacks.add(is);
        }
        this.possibleStacks.sort((stk0, stk1) -> stk0.toString().compareTo(stk1.toString()));
        possibleStacksCopy.clear();
    }

    public ItemStack getISToDraw(long time) {
        int size = this.possibleStacks.size();
        if (size <= 0) {
            return ItemStack.field_190927_a;
        }
        return this.possibleStacks.get((int)(time / 30L) % size);
    }

    public void writeToNBTTagCompound(NBTTagCompound tag) {
        NBTTagList items = new NBTTagList();
        for (ItemStack is : this.possibleStacks) {
            NBTTagCompound itemTag = new NBTTagCompound();
            is.func_77955_b(itemTag);
            items.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("unformedISList", (NBTBase)items);
    }

    public void readFromNBTTagCompound(NBTTagCompound tag) {
        NBTTagList items = tag.func_150295_c("unformedISList", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemTag = items.func_150305_b(i);
            ItemStack is = new ItemStack(itemTag);
            this.possibleStacks.add(is);
        }
        this.sort();
    }

    static {
        UnformedItemStack.EMPTY.possibleStacks = ImmutableList.of();
    }
}

