/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.Core;
import DummyCore.Utils.Coord3D;
import DummyCore.Utils.ExtendedAABB;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class StructureApi {
    @Deprecated
    public static NBTTagCompound createStructureTagIgnoreMetadata(World w, AxisAlignedBB aabb, boolean whitelist, Block ... blocks) {
        return StructureApi.createStructureTagIgnoreMetadata(w, new ExtendedAABB(aabb), whitelist, blocks);
    }

    public static NBTTagCompound createStructureTagIgnoreMetadata(World w, ExtendedAABB aabb, boolean whitelist, Block ... blocks) {
        NBTTagCompound tag = new NBTTagCompound();
        if (aabb.minX > aabb.maxX) {
            double mX = aabb.minX;
            aabb.minX = aabb.maxX;
            aabb.maxX = mX;
        }
        if (aabb.minY > aabb.maxY) {
            double mY = aabb.minY;
            aabb.minY = aabb.maxY;
            aabb.maxY = mY;
        }
        if (aabb.minZ > aabb.maxZ) {
            double mZ = aabb.minZ;
            aabb.minZ = aabb.maxZ;
            aabb.maxZ = mZ;
        }
        int dx = (int)aabb.minX;
        while ((double)dx <= aabb.maxX) {
            int dy = (int)aabb.minY;
            while ((double)dy <= aabb.maxY) {
                int dz = (int)aabb.minZ;
                while ((double)dz <= aabb.maxZ) {
                    Block b = w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                    if (b != null) {
                        String coords;
                        boolean include = false;
                        if (whitelist) {
                            for (Block block : blocks) {
                                if (!block.equals(b)) continue;
                                include = true;
                                break;
                            }
                        } else {
                            include = true;
                            for (Block block : blocks) {
                                if (!block.equals(b)) continue;
                                include = false;
                                break;
                            }
                        }
                        if (include && !tag.func_74764_b(coords = String.valueOf((double)dx - aabb.minX - (aabb.maxX - aabb.minX) / 2.0) + "|" + String.valueOf((double)dy - aabb.minY) + "|" + String.valueOf((double)dz - aabb.minZ - (aabb.maxZ - aabb.minZ) / 2.0))) {
                            tag.func_74778_a(coords, b.getRegistryName().toString());
                        }
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        return tag;
    }

    @Deprecated
    public static NBTTagCompound createStructureTag(World w, AxisAlignedBB aabb, boolean whitelist, Block ... blocks) {
        return StructureApi.createStructureTag(w, new ExtendedAABB(aabb), whitelist, blocks);
    }

    public static NBTTagCompound createStructureTag(World w, ExtendedAABB aabb, boolean whitelist, Block ... blocks) {
        NBTTagCompound tag = new NBTTagCompound();
        if (aabb.minX > aabb.maxX) {
            double mX = aabb.minX;
            aabb.minX = aabb.maxX;
            aabb.maxX = mX;
        }
        if (aabb.minY > aabb.maxY) {
            double mY = aabb.minY;
            aabb.minY = aabb.maxY;
            aabb.maxY = mY;
        }
        if (aabb.minZ > aabb.maxZ) {
            double mZ = aabb.minZ;
            aabb.minZ = aabb.maxZ;
            aabb.maxZ = mZ;
        }
        int dx = (int)aabb.minX;
        while ((double)dx <= aabb.maxX) {
            int dy = (int)aabb.minY;
            while ((double)dy <= aabb.maxY) {
                int dz = (int)aabb.minZ;
                while ((double)dz <= aabb.maxZ) {
                    Block b = w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c();
                    if (b != null) {
                        String coords;
                        boolean include = false;
                        if (whitelist) {
                            for (Block block : blocks) {
                                if (!block.equals(b)) continue;
                                include = true;
                                break;
                            }
                        } else {
                            include = true;
                            for (Block block : blocks) {
                                if (!block.equals(b)) continue;
                                include = false;
                                break;
                            }
                        }
                        if (include && !tag.func_74764_b(coords = String.valueOf((double)dx - aabb.minX - (aabb.maxX - aabb.minX) / 2.0) + "|" + String.valueOf((double)dy - aabb.minY) + "|" + String.valueOf((double)dz - aabb.minZ - (aabb.maxZ - aabb.minZ) / 2.0))) {
                            tag.func_74778_a(coords, b.getRegistryName().toString() + "|" + w.func_180495_p(new BlockPos(dx, dy, dz)).func_177230_c().func_176201_c(w.func_180495_p(new BlockPos(dx, dy, dz))));
                        }
                    }
                    ++dz;
                }
                ++dy;
            }
            ++dx;
        }
        return tag;
    }

    public static void nbtStructureIntoWorld(World w, int x, int y, int z, NBTTagCompound structureTag) {
        Set keySet = structureTag.func_150296_c();
        ArrayList keys = new ArrayList();
        ArrayList<Pair> structure = new ArrayList<Pair>();
        Iterator $i = keySet.iterator();
        while ($i.hasNext()) {
            keys.add($i.next());
        }
        for (String s : keys) {
            int dx = (int)Double.parseDouble(s.substring(0, s.indexOf(124)));
            int dy = (int)Double.parseDouble(s.substring(s.indexOf(124) + 1, s.lastIndexOf(124)));
            int dz = (int)Double.parseDouble(s.substring(s.lastIndexOf(124) + 1));
            Coord3D blockCoord = new Coord3D(dx, dy, dz);
            String st = structureTag.func_74779_i(s);
            String bid = st.indexOf(124) != -1 ? st.substring(0, st.indexOf(124)) : st;
            Block b = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(bid));
            int meta = st.indexOf(124) != -1 ? Integer.parseInt(st.substring(st.indexOf(124) + 1)) : 0;
            Pair blockAndMeta = Pair.of((Object)b, (Object)meta);
            structure.add(Pair.of((Object)blockCoord, (Object)blockAndMeta));
        }
        keys.clear();
        keys = null;
        for (Pair put : structure) {
            Coord3D c = (Coord3D)put.getLeft();
            int dx = (int)(c.x + (float)x);
            int dy = (int)(c.y + (float)y);
            int dz = (int)(c.z + (float)z);
            Pair pa = (Pair)put.getRight();
            w.func_180501_a(new BlockPos(dx, dy, dz), ((Block)pa.getLeft()).func_176203_a(((Integer)pa.getRight()).intValue()), 2);
        }
        structure.clear();
        structure = null;
    }

    public static boolean areNBTTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1.func_82582_d() || tag2.func_82582_d()) {
            return false;
        }
        Set keys = tag1.func_150296_c();
        int sF = keys.size();
        int sS = tag2.func_150296_c().size();
        for (String key : keys) {
            NBTBase base1 = tag1.func_74781_a(key);
            if (!tag2.func_74764_b(key)) {
                return false;
            }
            NBTBase base2 = tag2.func_74781_a(key);
            if (StructureApi.compareTagsPrimitive(base1, base2)) continue;
            return false;
        }
        return sF == sS;
    }

    public static boolean compareTagsPrimitive(NBTBase base1, NBTBase base2) {
        byte id2;
        byte id1 = base1.func_74732_a();
        if (id1 != (id2 = base2.func_74732_a())) {
            return false;
        }
        switch (id1) {
            case 0: {
                return true;
            }
            case 1: {
                NBTTagByte byte1 = (NBTTagByte)base1;
                NBTTagByte byte2 = (NBTTagByte)base2;
                return byte1.func_150290_f() == byte2.func_150290_f();
            }
            case 2: {
                NBTTagShort short1 = (NBTTagShort)base1;
                NBTTagShort short2 = (NBTTagShort)base2;
                return short1.func_150289_e() == short2.func_150289_e();
            }
            case 3: {
                NBTTagInt int1 = (NBTTagInt)base1;
                NBTTagInt int2 = (NBTTagInt)base2;
                return int1.func_150287_d() == int2.func_150287_d();
            }
            case 4: {
                NBTTagLong long1 = (NBTTagLong)base1;
                NBTTagLong long2 = (NBTTagLong)base2;
                return long1.func_150291_c() == long2.func_150291_c();
            }
            case 5: {
                NBTTagFloat float1 = (NBTTagFloat)base1;
                NBTTagFloat float2 = (NBTTagFloat)base2;
                return float1.func_150288_h() == float2.func_150288_h();
            }
            case 6: {
                NBTTagDouble double1 = (NBTTagDouble)base1;
                NBTTagDouble double2 = (NBTTagDouble)base2;
                return double1.func_150286_g() == double2.func_150286_g();
            }
            case 7: {
                NBTTagByteArray byteArray1 = (NBTTagByteArray)base1;
                NBTTagByteArray byteArray2 = (NBTTagByteArray)base2;
                return byteArray1.equals((Object)byteArray2);
            }
            case 8: {
                NBTTagString string1 = (NBTTagString)base1;
                NBTTagString string2 = (NBTTagString)base2;
                return string1.equals((Object)string2);
            }
            case 9: {
                NBTTagList list1 = (NBTTagList)base1;
                NBTTagList list2 = (NBTTagList)base2;
                return list1.equals((Object)list2);
            }
            case 10: {
                NBTTagCompound tag1 = (NBTTagCompound)base1;
                NBTTagCompound tag2 = (NBTTagCompound)base2;
                return tag1.equals((Object)tag2);
            }
            case 11: {
                NBTTagIntArray intArray1 = (NBTTagIntArray)base1;
                NBTTagIntArray intArray2 = (NBTTagIntArray)base2;
                return intArray1.equals((Object)intArray2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String structureFromFile(String modid, String filename) {
        InputStream is = Core.class.getResourceAsStream("/assets/" + modid + "/structure/" + filename + ".str");
        if (is != null) {
            String st = "";
            try {
                st = IOUtils.toString((InputStream)is, (String)"UTF-8");
            }
            catch (NullPointerException npe) {
                LogManager.getLogger(StructureApi.class).error("Can't find structure with name " + filename);
            }
            catch (IOException ioe) {
                LogManager.getLogger(StructureApi.class).error("Can't read structure with name " + filename);
            }
            catch (UnsupportedCharsetException uce) {
                FMLCommonHandler.instance().raiseException((Throwable)uce, "UTF-8 Is not supported on this system! This is a critical error!", true);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            return st;
        }
        LogManager.getLogger(StructureApi.class).error("Can't find structure with name " + filename);
        return null;
    }
}

