/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Utils.UnformedItemStack;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictUtils {
    public static boolean oreDictionaryContains(String ... oreNames) {
        for (String oreName : oreNames) {
            if (OreDictionary.getOres((String)oreName).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean compareIS(ItemStack is, String oreName) {
        int[] ids;
        if (!is.func_190926_b() && OreDictUtils.oreDictionaryContains(oreName) && (ids = OreDictionary.getOreIDs((ItemStack)is)) != null && ids.length > 0) {
            for (int i : ids) {
                if (!OreDictionary.getOreName((int)i).equalsIgnoreCase(oreName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean oreDictionaryContains(String oreName) {
        return !OreDictionary.getOres((String)oreName).isEmpty();
    }

    public static boolean oreDictionaryCompare(ItemStack stk, ItemStack stk1) {
        if (stk.func_190926_b() || stk1.func_190926_b()) {
            return false;
        }
        if (OreDictionary.getOreIDs((ItemStack)stk) == null || OreDictionary.getOreIDs((ItemStack)stk).length == 0 || OreDictionary.getOreIDs((ItemStack)stk1) == null || OreDictionary.getOreIDs((ItemStack)stk1).length == 0) {
            return false;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stk);
        int[] ids1 = OreDictionary.getOreIDs((ItemStack)stk1);
        for (int id : ids) {
            for (int element : ids1) {
                if (id != element) continue;
                return true;
            }
        }
        return false;
    }

    public static enum CommonOreRarity {
        COMMON(CommonOres.COAL),
        NORMAL(CommonOres.COPPER, CommonOres.TIN, CommonOres.ZINC, CommonOres.IRON, CommonOres.NICKEL, CommonOres.LEAD, CommonOres.GALENA, CommonOres.ALUMINIUM, CommonOres.AMBER, CommonOres.SULFUR, CommonOres.SALTPETER),
        UNCOMMON(CommonOres.SILVER, CommonOres.GOLD, CommonOres.CINNABAR, CommonOres.QUARTZ, CommonOres.MALACHITE, CommonOres.OSMIUM, CommonOres.REDSTONE, CommonOres.NICKOLITE, CommonOres.TESLATITE),
        SCATTERED(CommonOres.URANIUM, CommonOres.APATITE, CommonOres.LAPIS, CommonOres.HEMATITE, CommonOres.CHIMERITE, CommonOres.SILICON),
        RARE(CommonOres.PLUTONIUM, CommonOres.PERIDOT, CommonOres.AGATE, CommonOres.JASPER, CommonOres.TOURMALINE, CommonOres.TURQUOISE, CommonOres.BLUETOPAZ),
        EXCEPTIONAL(CommonOres.DIAMOND, CommonOres.SAPPHIRE, CommonOres.EMERALD, CommonOres.RUBY, CommonOres.AMETHYST, CommonOres.MOONSTONE, CommonOres.TUNGSTEN, CommonOres.COBALT, CommonOres.ARDITE),
        IMPOSSIBLE(CommonOres.IRIDIUM, CommonOres.SUNSTONE, CommonOres.PLATINUM, CommonOres.MYTHRIL);

        public final CommonOres[] theOre;

        private CommonOreRarity(CommonOres ... ore) {
            this.theOre = ore;
        }

        public static CommonOres[] byRarity(CommonOreRarity rarity) {
            return rarity.theOre;
        }

        public static CommonOreRarity byOre(CommonOres ore) {
            for (CommonOreRarity cor : CommonOreRarity.values()) {
                for (CommonOres ores : cor.theOre) {
                    if (!ores.equals((Object)ore)) continue;
                    return cor;
                }
            }
            return null;
        }
    }

    public static enum CommonOres {
        COAL("oreCoal"),
        COPPER("oreCopper"),
        TIN("oreTin"),
        ZINC("oreZinc"),
        IRON("oreIron"),
        SILVER("oreSilver"),
        GOLD("oreGold"),
        URANIUM("oreUranium", "oreUran", "oreYellorite", "oreYellorium"),
        PLUTONIUM("orePlutonium"),
        NICKEL("oreNickel"),
        LEAD("oreLead"),
        GALENA("oreGalena"),
        ALUMINIUM("oreAluminium", "oreAluminum", "oreBauxite"),
        IRIDIUM("oreIridium"),
        CINNABAR("oreCinnabar", "oreMercury", "oreQuicksilver"),
        AMBER("oreAmber"),
        DIAMOND("oreDiamond"),
        SAPPHIRE("oreSapphire"),
        EMERALD("oreEmerald"),
        RUBY("oreRuby"),
        PERIDOT("orePeridot"),
        APATITE("oreApatite"),
        AMETHYST("oreAmethyst", "oreAmetyst"),
        QUARTZ("oreQuartz", "oreNetherQuartz", "oreCertusQuartz"),
        LAPIS("oreLapis", "oreLapisLazuli"),
        AGATE("oreAgate"),
        JASPER("oreJasper"),
        MALACHITE("oreMalachite"),
        TOURMALINE("oreTourmaline"),
        TURQUOISE("oreTurquoise", "oreTurquoisite"),
        HEMATITE("oreHematite"),
        CHIMERITE("oreChimerite"),
        BLUETOPAZ("oreBlueTopaz"),
        MOONSTONE("oreMoonstone"),
        SUNSTONE("oreSunstone"),
        TUNGSTEN("oreTungsten"),
        COBALT("oreCobalt"),
        ARDITE("oreArdite"),
        PLATINUM("orePlatinum"),
        OSMIUM("oreOsmium"),
        SILICON("oreSilicon"),
        MYTHRIL("oreMythril", "oreMithril", "oreMana"),
        REDSTONE("oreRedstone"),
        NICKOLITE("oreNickolite"),
        TESLATITE("oreTeslatite"),
        SULFUR("oreSulfur"),
        SALTPETER("oreSalpeter");

        public String[] names;

        private CommonOres(String ... names) {
            this.names = names;
        }

        public String[] getOreDictNames() {
            return this.names;
        }

        public boolean exists() {
            return OreDictUtils.oreDictionaryContains(this.names);
        }

        public UnformedItemStack fromThis() {
            return new UnformedItemStack(this.names);
        }

        public String toString() {
            return this.names != null && this.names.length > 0 ? Arrays.asList(this.names).toString() : super.toString();
        }

        public CommonOreRarity getRarity() {
            return CommonOreRarity.byOre(this);
        }
    }
}

