/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Utils;

import DummyCore.Core.CoreInitialiser;
import DummyCore.Utils.Coord4D;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class DummyChunkLoader {
    public Set<ChunkPos> chunkSet = new HashSet<ChunkPos>();
    public TileEntity tileEntity;
    public ForgeChunkManager.Ticket chunkTicket;
    public Coord4D prevCoord;

    public DummyChunkLoader(TileEntity tile) {
        if (!(tile instanceof IChunkLoader)) {
            throw new IllegalArgumentException("The TileEntity passed in should implement IChunkLoader");
        }
        this.tileEntity = tile;
    }

    public void setTicket(ForgeChunkManager.Ticket t) {
        if (this.chunkTicket != t && this.chunkTicket != null && this.chunkTicket.world == this.tileEntity.func_145831_w()) {
            for (ChunkPos chunk : this.chunkTicket.getChunkList()) {
                if (!ForgeChunkManager.getPersistentChunksFor((World)this.tileEntity.func_145831_w()).keys().contains((Object)chunk)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        this.chunkTicket = t;
    }

    public void release() {
        this.setTicket(null);
    }

    public void sortChunks() {
        if (this.chunkTicket != null) {
            for (ChunkPos chunk : this.chunkTicket.getChunkList()) {
                if (this.chunkSet.contains(chunk) || !ForgeChunkManager.getPersistentChunksFor((World)this.tileEntity.func_145831_w()).keys().contains((Object)chunk)) continue;
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
            for (ChunkPos chunk : this.chunkSet) {
                if (this.chunkTicket.getChunkList().contains((Object)chunk)) continue;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
            }
        }
    }

    public void refreshChunkSet() {
        IChunkLoader loader = (IChunkLoader)this.tileEntity;
        if (!this.chunkSet.equals(loader.getChunks())) {
            this.chunkSet = loader.getChunks();
            this.sortChunks();
        }
    }

    public void forceChunks(ForgeChunkManager.Ticket ticket) {
        this.setTicket(ticket);
        for (ChunkPos chunk : this.chunkSet) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkPos)chunk);
        }
    }

    public void tick() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            ForgeChunkManager.Ticket ticket;
            if (this.prevCoord == null || !this.prevCoord.equals(new Coord4D(this.tileEntity))) {
                this.release();
                this.prevCoord = new Coord4D(this.tileEntity);
            }
            if (!(this.chunkTicket == null || this.canOperate() && this.chunkTicket.world == this.tileEntity.func_145831_w())) {
                this.release();
            }
            this.refreshChunkSet();
            if (this.canOperate() && this.chunkTicket == null && (ticket = ForgeChunkManager.requestTicket((Object)CoreInitialiser.instance, (World)this.tileEntity.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
                ticket.getModData().func_74768_a("x", this.tileEntity.func_174877_v().func_177958_n());
                ticket.getModData().func_74768_a("y", this.tileEntity.func_174877_v().func_177956_o());
                ticket.getModData().func_74768_a("z", this.tileEntity.func_174877_v().func_177952_p());
                this.forceChunks(ticket);
            }
        }
    }

    public boolean canOperate() {
        return ((IChunkLoader)this.tileEntity).canOperate();
    }

    public void read(NBTTagCompound nbtTags) {
        this.prevCoord = Coord4D.fromString(nbtTags.func_74779_i("prevCoord"));
        this.chunkSet.clear();
        NBTTagList list = nbtTags.func_150295_c("chunkSet", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            this.chunkSet.add(new ChunkPos(compound.func_74762_e("chunkX"), compound.func_74762_e("chunkZ")));
        }
    }

    public void write(NBTTagCompound nbtTags) {
        if (this.prevCoord != null) {
            nbtTags.func_74778_a("prevCoord", this.prevCoord.toString());
        }
        NBTTagList list = new NBTTagList();
        for (ChunkPos pos : this.chunkSet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("chunkX", pos.field_77276_a);
            compound.func_74768_a("chunkZ", pos.field_77275_b);
            list.func_74742_a((NBTBase)compound);
        }
        nbtTags.func_74782_a("chunkSet", (NBTBase)list);
    }

    public void invalidate() {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            this.release();
        }
    }

    public static interface IChunkLoader {
        public Set<ChunkPos> getChunks();

        public DummyChunkLoader getChunkLoader();

        public boolean canOperate();
    }

    public static class TicketHandler
    implements ForgeChunkManager.LoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                int z;
                int y;
                int x = ticket.getModData().func_74762_e("xCoord");
                TileEntity tileEntity = world.func_175625_s(new BlockPos(x, y = ticket.getModData().func_74762_e("yCoord"), z = ticket.getModData().func_74762_e("zCoord")));
                if (!(tileEntity instanceof IChunkLoader)) continue;
                ((IChunkLoader)tileEntity).getChunkLoader().refreshChunkSet();
                ((IChunkLoader)tileEntity).getChunkLoader().forceChunks(ticket);
            }
        }
    }
}

