/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.Client;

import DummyCore.Client.IBlockColor;
import DummyCore.Client.IItemColor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class ModelUtils {
    public static final ArrayList<Pair<IBlockColor, Block>> BLOCK_COLORS = new ArrayList();
    public static final ArrayList<Pair<IItemColor, Item>> ITEM_COLORS = new ArrayList();
    public static final ArrayList<Pair<ModelResourceLocation, IBakedModel>> MODELS = new ArrayList();

    @SideOnly(value=Side.CLIENT)
    public static void registerColors() {
        for (Pair<IBlockColor, Block> pair : BLOCK_COLORS) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(((IBlockColor)pair.getLeft()).toMCBlockColor(), new Block[]{(Block)pair.getRight()});
        }
        for (Pair pair : ITEM_COLORS) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(((IItemColor)pair.getLeft()).toMCItemColor(), new Item[]{(Item)pair.getRight()});
        }
    }

    public static void registerModel(ModelResourceLocation mrl, IBakedModel ibm) {
        MODELS.add((Pair<ModelResourceLocation, IBakedModel>)Pair.of((Object)mrl, (Object)ibm));
    }

    public static void setItemModelInventory(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName().func_110624_b() + ":item/" + item.getRegistryName().func_110623_a(), "inventory"));
    }

    public static void setItemModels(Item item, List<Pair<Integer, ModelResourceLocation>> list) {
        for (Pair<Integer, ModelResourceLocation> pair : list) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)pair.getLeft()), (ModelResourceLocation)((ModelResourceLocation)pair.getRight()));
        }
    }

    public static void setItemModels(Item item, int maxMeta, IntFunction<ModelResourceLocation> func) {
        for (int i = 0; i < maxMeta; ++i) {
            if (func.apply(i) == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)func.apply(i));
        }
    }

    public static void setBlockModelInventory(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    public static void setBlockModels(Block block, List<Pair<Integer, ModelResourceLocation>> list) {
        for (Pair<Integer, ModelResourceLocation> pair : list) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)((Integer)pair.getLeft()), (ModelResourceLocation)((ModelResourceLocation)pair.getRight()));
        }
    }

    public static void setBlockModels(Block block, int maxMeta, IntFunction<ModelResourceLocation> func) {
        for (int i = 0; i < maxMeta; ++i) {
            if (func.apply(i) == null) continue;
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)i, (ModelResourceLocation)func.apply(i));
        }
    }

    public static void setItemModelSingleIcon(Item item, String ... args) {
        MeshDefinitionSingleIcon mesh = new MeshDefinitionSingleIcon(args);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mesh.location});
    }

    public static void setItemModelSingleIcon(Item item, ModelResourceLocation args) {
        MeshDefinitionSingleIcon mesh = new MeshDefinitionSingleIcon(args);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{mesh.location});
    }

    public static void setItemModelNBTActive(Item item, String ... args) {
        MeshDefinitionNBTActive mesh = new MeshDefinitionNBTActive(args);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])mesh.location);
    }

    public static void setItemModelNBTActive(Item item, ResourceLocation args) {
        MeshDefinitionNBTActive mesh = new MeshDefinitionNBTActive(args);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mesh);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])mesh.location);
    }

    public static class MeshDefinitionNBTActive
    implements ItemMeshDefinition {
        public String name;
        public ModelResourceLocation[] location = new ModelResourceLocation[2];

        public MeshDefinitionNBTActive(String ... args) {
            if (args.length == 1) {
                this.name = args[0];
            } else if (args.length == 2) {
                this.name = args[0] + ':' + args[1];
            } else {
                throw new IllegalArgumentException("No arguments or more than 2 arguments!");
            }
            this.location[0] = new ModelResourceLocation(this.name, "active=false");
            this.location[1] = new ModelResourceLocation(this.name, "active=true");
        }

        public MeshDefinitionNBTActive(ResourceLocation rl) {
            this.location[0] = new ModelResourceLocation(rl, "active=false");
            this.location[1] = new ModelResourceLocation(rl, "active=true");
            this.name = rl.toString();
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("active") ? this.location[1] : this.location[0];
        }
    }

    public static class MeshDefinitionSingleIcon
    implements ItemMeshDefinition {
        public String name;
        public String variant;
        public ModelResourceLocation location;

        public MeshDefinitionSingleIcon(String ... args) {
            if (args.length == 1) {
                this.name = args[0];
                this.variant = "inventory";
            } else if (args.length == 2) {
                this.name = args[0];
                this.variant = args[1];
            } else if (args.length == 3) {
                this.name = args[0] + ':' + args[1];
                this.variant = args[2];
            } else {
                throw new IllegalArgumentException("No arguments or more than 3 arguments!");
            }
            this.location = new ModelResourceLocation(this.name, this.variant);
        }

        public MeshDefinitionSingleIcon(ModelResourceLocation mrl) {
            this.location = mrl;
            this.name = mrl.func_110624_b() + ':' + mrl.func_110623_a();
            this.variant = mrl.func_177518_c();
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }
}

