/*
 * Decompiled with CFR 0.152.
 */
package DummyCore.ASM;

import DummyCore.Utils.ASMManager;
import DummyCore.Utils.LoadingUtils;
import DummyCore.Utils.Notifier;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class DCASMManager
implements IClassTransformer {
    public DCASMManager() {
        try {
            Class.forName("DummyCore.Utils.ASMManager");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        name = transformedName;
        if (ASMManager.strictCompareByEnvironment(name, "net.minecraft.client.renderer.RenderItem", "net.minecraft.client.renderer.RenderItem")) {
            return this.handleItemOverlays(name, basicClass);
        }
        if (basicClass != null) {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            if (ASMManager.checkAnnotationForClass(classNode, "LDummyCore/Utils/DCASMCheck;")) {
                return this.handleClass(name, transformedName, basicClass, classNode, classReader);
            }
        }
        return basicClass;
    }

    public byte[] handleItemOverlays(String name, byte[] basicClass) {
        Notifier.notifyCustomMod("DCASM", "Transforming " + name);
        Notifier.notifyCustomMod("DCASM", "Initial byte[] count: " + basicClass.length);
        byte[] basic = (byte[])basicClass.clone();
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 8);
            ClassWriter cw = new ClassWriter(1);
            MethodNode mn = ASMManager.getMethod(classNode, "renderItemOverlayIntoGUI", "func_180453_a!&!a", "(Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", "(Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V!&!(Lbdl;Ladz;IILjava/lang/String;)V");
            InsnList lst = new InsnList();
            lst.add((AbstractInsnNode)new LabelNode());
            lst.add((AbstractInsnNode)new VarInsnNode(25, 1));
            lst.add((AbstractInsnNode)new VarInsnNode(25, 2));
            lst.add((AbstractInsnNode)new VarInsnNode(21, 3));
            lst.add((AbstractInsnNode)new VarInsnNode(21, 4));
            lst.add((AbstractInsnNode)new VarInsnNode(25, 5));
            lst.add((AbstractInsnNode)new MethodInsnNode(184, "DummyCore/Utils/DummyHooks", "renderItemOverlayIntoGUI", "(Lnet/minecraft/client/gui/FontRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V", false));
            mn.instructions.insert(mn.instructions.get(1), lst);
            classNode.accept((ClassVisitor)cw);
            byte[] bArray = cw.toByteArray();
            Notifier.notifyCustomMod("DCASM", "Finished Transforming " + name);
            Notifier.notifyCustomMod("DCASM", "Final byte[] count: " + bArray.length);
            return bArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            LoadingUtils.makeACrash("[DCASM]Fatal errors occured patching " + name + "! This modification is marked as OPTIONAL, thus the loading can continue normally.", e, false);
            return basic;
        }
    }

    public byte[] handleClass(String name, String transformedName, byte[] basicClass, ClassNode cn, ClassReader cr) {
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has requested a DummyCore ASM check via DummyCore/Utils/DCASMCheck annotation. Examining...");
        String[] checkedClss = new String[]{};
        for (int i = 0; i < cn.invisibleAnnotations.size(); ++i) {
            AnnotationNode node = (AnnotationNode)cn.invisibleAnnotations.get(i);
            if (!node.desc.equalsIgnoreCase("LDummyCore/Utils/ExistenceCheck;") || node.values == null || node.values.size() <= 0) continue;
            Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has requested a DummyCore ASM check on it's implementations via DummyCore/Utils/ExistenceCheck annotation. Examining...");
            List classes = (List)List.class.cast(node.values.get(1));
            checkedClss = new String[classes.size()];
            checkedClss = (String[])String[].class.cast(classes.toArray(checkedClss));
            break;
        }
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has given the next interfaces to check: " + Arrays.asList(checkedClss));
        ClassWriter cw = new ClassWriter(1);
        if (checkedClss.length > 0) {
            block1: for (int i = 0; i < checkedClss.length; ++i) {
                if (!this.classExists(checkedClss[i])) {
                    for (int j = 0; j < cn.interfaces.size(); ++j) {
                        if (!((String)cn.interfaces.get(j)).equalsIgnoreCase(checkedClss[i].replace('.', '/'))) continue;
                        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has a " + (String)cn.interfaces.get(j) + " implementation, but the referenced class was not found. Removing the given interface.");
                        cn.interfaces.remove(j);
                        continue block1;
                    }
                    continue;
                }
                Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has a " + checkedClss[i] + " implementation, and the referenced class was found. Skipping to the next interface...");
            }
        }
        cn.accept((ClassVisitor)cw);
        Notifier.notifyCustomMod("DummyCoreASM", "Class " + name + " has been checked.");
        return cw.toByteArray();
    }

    public boolean classExists(String s) {
        try {
            Class<?> c = Class.forName(s);
            return c != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

