/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.data.label.labels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.utils.Utilities;
import mezz.jei.api.gui.IRecipeLayout;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class LFluidStack
extends ILabel.Impl {
    public static final String IDENTIFIER = "fluidStack";
    public static final String KEY_FLUID = "fluid";
    public static final String KEY_NBT = "nbt";
    Fluid fluid;
    NBTTagCompound nbt;
    FluidStack temp;
    private static final String TIC_CLASS = "slimeknights.tconstruct.plugin.jei.casting.CastingRecipeCategory";

    public FluidStack getRepresentation() {
        return this.temp;
    }

    @Override
    public boolean acceptPercent() {
        return false;
    }

    public LFluidStack(FluidStack fs) {
        this(fs.amount, fs.getFluid(), fs.tag);
    }

    public LFluidStack(long amount, Fluid fluid) {
        this(amount, fluid, null);
    }

    public LFluidStack(long amount, Fluid fluid, @Nullable NBTTagCompound nbt) {
        super(amount, false);
        this.init(fluid, nbt);
    }

    public LFluidStack(NBTTagCompound nbt) {
        super(nbt);
        String id = nbt.func_74779_i(KEY_FLUID);
        Fluid f = FluidRegistry.getFluid((String)id);
        if (f == null) {
            throw new ILabel.Serializer.SerializationException("Fluid " + id + " cannot be resolved, ignoring");
        }
        this.init(f, nbt.func_74764_b(KEY_NBT) ? nbt.func_74775_l(KEY_NBT) : null);
    }

    private void init(Fluid fluid, @Nullable NBTTagCompound nbt) {
        this.fluid = fluid;
        this.nbt = nbt;
        this.temp = new FluidStack(fluid, 1, nbt);
    }

    public LFluidStack(LFluidStack lfs) {
        super(lfs);
        this.fluid = lfs.fluid;
        this.nbt = lfs.nbt;
        this.temp = lfs.temp;
    }

    @Override
    protected int getMultiplier() {
        return 100;
    }

    @Override
    public String getAmountString(boolean round) {
        return this.amount >= 1000L ? Utilities.cutNumber((float)this.amount / 1000.0f, 4) + "B" : Long.toString(this.amount) + "mB";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return this.temp.getLocalizedName();
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public boolean matches(Object l) {
        if (l instanceof LFluidStack) {
            LFluidStack lfs = (LFluidStack)l;
            return (this.nbt == null ? lfs.nbt == null : this.nbt.equals((Object)lfs.nbt)) && this.fluid == lfs.fluid;
        }
        return false;
    }

    @Override
    public LFluidStack copy() {
        return new LFluidStack(this);
    }

    @Override
    public NBTTagCompound toNbt() {
        NBTTagCompound ret = super.toNbt();
        ret.func_74778_a(KEY_FLUID, FluidRegistry.getFluidName((Fluid)this.fluid));
        if (this.nbt != null) {
            ret.func_74782_a(KEY_NBT, (NBTBase)this.nbt);
        }
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getToolTip(List<String> existing, boolean detailed) {
        if (detailed) {
            existing.add("\u00a78" + Utilities.I18n.get("label.common.amount", Long.toString(this.getAmount())) + "mB");
        }
        existing.add("\u00a79\u00a7o" + Utilities.getModName(this.fluid));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawLabel(JecaGui gui) {
        gui.drawResource(Resource.LBL_FLUID, 0, 0);
        gui.drawFluid(this.fluid, 2, 2, 12, 12);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.fluid.getUnlocalizedName().hashCode() ^ (this.nbt == null ? 0 : this.nbt.hashCode());
    }

    public static List<ILabel> suggest(List<ILabel> iss, @Nullable IRecipeLayout rl) {
        if (rl != null && rl.getRecipeCategory().getClass().getName().equals(TIC_CLASS) && iss.get(0) instanceof LFluidStack) {
            return Collections.singletonList(iss.get(0).copy().multiply(0.5f));
        }
        return new ArrayList<ILabel>();
    }

    public static boolean merge(ILabel a, ILabel b) {
        if (a instanceof LFluidStack && b instanceof LFluidStack) {
            return a.matches(b);
        }
        return false;
    }
}

