/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IModeChanger;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DiviningRod
extends ItemPE
implements IModeChanger {
    private final String[] modes;

    public DiviningRod(String[] modeDesc) {
        this.modes = modeDesc;
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        PlayerHelper.swingItem(player, hand);
        ArrayList<Long> emcValues = new ArrayList<Long>();
        long totalEmc = 0L;
        int numBlocks = 0;
        byte mode = this.getMode(player.func_184586_b(hand));
        int depth = this.getDepthFromMode(mode);
        AxisAlignedBB box = WorldHelper.getDeepBox(pos, facing, depth);
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(box)) {
            List drops;
            IBlockState state = world.func_180495_p(digPos);
            Block block = state.func_177230_c();
            if (world.func_175623_d(digPos) || (drops = block.getDrops((IBlockAccess)world, digPos, state, 0)).size() == 0) continue;
            ItemStack blockStack = (ItemStack)drops.get(0);
            long blockEmc = EMCHelper.getEmcValue(blockStack);
            if (blockEmc == 0L) {
                Map map = FurnaceRecipes.func_77602_a().func_77599_b();
                for (Map.Entry entry : map.entrySet()) {
                    long currentValue;
                    if (entry == null || ((ItemStack)entry.getKey()).func_190926_b() || !ItemHelper.areItemStacksEqualIgnoreNBT((ItemStack)entry.getKey(), blockStack) || (currentValue = EMCHelper.getEmcValue((ItemStack)entry.getValue())) == 0L) continue;
                    if (!emcValues.contains(currentValue)) {
                        emcValues.add(currentValue);
                    }
                    totalEmc += currentValue;
                }
            } else {
                if (!emcValues.contains(blockEmc)) {
                    emcValues.add(blockEmc);
                }
                totalEmc += blockEmc;
            }
            ++numBlocks;
        }
        if (numBlocks == 0) {
            return EnumActionResult.FAIL;
        }
        long[] maxValues = new long[3];
        for (int i = 0; i < 3; ++i) {
            maxValues[i] = 1L;
        }
        emcValues.sort(Comparator.reverseOrder());
        int num = emcValues.size() >= 3 ? 3 : emcValues.size();
        for (int i = 0; i < num; ++i) {
            maxValues[i] = (Long)emcValues.get(i);
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.divining.avgemc", new Object[]{numBlocks, totalEmc / (long)numBlocks}));
        if (this == ObjHandler.dRod2 || this == ObjHandler.dRod3) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.divining.maxemc", new Object[]{maxValues[0]}));
        }
        if (this == ObjHandler.dRod3) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.divining.secondmax", new Object[]{maxValues[1]}));
            player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.divining.thirdmax", new Object[]{maxValues[2]}));
        }
        return EnumActionResult.SUCCESS;
    }

    private int getDepthFromMode(byte mode) {
        String modeDesc = this.modes[mode];
        return Integer.parseInt(modeDesc.substring(0, modeDesc.indexOf(120))) - 1;
    }

    @Override
    public byte getMode(@Nonnull ItemStack stack) {
        return ItemHelper.getOrCreateCompound(stack).func_74771_c("Mode");
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        if (this.modes.length == 1) {
            return false;
        }
        if (this.getMode(stack) == this.modes.length - 1) {
            ItemHelper.getOrCreateCompound(stack).func_74774_a("Mode", (byte)0);
        } else {
            ItemHelper.getOrCreateCompound(stack).func_74774_a("Mode", (byte)(this.getMode(stack) + 1));
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("pe.item.mode_switch", new Object[]{this.modes[this.getMode(stack)]}));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        list.add(I18n.func_135052_a((String)"pe.item.mode", (Object[])new Object[0]) + ": " + TextFormatting.AQUA + this.modes[this.getMode(stack)]);
    }
}

