/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.entity;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;

public class EntityHomingArrow
extends EntityTippedArrow {
    private static final DataParameter<Integer> DW_TARGET_ID = EntityDataManager.func_187226_a(EntityHomingArrow.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final int NO_TARGET = -1;
    private int newTargetCooldown = 0;

    public EntityHomingArrow(World world) {
        super(world);
    }

    public EntityHomingArrow(World world, EntityLivingBase par2, float par3) {
        super(world, par2);
        this.func_70239_b(par3);
        this.field_70251_a = EntityArrow.PickupStatus.CREATIVE_ONLY;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DW_TARGET_ID, (Object)-1);
    }

    protected void func_184548_a(@Nonnull EntityLivingBase living) {
        super.func_184548_a(living);
        living.field_70172_ad = 0;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 3) {
            if (this.hasTarget() && (!this.getTarget().func_70089_S() || this.field_70254_i)) {
                this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)-1);
            }
            if (!this.hasTarget() && !this.field_70254_i && this.newTargetCooldown <= 0) {
                this.findNewTarget();
            } else {
                --this.newTargetCooldown;
            }
        }
        if (this.field_70173_aa > 3 && this.hasTarget() && !this.field_70254_i) {
            this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70159_w / 4.0, this.field_70163_u + this.field_70181_x / 4.0, this.field_70161_v + this.field_70179_y / 4.0, -this.field_70159_w / 2.0, -this.field_70181_x / 2.0 + 0.2, -this.field_70179_y / 2.0, new int[0]);
            this.func_130014_f_().func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + this.field_70159_w / 4.0, this.field_70163_u + this.field_70181_x / 4.0, this.field_70161_v + this.field_70179_y / 4.0, -this.field_70159_w / 2.0, -this.field_70181_x / 2.0 + 0.2, -this.field_70179_y / 2.0, new int[0]);
            EntityLiving target = this.getTarget();
            Vector3d arrowLoc = new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vector3d targetLoc = new Vector3d(target.field_70165_t, target.field_70163_u + (double)(target.field_70131_O / 2.0f), target.field_70161_v);
            Vector3d lookVec = new Vector3d(targetLoc);
            lookVec.sub((Tuple3d)arrowLoc);
            Vector3d arrowMotion = new Vector3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            double theta = this.wrap180Radian(arrowMotion.angle(lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vector3d crossProduct = new Vector3d();
            crossProduct.cross(arrowMotion, lookVec);
            crossProduct.normalize();
            Matrix4d transform = new Matrix4d();
            transform.set(new AxisAngle4d(crossProduct, theta));
            Vector3d adjustedLookVec = new Vector3d(arrowMotion);
            transform.transform(arrowMotion, adjustedLookVec);
            this.func_70186_c(adjustedLookVec.x, adjustedLookVec.y, adjustedLookVec.z, 1.0f, 0.0f);
        }
        super.func_70071_h_();
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }

    private void findNewTarget() {
        List candidates = this.field_70170_p.func_72872_a(EntityLiving.class, this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
        if (!candidates.isEmpty()) {
            candidates.sort(Comparator.comparing(arg_0 -> ((EntityHomingArrow)this).func_70068_e(arg_0), Double::compare));
            this.field_70180_af.func_187227_b(DW_TARGET_ID, (Object)((EntityLiving)candidates.get(0)).func_145782_y());
        }
        this.newTargetCooldown = 5;
    }

    private EntityLiving getTarget() {
        return (EntityLiving)this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DW_TARGET_ID)).intValue());
    }

    private boolean hasTarget() {
        return this.getTarget() != null;
    }

    private double wrap180Radian(double radian) {
        radian %= Math.PI * 2;
        while (radian >= Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    private double clampAbs(double param, double maxMagnitude) {
        if (Math.abs(param) > maxMagnitude) {
            param = param < 0.0 ? -Math.abs(maxMagnitude) : Math.abs(maxMagnitude);
        }
        return param;
    }
}

