/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import java.util.Map;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.AbstractMappingCollector;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;
import moze_intel.projecte.emc.json.NSSItem;
import moze_intel.projecte.emc.json.NormalizedSimpleStack;

public class WildcardSetValueFixCollector<V extends Comparable<V>, A extends IValueArithmetic>
extends AbstractMappingCollector<NormalizedSimpleStack, V, A> {
    private final IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner;

    public WildcardSetValueFixCollector(IExtendedMappingCollector<NormalizedSimpleStack, V, A> inner) {
        super(inner.getArithmetic());
        this.inner = inner;
    }

    private boolean isWildCard(NormalizedSimpleStack nss) {
        return nss instanceof NSSItem && ((NSSItem)nss).damage == Short.MAX_VALUE;
    }

    @Override
    public void setValueBefore(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            for (NormalizedSimpleStack nss : NormalizedSimpleStack.getVariants(((NSSItem)something).itemName)) {
                this.inner.setValueBefore(nss, value);
            }
        } else {
            this.inner.setValueBefore(something, value);
        }
    }

    @Override
    public void setValueAfter(NormalizedSimpleStack something, V value) {
        if (this.isWildCard(something)) {
            for (NormalizedSimpleStack nss : NormalizedSimpleStack.getVariants(((NSSItem)something).itemName)) {
                this.inner.setValueAfter(nss, value);
            }
        } else {
            this.inner.setValueAfter(something, value);
        }
    }

    @Override
    public void setValueFromConversion(int outnumber, NormalizedSimpleStack something, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount) {
        if (this.isWildCard(something)) {
            for (NormalizedSimpleStack nss : NormalizedSimpleStack.getVariants(((NSSItem)something).itemName)) {
                this.inner.setValueFromConversion(outnumber, nss, ingredientsWithAmount);
            }
        } else {
            this.inner.setValueFromConversion(outnumber, something, ingredientsWithAmount);
        }
    }

    @Override
    public void addConversion(int outnumber, NormalizedSimpleStack output, Map<NormalizedSimpleStack, Integer> ingredientsWithAmount, A arithmeticForConversion) {
        this.inner.addConversion(outnumber, output, ingredientsWithAmount, arithmeticForConversion);
    }

    @Override
    public void finishCollection() {
        this.inner.finishCollection();
    }
}

