/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.patchouli.client.book.AbstractReadStateHolder;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookIcon;
import vazkii.patchouli.client.book.ClientBookRegistry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.template.BookTemplate;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.util.ItemStackUtil;

public class BookContents
extends AbstractReadStateHolder {
    private static final String[] ORDINAL_SUFFIXES = new String[]{"th", "st", "nd", "rd", "th", "th", "th", "th", "th", "th"};
    protected static final String DEFAULT_LANG = "en_us";
    public static final HashMap<ResourceLocation, Supplier<BookTemplate>> addonTemplates = new HashMap();
    public final Book book;
    public Map<ResourceLocation, BookCategory> categories = new HashMap<ResourceLocation, BookCategory>();
    public Map<ResourceLocation, BookEntry> entries = new HashMap<ResourceLocation, BookEntry>();
    public Map<ResourceLocation, Supplier<BookTemplate>> templates = new HashMap<ResourceLocation, Supplier<BookTemplate>>();
    public Map<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>> recipeMappings = new HashMap<ItemStackUtil.StackWrapper, Pair<BookEntry, Integer>>();
    private boolean errored = false;
    private Exception exception = null;
    public Stack<GuiBook> guiStack = new Stack();
    public GuiBook currentGui;
    public BookIcon indexIcon;

    public BookContents(Book book) {
        this.book = book;
    }

    public boolean isErrored() {
        return this.errored;
    }

    public Exception getException() {
        return this.exception;
    }

    public Pair<BookEntry, Integer> getEntryForStack(ItemStack stack) {
        return this.recipeMappings.get(ItemStackUtil.wrapStack(stack));
    }

    public GuiBook getCurrentGui() {
        if (this.currentGui == null) {
            this.currentGui = new GuiBookLanding(this.book);
        }
        return this.currentGui;
    }

    public void openLexiconGui(GuiBook gui, boolean push) {
        if (gui.canBeOpened()) {
            Minecraft mc = Minecraft.func_71410_x();
            if (push && mc.field_71462_r instanceof GuiBook && gui != mc.field_71462_r) {
                this.guiStack.push((GuiBook)mc.field_71462_r);
            }
            mc.func_147108_a((GuiScreen)gui);
            gui.onFirstOpened();
        }
    }

    public String getSubtitle() {
        String editionStr;
        try {
            int ver = Integer.parseInt(this.book.version);
            if (ver == 0) {
                return I18n.func_135052_a((String)this.book.subtitle, (Object[])new Object[0]);
            }
            editionStr = BookContents.numberToOrdinal(ver);
        }
        catch (NumberFormatException e) {
            editionStr = I18n.func_135052_a((String)"patchouli.gui.lexicon.dev_edition", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"patchouli.gui.lexicon.edition_str", (Object[])new Object[]{editionStr});
    }

    public void reload(boolean isOverride) {
        this.errored = false;
        if (!isOverride) {
            this.currentGui = null;
            this.guiStack.clear();
            this.categories.clear();
            this.entries.clear();
            this.templates.clear();
            this.recipeMappings.clear();
            this.templates.putAll(addonTemplates);
            this.indexIcon = this.book.indexIconRaw == null || this.book.indexIconRaw.isEmpty() ? new BookIcon(this.book.getBookItem()) : new BookIcon(this.book.indexIconRaw);
        }
        ArrayList<ResourceLocation> foundCategories = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> foundEntries = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> foundTemplates = new ArrayList<ResourceLocation>();
        List mods = Loader.instance().getActiveModList();
        try {
            String bookName = this.book.resourceLoc.func_110623_a();
            this.findFiles("categories", foundCategories);
            this.findFiles("entries", foundEntries);
            this.findFiles("templates", foundTemplates);
            foundCategories.forEach(c -> this.loadCategory((ResourceLocation)c, new ResourceLocation(c.func_110624_b(), String.format("%s/%s/%s/categories/%s.json", "patchouli_books", bookName, DEFAULT_LANG, c.func_110623_a())), this.book));
            foundEntries.forEach(e -> this.loadEntry((ResourceLocation)e, new ResourceLocation(e.func_110624_b(), String.format("%s/%s/%s/entries/%s.json", "patchouli_books", bookName, DEFAULT_LANG, e.func_110623_a())), this.book));
            foundTemplates.forEach(e -> this.loadTemplate((ResourceLocation)e, new ResourceLocation(e.func_110624_b(), String.format("%s/%s/%s/templates/%s.json", "patchouli_books", bookName, DEFAULT_LANG, e.func_110623_a())), this.book));
            this.entries.forEach((res, entry) -> {
                try {
                    entry.build((ResourceLocation)res);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while loading entry " + res, e);
                }
            });
            this.categories.forEach((res, category) -> {
                try {
                    category.build((ResourceLocation)res);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error while loading category " + res, e);
                }
            });
        }
        catch (Exception e2) {
            this.exception = e2;
            this.errored = true;
            e2.printStackTrace();
        }
    }

    protected void findFiles(String dir, List<ResourceLocation> list) {
        ModContainer mod = this.book.owner;
        String id = mod.getModId();
        CraftingHelper.findFiles((ModContainer)mod, (String)String.format("assets/%s/%s/%s/%s/%s", id, "patchouli_books", this.book.resourceLoc.func_110623_a(), DEFAULT_LANG, dir), null, this.pred(id, list), (boolean)false, (boolean)false);
    }

    private BiFunction<Path, Path, Boolean> pred(String modId, List<ResourceLocation> list) {
        return (root, file) -> {
            Path rel = root.relativize((Path)file);
            String relName = rel.toString();
            if (relName.endsWith(".json")) {
                relName = FilenameUtils.removeExtension((String)FilenameUtils.separatorsToUnix((String)relName));
                ResourceLocation res = new ResourceLocation(modId, relName);
                list.add(res);
            }
            return true;
        };
    }

    private void loadCategory(ResourceLocation key, ResourceLocation res, Book book) {
        try (Reader stream = this.loadLocalizedJson(res);){
            BookCategory category = (BookCategory)ClientBookRegistry.INSTANCE.gson.fromJson(stream, BookCategory.class);
            if (category == null) {
                throw new IllegalArgumentException(res + " does not exist.");
            }
            category.setBook(book);
            if (category.canAdd()) {
                this.categories.put(key, category);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadEntry(ResourceLocation key, ResourceLocation res, Book book) {
        try (Reader stream = this.loadLocalizedJson(res);){
            BookEntry entry = (BookEntry)ClientBookRegistry.INSTANCE.gson.fromJson(stream, BookEntry.class);
            if (entry == null) {
                throw new IllegalArgumentException(res + " does not exist.");
            }
            entry.setBook(book);
            if (entry.canAdd()) {
                BookCategory category = entry.getCategory();
                if (category != null) {
                    category.addEntry(entry);
                } else {
                    new RuntimeException("Entry " + key + " does not have a valid category.").printStackTrace();
                }
                this.entries.put(key, entry);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void loadTemplate(ResourceLocation key, ResourceLocation res, Book book) {
        Supplier<BookTemplate> supplier = () -> {
            try (Reader stream = this.loadLocalizedJson(res);){
                BookTemplate bookTemplate = (BookTemplate)ClientBookRegistry.INSTANCE.gson.fromJson(stream, BookTemplate.class);
                return bookTemplate;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        };
        BookTemplate template = supplier.get();
        if (template == null) {
            throw new IllegalArgumentException(res + " could not be instantiated by the supplier.");
        }
        this.templates.put(key, supplier);
    }

    private Reader loadLocalizedJson(ResourceLocation res) {
        ResourceLocation localized = new ResourceLocation(res.func_110624_b(), res.func_110623_a().replaceAll(DEFAULT_LANG, ClientBookRegistry.INSTANCE.currentLang));
        InputStream input = this.loadJson(localized, res);
        if (input == null) {
            throw new IllegalArgumentException(res + " does not exist.");
        }
        return new InputStreamReader((InputStream)new BufferedInputStream(input), StandardCharsets.UTF_8);
    }

    protected InputStream loadJson(ResourceLocation resloc, ResourceLocation fallback) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resloc).func_110527_b();
        }
        catch (IOException iOException) {
            if (fallback != null) {
                System.err.println("Patchouli failed to load " + resloc + ". Switching to fallback.");
                return this.loadJson(fallback, null);
            }
            return null;
        }
    }

    private static String numberToOrdinal(int i) {
        return i % 100 == 11 || i % 100 == 12 || i % 100 == 13 ? i + "th" : i + ORDINAL_SUFFIXES[i % 10];
    }

    @Override
    protected EntryDisplayState computeReadState() {
        Stream<EntryDisplayState> stream = this.categories.values().stream().filter(BookCategory::isRootCategory).map(AbstractReadStateHolder::getReadState);
        return BookContents.mostImportantState(stream);
    }
}

