/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidTank;

public interface ISerializableTanks {
    public static final String NBT_SAVED_TANKS = "SavedTanks";

    @Nonnull
    public Map<String, FluidTank> getSerializableTanks();

    default public void deserializeTanks(NBTTagCompound tag) {
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            entry.getValue().readFromNBT(tag.func_74775_l(entry.getKey()));
        }
    }

    default public void serializeTanks(ItemStack customDrop) {
        for (Map.Entry<String, FluidTank> entry : this.getSerializableTanks().entrySet()) {
            ISerializableTanks.serializeTank(entry.getValue(), customDrop, entry.getKey());
        }
    }

    public static void serializeTank(FluidTank tank, ItemStack stack, String tagName) {
        NBTTagCompound subTag = NBTUtil.getCompoundTag(stack, NBT_SAVED_TANKS);
        if (tank.getFluid() != null && tank.getFluid().amount > 0) {
            subTag.func_74782_a(tagName, (NBTBase)tank.writeToNBT(new NBTTagCompound()));
        } else {
            subTag.func_82580_o(tagName);
        }
        if (!subTag.func_82582_d()) {
            NBTUtil.setCompoundTag(stack, NBT_SAVED_TANKS, (NBTBase)subTag);
        } else {
            NBTUtil.removeTag(stack, NBT_SAVED_TANKS);
        }
    }

    public static FluidTank deserializeTank(ItemStack stack, String tagName, int capacity) {
        if (NBTUtil.hasTag(stack, NBT_SAVED_TANKS)) {
            FluidTank tank = new FluidTank(capacity);
            NBTTagCompound subTag = NBTUtil.getCompoundTag(stack, NBT_SAVED_TANKS);
            return tank.readFromNBT(subTag.func_74775_l(tagName));
        }
        return null;
    }
}

