/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.thirdparty.mekanism.Mekanism;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import mekanism.api.IHeatTransfer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class MekanismHeatAdapter
implements IHeatTransfer {
    private TileEntityBase te;
    private IHeatExchangerLogic logic;
    private double heat;

    public IHeatTransfer setup(TileEntityBase te, EnumFacing side) {
        this.te = te;
        this.logic = ((IHeatExchanger)((Object)te)).getHeatExchangerLogic(side);
        return this.logic == null ? null : this;
    }

    public double getTemp() {
        return this.logic.getTemperature();
    }

    public double getInverseConductionCoefficient() {
        return this.logic.getThermalResistance() * ConfigHandler.integration.mekThermalResistanceMult;
    }

    public double getInsulationCoefficient(EnumFacing enumFacing) {
        return 1000.0;
    }

    public void transferHeatTo(double v) {
        this.logic.addHeat(v * ConfigHandler.integration.mekHeatEfficiency);
    }

    public double[] simulateHeat() {
        return new double[0];
    }

    public double applyTemperatureChange() {
        return this.logic.getTemperature();
    }

    public boolean canConnectHeat(EnumFacing enumFacing) {
        return ((IHeatExchanger)((Object)this.te)).getHeatExchangerLogic(enumFacing) != null;
    }

    public IHeatTransfer getAdjacent(EnumFacing enumFacing) {
        TileEntity neighbour = this.te.func_145831_w().func_175625_s(this.te.func_174877_v().func_177972_a(enumFacing));
        if (neighbour != null && neighbour.hasCapability(Mekanism.CAPABILITY_HEAT_TRANSFER, enumFacing.func_176734_d())) {
            return (IHeatTransfer)neighbour.getCapability(Mekanism.CAPABILITY_HEAT_TRANSFER, enumFacing.func_176734_d());
        }
        return null;
    }
}

