/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.ItemAssemblyProgram;
import net.minecraft.item.ItemStack;

public class AssemblyRecipe {
    public static final List<AssemblyRecipe> drillRecipes = new ArrayList<AssemblyRecipe>();
    public static final List<AssemblyRecipe> laserRecipes = new ArrayList<AssemblyRecipe>();
    public static final List<AssemblyRecipe> drillLaserRecipes = new ArrayList<AssemblyRecipe>();
    private final ItemStack input;
    private final ItemStack output;
    private final ItemStack programStack;

    public AssemblyRecipe(ItemStack input, ItemStack output, ItemStack programStack) {
        this.input = input;
        this.output = output;
        this.programStack = programStack;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getProgramStack() {
        return this.programStack;
    }

    static void addDrillRecipe(Object input, Object output) {
        PneumaticRegistry.getInstance().getRecipeRegistry().addAssemblyDrillRecipe(input, output);
    }

    static void addLaserRecipe(Object input, Object output) {
        PneumaticRegistry.getInstance().getRecipeRegistry().addAssemblyLaserRecipe(input, output);
    }

    public static AssemblyRecipe findRecipeForOutput(ItemStack result) {
        for (AssemblyRecipe recipe : drillLaserRecipes) {
            if (!ItemStack.func_179545_c((ItemStack)result, (ItemStack)recipe.getOutput())) continue;
            return recipe;
        }
        for (AssemblyRecipe recipe : drillRecipes) {
            if (!ItemStack.func_179545_c((ItemStack)result, (ItemStack)recipe.getOutput())) continue;
            return recipe;
        }
        for (AssemblyRecipe recipe : laserRecipes) {
            if (!ItemStack.func_179545_c((ItemStack)result, (ItemStack)recipe.getOutput())) continue;
            return recipe;
        }
        return null;
    }

    public static void calculateAssemblyChain() {
        ItemStack drillLaserProgram = ItemAssemblyProgram.getStackForProgramType(2, 1);
        for (AssemblyRecipe firstRecipe : drillRecipes) {
            for (AssemblyRecipe secondRecipe : laserRecipes) {
                if (!firstRecipe.getOutput().func_77969_a(secondRecipe.getInput()) || firstRecipe.getOutput().func_190916_E() % secondRecipe.getInput().func_190916_E() != 0 || secondRecipe.getOutput().func_77976_d() < secondRecipe.getOutput().func_190916_E() * (firstRecipe.getOutput().func_190916_E() / secondRecipe.getInput().func_190916_E())) continue;
                ItemStack output = secondRecipe.getOutput().func_77946_l();
                output.func_190920_e(output.func_190916_E() * (firstRecipe.getOutput().func_190916_E() / secondRecipe.getInput().func_190916_E()));
                drillLaserRecipes.add(new AssemblyRecipe(firstRecipe.getInput(), output, drillLaserProgram));
            }
        }
    }
}

