/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.List;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class AreaTypeWall
extends AreaType {
    public static final String ID = "wall";
    private AreaType.EnumAxis axis = AreaType.EnumAxis.X;

    public AreaTypeWall() {
        super(ID);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case X: {
                Vec3d lineVec = new Vec3d(0.0, (double)(p2.func_177956_o() - p1.func_177956_o()), (double)(p2.func_177952_p() - p1.func_177952_p())).func_72432_b();
                lineVec = new Vec3d(lineVec.field_72450_a, lineVec.field_72448_b / 10.0, lineVec.field_72449_c / 10.0);
                double curY = (double)p1.func_177956_o() + 0.5;
                double curZ = (double)p1.func_177952_p() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.func_177956_o() - p2.func_177956_o(), 2.0) + Math.pow(p1.func_177952_p() - p2.func_177952_p(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curY += lineVec.field_72448_b;
                    curZ += lineVec.field_72449_c;
                    for (int i = minX; i <= maxX; ++i) {
                        if (!(curY >= 0.0) || !(curY < 256.0)) continue;
                        BlockPos pos = new BlockPos(i, (int)curY, (int)curZ);
                        areaAdder.accept(pos);
                    }
                }
                break;
            }
            case Y: {
                Vec3d lineVec = new Vec3d((double)(p2.func_177958_n() - p1.func_177958_n()), 0.0, (double)(p2.func_177952_p() - p1.func_177952_p())).func_72432_b();
                lineVec = new Vec3d(lineVec.field_72450_a, lineVec.field_72448_b / 10.0, lineVec.field_72449_c / 10.0);
                double curX = (double)p1.func_177958_n() + 0.5;
                double curZ = (double)p1.func_177952_p() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.func_177958_n() - p2.func_177958_n(), 2.0) + Math.pow(p1.func_177952_p() - p2.func_177952_p(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.field_72450_a;
                    curZ += lineVec.field_72449_c;
                    for (int i = Math.max(0, minY); i <= Math.min(maxY, 255); ++i) {
                        BlockPos pos = new BlockPos((int)curX, i, (int)curZ);
                        areaAdder.accept(pos);
                    }
                }
                break;
            }
            case Z: {
                Vec3d lineVec = new Vec3d((double)(p2.func_177958_n() - p1.func_177958_n()), (double)(p2.func_177956_o() - p1.func_177956_o()), 0.0).func_72432_b();
                lineVec = new Vec3d(lineVec.field_72450_a / 10.0, lineVec.field_72448_b / 10.0, lineVec.field_72449_c);
                double curX = (double)p1.func_177958_n() + 0.5;
                double curY = (double)p1.func_177956_o() + 0.5;
                double totalDistance = 0.0;
                double maxDistance = Math.sqrt(Math.pow(p1.func_177958_n() - p2.func_177958_n(), 2.0) + Math.pow(p1.func_177956_o() - p2.func_177956_o(), 2.0));
                while (totalDistance <= maxDistance) {
                    totalDistance += 0.1;
                    curX += lineVec.field_72450_a;
                    curY += lineVec.field_72448_b;
                    for (int i = minZ; i <= maxZ; ++i) {
                        if (!(curY >= 0.0) || !(curY < 256.0)) continue;
                        BlockPos pos = new BlockPos((int)curX, (int)curY, i);
                        areaAdder.accept(pos);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(this.axis.toString());
            }
        }
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetEnum<AreaType.EnumAxis>("gui.progWidget.area.type.general.axis", AreaType.EnumAxis.class, () -> this.axis, axis -> {
            this.axis = axis;
        }));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("axis", (byte)this.axis.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.axis = AreaType.EnumAxis.values()[tag.func_74771_c("axis")];
    }

    @Override
    public void convertFromLegacy(ProgWidgetArea.EnumAreaType oldAreaType, int typeInfo) {
        switch (oldAreaType) {
            case X_WALL: {
                this.axis = AreaType.EnumAxis.X;
                break;
            }
            case Y_WALL: {
                this.axis = AreaType.EnumAxis.Y;
                break;
            }
            case Z_WALL: {
                this.axis = AreaType.EnumAxis.Z;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

