/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets.area;

import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.area.AreaType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class AreaTypeRandom
extends AreaType {
    public static final String ID = "random";
    private int pickedAmount;

    public AreaTypeRandom() {
        super(ID);
    }

    @Override
    public void addArea(Consumer<BlockPos> areaAdder, BlockPos p1, BlockPos p2, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int size = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        if (this.pickedAmount >= size) {
            BlockPos.func_191532_a((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).forEach(areaAdder);
        } else {
            HashSet filledArea = new HashSet(size);
            BlockPos.func_191532_a((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ).forEach(filledArea::add);
            Random rand = new Random();
            HashSet<Integer> randomIndexes = new HashSet<Integer>();
            while (randomIndexes.size() < this.pickedAmount) {
                randomIndexes.add(rand.nextInt(filledArea.size()));
            }
            int curIndex = 0;
            for (BlockPos pos : filledArea) {
                if (randomIndexes.contains(curIndex)) {
                    areaAdder.accept(pos);
                }
                ++curIndex;
            }
        }
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void addUIWidgets(List<AreaType.AreaTypeWidget> widgets) {
        super.addUIWidgets(widgets);
        widgets.add(new AreaType.AreaTypeWidgetInteger("gui.progWidget.area.type.random.blocksSelected", () -> this.pickedAmount, amount -> {
            this.pickedAmount = amount;
        }));
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("pickedAmount", this.pickedAmount);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.pickedAmount = tag.func_74762_e("pickedAmount");
    }

    @Override
    public void convertFromLegacy(ProgWidgetArea.EnumAreaType oldAreaType, int typeInfo) {
        this.pickedAmount = typeInfo;
    }
}

