/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.client.gui.GuiRemote;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSetGlobalVariable
extends AbstractPacket<PacketSetGlobalVariable> {
    private String varName;
    private BlockPos value;

    public PacketSetGlobalVariable() {
    }

    public PacketSetGlobalVariable(String varName, BlockPos value) {
        this.varName = varName;
        this.value = value;
    }

    public PacketSetGlobalVariable(String varName, int value) {
        this(varName, new BlockPos(value, 0, 0));
    }

    public PacketSetGlobalVariable(String varName, boolean value) {
        this(varName, value ? 1 : 0);
    }

    public void fromBytes(ByteBuf buf) {
        this.varName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.value = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.varName);
        buf.writeInt(this.value.func_177958_n());
        buf.writeInt(this.value.func_177956_o());
        buf.writeInt(this.value.func_177952_p());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(PacketSetGlobalVariable message, EntityPlayer player) {
        this.handleServerSide(message, player);
        GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof GuiRemote) {
            ((GuiRemote)screen).onGlobalVariableChange(message.varName);
        }
    }

    @Override
    public void handleServerSide(PacketSetGlobalVariable message, EntityPlayer player) {
        GlobalVariableManager.getInstance().set(message.varName, message.value);
    }
}

