/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.harvesting;

import java.util.List;
import java.util.function.Predicate;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.harvesting.IHarvestHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class HarvestHandlerTree
implements IHarvestHandler {
    private final Predicate<IBlockState> blockChecker;
    private final Predicate<ItemStack> isSapling;
    private final IBlockState saplingState;

    public HarvestHandlerTree(Predicate<IBlockState> blockChecker, Predicate<ItemStack> isSapling, IBlockState saplingState) {
        this.blockChecker = blockChecker;
        this.isSapling = isSapling;
        this.saplingState = saplingState;
    }

    @Override
    public boolean canHarvest(World world, IBlockAccess chunkCache, BlockPos pos, IBlockState state, IDrone drone) {
        return this.blockChecker.test(state);
    }

    @Override
    public boolean harvestAndReplant(World world, IBlockAccess chunkCache, BlockPos pos, IBlockState state, IDrone drone) {
        int saplingPickRange;
        List saplingItems;
        this.harvest(world, chunkCache, pos, state, drone);
        if (this.saplingState.func_177230_c().func_176196_c(world, pos) && !(saplingItems = world.func_175647_a(EntityItem.class, new AxisAlignedBB(pos).func_72314_b((double)(saplingPickRange = 8), (double)saplingPickRange, (double)saplingPickRange), entityItem -> this.isSapling.test(entityItem.func_92059_d()))).isEmpty()) {
            ((EntityItem)saplingItems.get(0)).func_92059_d().func_190918_g(1);
            world.func_175656_a(pos, this.saplingState);
            return true;
        }
        return false;
    }
}

