/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.semiblock.IProvidingInventoryListener;
import me.desht.pneumaticcraft.common.semiblock.ISpecificProvider;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockRequester;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class LogisticsManager {
    private final List<SemiBlockLogistics>[] logistics = new List[4];

    public LogisticsManager() {
        for (int i = 0; i < this.logistics.length; ++i) {
            this.logistics[i] = new ArrayList<SemiBlockLogistics>();
        }
    }

    void clearLogistics() {
        for (List<SemiBlockLogistics> list : this.logistics) {
            list.clear();
        }
    }

    public void addLogisticFrame(SemiBlockLogistics frame) {
        this.logistics[frame.getPriority()].add(frame);
    }

    public PriorityQueue<LogisticsTask> getTasks(Object holdingStack) {
        ItemStack item = holdingStack instanceof ItemStack ? (ItemStack)holdingStack : null;
        FluidStack fluid = holdingStack instanceof FluidStack ? (FluidStack)holdingStack : null;
        PriorityQueue<LogisticsTask> tasks = new PriorityQueue<LogisticsTask>();
        for (int priority = this.logistics.length - 1; priority >= 0; --priority) {
            for (SemiBlockLogistics requester : this.logistics[priority]) {
                for (int i = 0; i < priority; ++i) {
                    for (SemiBlockLogistics provider : this.logistics[i]) {
                        int requestedAmount;
                        if (!provider.shouldProvideTo(priority)) continue;
                        if (item != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, item);
                            if (requestedAmount <= 0) continue;
                            ItemStack stack = item.func_77946_l();
                            stack.func_190920_e(requestedAmount);
                            tasks.add(new LogisticsTask(provider, requester, stack));
                            return tasks;
                        }
                        if (fluid != null) {
                            requestedAmount = LogisticsManager.getRequestedAmount(requester, fluid);
                            if (requestedAmount <= 0) continue;
                            fluid = fluid.copy();
                            fluid.amount = requestedAmount;
                            tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(fluid)));
                            return tasks;
                        }
                        this.tryProvide(provider, requester, tasks);
                    }
                }
            }
        }
        return tasks;
    }

    private void tryProvide(SemiBlockLogistics provider, SemiBlockLogistics requester, PriorityQueue<LogisticsTask> tasks) {
        int requestedAmount;
        boolean canDrain;
        IFluidHandler handler;
        ItemStack providingStack;
        if (provider.getTileEntity() == null) {
            return;
        }
        IItemHandler providingInventory = IOHelper.getInventoryForTE(provider.getTileEntity(), provider.getSide());
        if (providingInventory != null) {
            if (requester instanceof IProvidingInventoryListener) {
                ((IProvidingInventoryListener)((Object)requester)).notify(new IProvidingInventoryListener.TileEntityAndFace((TileEntity)provider.getTileEntity(), provider.getSide()));
            }
            for (int i = 0; i < providingInventory.getSlots(); ++i) {
                int requestedAmount2;
                providingStack = providingInventory.getStackInSlot(i);
                if (providingStack.func_190926_b() || provider instanceof ISpecificProvider && !((ISpecificProvider)((Object)provider)).canProvide(providingStack) || (requestedAmount2 = LogisticsManager.getRequestedAmount(requester, providingStack)) <= 0) continue;
                ItemStack stack = providingStack.func_77946_l();
                stack.func_190920_e(requestedAmount2);
                tasks.add(new LogisticsTask(provider, requester, stack));
            }
        }
        if ((handler = (IFluidHandler)provider.getTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, provider.getSide())) != null && (providingStack = handler.drain(16000, false)) != null && (canDrain = Arrays.stream(handler.getTankProperties()).anyMatch(arg_0 -> LogisticsManager.lambda$tryProvide$0((FluidStack)providingStack, arg_0))) && (!(provider instanceof ISpecificProvider) || ((ISpecificProvider)((Object)provider)).canProvide((FluidStack)providingStack)) && (requestedAmount = LogisticsManager.getRequestedAmount(requester, (FluidStack)providingStack)) > 0) {
            FluidStack stack = providingStack.copy();
            stack.amount = requestedAmount;
            tasks.add(new LogisticsTask(provider, requester, new SemiBlockLogistics.FluidStackWrapper(stack)));
        }
    }

    private static int getRequestedAmount(SemiBlockLogistics requester, ItemStack providingStack) {
        int minOrderSize;
        Object te = requester.getTileEntity();
        if (te == null) {
            return 0;
        }
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.func_77976_d();
        int n = minOrderSize = requester instanceof SemiBlockRequester ? ((SemiBlockRequester)requester).getMinItemOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        providingStack = providingStack.func_77946_l();
        providingStack.func_190920_e(requestedAmount);
        ItemStack remainder = providingStack.func_77946_l();
        remainder.func_190917_f(requester.getIncomingItems(providingStack));
        remainder = IOHelper.insert(te, remainder, requester.getSide(), true);
        providingStack.func_190918_g(remainder.func_190916_E());
        if (providingStack.func_190916_E() <= 0) {
            return 0;
        }
        return providingStack.func_190916_E();
    }

    private static int getRequestedAmount(SemiBlockLogistics requester, FluidStack providingStack) {
        int fluidFilled;
        int minOrderSize;
        int requestedAmount = requester instanceof ISpecificRequester ? ((ISpecificRequester)((Object)requester)).amountRequested(providingStack) : providingStack.amount;
        int n = minOrderSize = requester instanceof SemiBlockRequester ? ((SemiBlockRequester)requester).getMinFluidOrderSize() : 1;
        if (requestedAmount < minOrderSize) {
            return 0;
        }
        providingStack = providingStack.copy();
        providingStack.amount = requestedAmount;
        FluidStack remainder = providingStack.copy();
        remainder.amount += requester.getIncomingFluid(remainder.getFluid());
        if (requester.getTileEntity() == null) {
            return 0;
        }
        IFluidHandler fluidHandler = (IFluidHandler)requester.getTileEntity().getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requester.getSide());
        if (fluidHandler != null && (fluidFilled = fluidHandler.fill(remainder, false)) > 0) {
            remainder.amount -= fluidFilled;
        }
        providingStack.amount -= remainder.amount;
        if (providingStack.amount <= 0) {
            return 0;
        }
        return providingStack.amount;
    }

    private static /* synthetic */ boolean lambda$tryProvide$0(FluidStack providingStack, IFluidTankProperties p) {
        return p.canDrainFluidType(providingStack);
    }

    public static class LogisticsTask
    implements Comparable<LogisticsTask> {
        public final SemiBlockLogistics provider;
        public final SemiBlockLogistics requester;
        @Nonnull
        public final ItemStack transportingItem;
        public final SemiBlockLogistics.FluidStackWrapper transportingFluid;

        LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, @Nonnull ItemStack transportingItem) {
            this.provider = provider;
            this.requester = requester;
            this.transportingItem = transportingItem;
            this.transportingFluid = null;
        }

        LogisticsTask(SemiBlockLogistics provider, SemiBlockLogistics requester, SemiBlockLogistics.FluidStackWrapper transportingFluid) {
            this.provider = provider;
            this.requester = requester;
            this.transportingFluid = transportingFluid;
            this.transportingItem = ItemStack.field_190927_a;
        }

        void informRequester() {
            if (!this.transportingItem.func_190926_b()) {
                this.requester.informIncomingStack(this.transportingItem);
            } else {
                this.requester.informIncomingStack(this.transportingFluid);
            }
        }

        public boolean isStillValid(Object stack) {
            if (!this.transportingItem.func_190926_b() && stack instanceof ItemStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (ItemStack)stack);
                return requestedAmount == ((ItemStack)stack).func_190916_E();
            }
            if (this.transportingFluid != null && stack instanceof FluidStack) {
                int requestedAmount = LogisticsManager.getRequestedAmount(this.requester, (FluidStack)stack);
                return requestedAmount == ((FluidStack)stack).amount;
            }
            return false;
        }

        @Override
        public int compareTo(LogisticsTask task) {
            int value = !this.transportingItem.func_190926_b() ? this.transportingItem.func_190916_E() * 100 : this.transportingFluid.stack.amount;
            int otherValue = !task.transportingItem.func_190926_b() ? task.transportingItem.func_190916_E() * 100 : task.transportingFluid.stack.amount;
            return otherValue - value;
        }
    }
}

