/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.drone.SpecialVariableRetrievalEvent;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.ai.DroneAIExternalProgram;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIPickupItems;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemRegistry;
import me.desht.pneumaticcraft.common.progwidgets.IJumpBackWidget;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableProvider;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.remote.GlobalVariableManager;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class DroneAIManager
implements IVariableProvider {
    private final List<EntityAITaskEntry> taskEntries = new ArrayList<EntityAITaskEntry>();
    private final List<EntityAITaskEntry> executingTaskEntries = new ArrayList<EntityAITaskEntry>();
    private final Profiler theProfiler;
    private int tickCount;
    static final int TICK_RATE = 3;
    private final IDroneBase drone;
    private List<IProgWidget> progWidgets;
    private IProgWidget curActiveWidget;
    private EntityAIBase curWidgetAI;
    private EntityAIBase curWidgetTargetAI;
    private boolean stopWhenEndReached;
    private boolean wasAIOveridden;
    private String currentLabel = "Main";
    private Map<String, BlockPos> coordinateVariables = new HashMap<String, BlockPos>();
    private Map<String, ItemStack> itemVariables = new HashMap<String, ItemStack>();
    private final Stack<IProgWidget> jumpBackWidgets = new Stack();
    private static final int MAX_JUMP_STACK_SIZE = 100;

    public DroneAIManager(IDroneBase drone) {
        this.theProfiler = drone.world().field_72984_F;
        this.drone = drone;
        if (!drone.world().field_72995_K) {
            this.setWidgets(drone.getProgWidgets());
        }
    }

    public DroneAIManager(IDroneBase drone, List<IProgWidget> progWidgets) {
        this.theProfiler = drone.world().field_72984_F;
        this.drone = drone;
        this.stopWhenEndReached = true;
        this.setWidgets(progWidgets);
    }

    public void dontStopWhenEndReached() {
        this.stopWhenEndReached = false;
    }

    public void setWidgets(List<IProgWidget> progWidgets) {
        this.progWidgets = progWidgets;
        if (progWidgets.isEmpty()) {
            this.setActiveWidget(null);
        } else {
            for (IProgWidget widget : progWidgets) {
                if (!(widget instanceof IVariableWidget)) continue;
                ((IVariableWidget)((Object)widget)).setAIManager(this);
            }
            this.gotoFirstWidget();
        }
    }

    public void connectVariables(DroneAIManager subAI) {
        subAI.coordinateVariables = this.coordinateVariables;
        subAI.itemVariables = this.itemVariables;
    }

    public boolean isIdling() {
        return this.curWidgetAI == null;
    }

    public EntityAIBase getCurrentAI() {
        return this.curWidgetAI;
    }

    public IDroneBase getDrone() {
        return this.drone;
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<String, BlockPos> entry : this.coordinateVariables.entrySet()) {
            NBTTagCompound t = new NBTTagCompound();
            t.func_74778_a("key", entry.getKey());
            t.func_74768_a("x", entry.getValue().func_177958_n());
            t.func_74768_a("y", entry.getValue().func_177956_o());
            t.func_74768_a("z", entry.getValue().func_177952_p());
            tagList.func_74742_a((NBTBase)t);
        }
        tag.func_74782_a("coords", (NBTBase)tagList);
        GlobalVariableManager.getInstance().writeItemVars(tag, this.itemVariables);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.coordinateVariables.clear();
        NBTTagList tagList = tag.func_150295_c("coords", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound t = tagList.func_150305_b(i);
            this.coordinateVariables.put(t.func_74779_i("key"), new BlockPos(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        GlobalVariableManager.readItemVars(tag, this.itemVariables);
    }

    @Override
    public BlockPos getCoordinate(String varName) {
        BlockPos pos;
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.CoordinateVariable.Drone event = new SpecialVariableRetrievalEvent.CoordinateVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            pos = event.coordinate;
        } else {
            pos = varName.startsWith("#") ? GlobalVariableManager.getInstance().getPos(varName.substring(1)) : this.coordinateVariables.get(varName);
        }
        return pos != null ? pos : BlockPos.field_177992_a;
    }

    public void setCoordinate(String varName, BlockPos coord) {
        if (varName.startsWith("#")) {
            GlobalVariableManager.getInstance().set(varName.substring(1), coord);
        } else if (!varName.startsWith("$")) {
            this.coordinateVariables.put(varName, coord);
        }
    }

    @Nonnull
    public ItemStack getStack(String varName) {
        ItemStack item;
        if (varName.startsWith("$")) {
            SpecialVariableRetrievalEvent.ItemVariable.Drone event = new SpecialVariableRetrievalEvent.ItemVariable.Drone(this.drone, varName.substring(1));
            MinecraftForge.EVENT_BUS.post((Event)event);
            item = event.item;
        } else {
            item = varName.startsWith("#") ? GlobalVariableManager.getInstance().getItem(varName.substring(1)) : this.itemVariables.getOrDefault(varName, ItemStack.field_190927_a);
        }
        return item;
    }

    public void setItem(String varName, @Nonnull ItemStack item) {
        if (varName.startsWith("#")) {
            GlobalVariableManager.getInstance().set(varName.substring(1), item);
        } else if (!varName.startsWith("$")) {
            this.itemVariables.put(varName, item);
        }
    }

    private void updateWidgetFlow() {
        boolean isExecuting = false;
        for (EntityAITaskEntry entry : this.executingTaskEntries) {
            if (this.curWidgetAI != entry.action) continue;
            isExecuting = true;
            break;
        }
        if (!(isExecuting || this.curActiveWidget == null || this.curWidgetTargetAI != null && this.curWidgetTargetAI.func_75250_a())) {
            IProgWidget widget = this.curActiveWidget.getOutputWidget(this.drone, this.progWidgets);
            if (widget != null) {
                if (this.curActiveWidget.getOutputWidget() != widget && this.addJumpBackWidget(this.curActiveWidget)) {
                    return;
                }
                this.setActiveWidget(widget);
            } else if (this.stopWhenEndReached) {
                this.setActiveWidget(null);
            } else {
                this.gotoFirstWidget();
            }
        }
        if (this.curActiveWidget == null && !this.stopWhenEndReached) {
            this.gotoFirstWidget();
        }
    }

    private void gotoFirstWidget() {
        this.setLabel("Main");
        if (!this.jumpBackWidgets.isEmpty()) {
            this.setActiveWidget(this.jumpBackWidgets.pop());
        } else {
            for (IProgWidget widget : this.progWidgets) {
                if (!(widget instanceof ProgWidgetStart)) continue;
                this.setActiveWidget(widget);
                return;
            }
        }
    }

    private void setActiveWidget(IProgWidget widget) {
        EntityAIBase targetAI = null;
        EntityAIBase ai = null;
        if (widget != null) {
            boolean first = widget instanceof ProgWidgetStart;
            targetAI = widget.getWidgetTargetAI(this.drone, widget);
            ai = widget.getWidgetAI(this.drone, widget);
            HashSet<IProgWidget> visitedWidgets = new HashSet<IProgWidget>();
            while (!visitedWidgets.contains(widget) && targetAI == null && ai == null) {
                visitedWidgets.add(widget);
                IProgWidget oldWidget = widget;
                widget = widget.getOutputWidget(this.drone, this.progWidgets);
                if (widget == null) {
                    if (first) {
                        return;
                    }
                    if (this.stopWhenEndReached) {
                        this.setActiveWidget(null);
                    } else {
                        this.gotoFirstWidget();
                    }
                    return;
                }
                if (oldWidget.getOutputWidget() != widget && this.addJumpBackWidget(oldWidget)) {
                    return;
                }
                targetAI = widget.getWidgetTargetAI(this.drone, widget);
                ai = widget.getWidgetAI(this.drone, widget);
            }
            this.drone.setActiveProgram(widget);
        } else {
            this.setLabel("Stopped");
        }
        this.curActiveWidget = widget;
        if (this.curWidgetAI != null) {
            this.removeTask(this.curWidgetAI);
        }
        if (this.curWidgetTargetAI != null) {
            this.drone.getTargetAI().func_85156_a(this.curWidgetTargetAI);
        }
        if (ai != null) {
            this.addTask(2, ai);
        }
        if (targetAI != null) {
            this.drone.getTargetAI().func_75776_a(2, targetAI);
        }
        this.curWidgetAI = ai;
        this.curWidgetTargetAI = targetAI;
    }

    private boolean addJumpBackWidget(IProgWidget widget) {
        if (widget instanceof IJumpBackWidget) {
            if (this.jumpBackWidgets.size() >= 100) {
                this.drone.overload("jumpStackTooLarge", 100);
                this.jumpBackWidgets.clear();
                this.setActiveWidget(null);
                return true;
            }
            this.jumpBackWidgets.push(widget);
        }
        return false;
    }

    public List<EntityAITaskEntry> getRunningTasks() {
        return this.taskEntries;
    }

    public EntityAIBase getTargetAI() {
        return this.curWidgetTargetAI;
    }

    public void addTask(int par1, EntityAIBase par2EntityAIBase) {
        this.taskEntries.add(new EntityAITaskEntry(par1, par2EntityAIBase));
    }

    public void removeTask(EntityAIBase par1EntityAIBase) {
        Iterator<EntityAITaskEntry> iterator = this.taskEntries.iterator();
        while (iterator.hasNext()) {
            EntityAITaskEntry entityaitaskentry = iterator.next();
            EntityAIBase entityaibase1 = entityaitaskentry.action;
            if (entityaibase1 != par1EntityAIBase) continue;
            if (this.executingTaskEntries.contains(entityaitaskentry)) {
                entityaibase1.func_75251_c();
                this.executingTaskEntries.remove(entityaitaskentry);
            }
            iterator.remove();
        }
    }

    private void pickupItemsIfMagnet() {
        int magnetUpgrades = this.drone.getUpgrades(ItemRegistry.getInstance().getUpgrade(IItemRegistry.EnumUpgrade.MAGNET));
        if (magnetUpgrades > 0) {
            int range = Math.min(6, 1 + magnetUpgrades);
            Vec3d v = this.drone.getDronePos();
            AxisAlignedBB aabb = new AxisAlignedBB(v.field_72450_a, v.field_72448_b, v.field_72449_c, v.field_72450_a, v.field_72448_b, v.field_72449_c).func_186662_g((double)range);
            List items = this.drone.world().func_175647_a(EntityItem.class, aabb, item -> item != null && item.func_70089_S() && !item.func_174874_s() && this.drone.getDronePos().func_72436_e(item.func_174791_d()) <= (double)(range * range));
            for (EntityItem item2 : items) {
                DroneEntityAIPickupItems.tryPickupItem(this.drone, item2);
            }
        }
    }

    public void onUpdateTasks() {
        this.pickupItemsIfMagnet();
        if (ConfigHandler.advanced.stopDroneAI) {
            return;
        }
        if (!this.drone.isAIOverriden()) {
            if (this.wasAIOveridden && this.curWidgetTargetAI != null) {
                this.drone.getTargetAI().func_75776_a(2, this.curWidgetTargetAI);
            }
            this.wasAIOveridden = false;
            ArrayList<EntityAITaskEntry> arraylist = new ArrayList<EntityAITaskEntry>();
            if (this.tickCount++ % 3 == 0) {
                for (EntityAITaskEntry entityaitaskentry : this.taskEntries) {
                    boolean flag = this.executingTaskEntries.contains(entityaitaskentry);
                    if (flag) {
                        if (this.canUse(entityaitaskentry) && this.canContinue(entityaitaskentry)) continue;
                        entityaitaskentry.action.func_75251_c();
                        this.executingTaskEntries.remove(entityaitaskentry);
                    }
                    if (!this.canUse(entityaitaskentry) || !entityaitaskentry.action.func_75250_a()) continue;
                    arraylist.add(entityaitaskentry);
                    this.executingTaskEntries.add(entityaitaskentry);
                }
                this.updateWidgetFlow();
            } else {
                Iterator<EntityAITaskEntry> iterator = this.executingTaskEntries.iterator();
                while (iterator.hasNext()) {
                    EntityAITaskEntry entityaitaskentry;
                    entityaitaskentry = iterator.next();
                    if (entityaitaskentry.action.func_75253_b()) continue;
                    entityaitaskentry.action.func_75251_c();
                    iterator.remove();
                }
            }
            this.theProfiler.func_76320_a("goalStart");
            for (EntityAITaskEntry entityaitaskentry : arraylist) {
                this.theProfiler.func_76320_a(entityaitaskentry.action.getClass().getSimpleName());
                entityaitaskentry.action.func_75249_e();
                this.theProfiler.func_76319_b();
            }
            this.theProfiler.func_76319_b();
            this.theProfiler.func_76320_a("goalTick");
            for (EntityAITaskEntry entityaitaskentry : this.executingTaskEntries) {
                entityaitaskentry.action.func_75246_d();
            }
            this.theProfiler.func_76319_b();
        } else {
            if (!this.wasAIOveridden && this.curWidgetTargetAI != null) {
                this.drone.getTargetAI().func_85156_a(this.curWidgetTargetAI);
            }
            this.wasAIOveridden = true;
            for (EntityAITaskEntry ai : this.executingTaskEntries) {
                ai.action.func_75251_c();
            }
            this.executingTaskEntries.clear();
            this.drone.setDugBlock(null);
        }
    }

    private boolean canContinue(EntityAITaskEntry par1EntityAITaskEntry) {
        this.theProfiler.func_76320_a("canContinue");
        boolean flag = par1EntityAITaskEntry.action.func_75253_b();
        this.theProfiler.func_76319_b();
        return flag;
    }

    private boolean canUse(EntityAITaskEntry par1EntityAITaskEntry) {
        this.theProfiler.func_76320_a("canUse");
        for (EntityAITaskEntry entry : this.taskEntries) {
            if (entry == par1EntityAITaskEntry) continue;
            if (par1EntityAITaskEntry.priority >= entry.priority) {
                if (!this.executingTaskEntries.contains(entry) || this.areTasksCompatible(par1EntityAITaskEntry, entry)) continue;
                this.theProfiler.func_76319_b();
                return false;
            }
            if (!this.executingTaskEntries.contains(entry) || entry.action.func_75252_g()) continue;
            this.theProfiler.func_76319_b();
            return false;
        }
        this.theProfiler.func_76319_b();
        return true;
    }

    private boolean areTasksCompatible(EntityAITaskEntry par1EntityAITaskEntry, EntityAITaskEntry par2EntityAITaskEntry) {
        return (par1EntityAITaskEntry.action.func_75247_h() & par2EntityAITaskEntry.action.func_75247_h()) == 0;
    }

    public void setLabel(String label) {
        this.currentLabel = label;
        this.drone.updateLabel();
    }

    public String getLabel() {
        if (this.curWidgetAI instanceof DroneAIExternalProgram) {
            return ((DroneAIExternalProgram)this.curWidgetAI).getRunningAI().getLabel() + " --> " + this.currentLabel;
        }
        return this.currentLabel;
    }

    public class EntityAITaskEntry {
        public final EntityAIBase action;
        public final int priority;

        public EntityAITaskEntry(int par2, EntityAIBase par3EntityAIBase) {
            this.priority = par2;
            this.action = par3EntityAIBase;
        }
    }
}

