/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import me.desht.pneumaticcraft.client.model.block.ModelElevatorBase;
import me.desht.pneumaticcraft.client.render.tileentity.AbstractModelRenderer;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class RenderElevatorBase
extends AbstractModelRenderer<TileEntityElevatorBase> {
    private final ModelElevatorBase model = new ModelElevatorBase();

    @Override
    protected boolean shouldRender(TileEntityElevatorBase te) {
        return te.extension > 0.0f;
    }

    @Override
    ResourceLocation getTexture(TileEntityElevatorBase te) {
        return Textures.MODEL_ELEVATOR;
    }

    @Override
    void renderModel(TileEntityElevatorBase te, float partialTicks) {
        float extension = te.oldExtension + (te.extension - te.oldExtension) * partialTicks;
        this.model.renderModel(0.0625f, extension);
    }

    @Override
    protected void renderExtras(TileEntityElevatorBase te, double x, double y, double z, float partialTicks) {
        if (te.fakeFloorTextureUV != null && te.fakeFloorTextureUV.length == 4) {
            GlStateManager.func_179094_E();
            float extension = te.oldExtension + (te.extension - te.oldExtension) * partialTicks;
            GlStateManager.func_179137_b((double)x, (double)(y + (double)extension + (double)1.0005f), (double)z);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            double uMin = te.fakeFloorTextureUV[0];
            double vMin = te.fakeFloorTextureUV[1];
            double uMax = te.fakeFloorTextureUV[2];
            double vMax = te.fakeFloorTextureUV[3];
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldrenderer = tessellator.func_178180_c();
            worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            worldrenderer.func_181662_b(0.0, 0.0, 1.0).func_187315_a(uMin, vMax).func_181675_d();
            worldrenderer.func_181662_b(1.0, 0.0, 1.0).func_187315_a(uMax, vMax).func_181675_d();
            worldrenderer.func_181662_b(1.0, 0.0, 0.0).func_187315_a(uMax, vMin).func_181675_d();
            worldrenderer.func_181662_b(0.0, 0.0, 0.0).func_187315_a(uMin, vMin).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    public boolean isGlobalRenderer(TileEntityElevatorBase te) {
        return true;
    }
}

