/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.programmer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetOptionBase;
import me.desht.pneumaticcraft.client.gui.widget.IGuiWidget;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidFilter;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.gui.widget.WidgetVerticalScrollbar;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetLiquidFilter;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GuiProgWidgetLiquidFilter
extends GuiProgWidgetOptionBase<ProgWidgetLiquidFilter> {
    private static final int GRID_WIDTH = 8;
    private static final int GRID_HEIGHT = 6;
    private WidgetFluidFilter mainFilter;
    private WidgetTextField searchField;
    private WidgetVerticalScrollbar scrollbar;
    private int lastScroll;

    public GuiProgWidgetLiquidFilter(ProgWidgetLiquidFilter widget, GuiProgrammer guiProgrammer) {
        super(widget, guiProgrammer);
        this.xSize = 176;
        this.ySize = 166;
    }

    @Override
    protected ResourceLocation getTexture() {
        return new ResourceLocation("pneumaticcraft:textures/gui/gui_item_searcher.png");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.mainFilter = new WidgetFluidFilter(-1, this.guiLeft + 124, this.guiTop + 25).setFluid(((ProgWidgetLiquidFilter)this.widget).getFluid());
        this.addWidget(this.mainFilter);
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 6; ++y) {
                this.addWidget(new WidgetFluidFilter(x + y * 8, this.guiLeft + 8 + x * 18, this.guiTop + 52 + y * 18));
            }
        }
        this.searchField = new WidgetTextField(Minecraft.func_71410_x().field_71466_p, this.guiLeft + 10, this.guiTop + 30, 90, 10);
        this.addWidget(this.searchField);
        this.searchField.func_146195_b(true);
        this.scrollbar = new WidgetVerticalScrollbar(this.guiLeft + 155, this.guiTop + 47, 112);
        this.scrollbar.setListening(true);
        this.addWidget(this.scrollbar);
        this.addValidFluids();
    }

    private void addValidFluids() {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!fluid.getLocalizedName(new FluidStack(fluid, 1)).toLowerCase().contains(this.searchField.func_146179_b())) continue;
            fluids.add(fluid);
        }
        fluids.sort(Comparator.comparing(Fluid::getName));
        this.scrollbar.setStates(Math.max(0, (fluids.size() - 48 + 8 - 1) / 8));
        int offset = this.scrollbar.getState() * 8;
        for (IGuiWidget widget : this.widgets) {
            if (widget.getID() < 0 || !(widget instanceof WidgetFluidFilter)) continue;
            int idWithOffset = widget.getID() + offset;
            ((WidgetFluidFilter)widget).setFluid(idWithOffset >= 0 && idWithOffset < fluids.size() ? (Fluid)fluids.get(idWithOffset) : null);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.lastScroll != this.scrollbar.getState()) {
            this.lastScroll = this.scrollbar.getState();
            this.addValidFluids();
        }
    }

    @Override
    public void func_73869_a(char key, int keyCode) throws IOException {
        super.func_73869_a(key, keyCode);
        this.addValidFluids();
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget == this.mainFilter) {
            ((WidgetFluidFilter)widget).setFluid(null);
        } else if (widget instanceof WidgetFluidFilter) {
            this.mainFilter.setFluid(((WidgetFluidFilter)widget).getFluid());
        }
        ((ProgWidgetLiquidFilter)this.widget).setFluid(this.mainFilter.getFluid());
        super.actionPerformed(widget);
    }
}

