/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.gui.client;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.entity.DuctUnitTransport;
import com.google.common.base.Strings;
import net.minecraft.item.ItemStack;

public final class DirectoryEntry {
    public final String name;
    public final int x;
    public final int y;
    public final int z;
    public final ItemStack icon;

    public static void addDirectoryEntry(PacketTileInfo myPayload, DuctUnitTransport endPoint) {
        myPayload.addString(endPoint.data.name);
        myPayload.addInt(endPoint.x());
        myPayload.addInt(endPoint.y());
        myPayload.addInt(endPoint.z());
        myPayload.addItemStack(endPoint.data.item);
    }

    public DirectoryEntry(PacketBase packet) {
        this(packet.getString(), packet.getInt(), packet.getInt(), packet.getInt(), packet.getItemStack());
    }

    public DirectoryEntry(String name, int x, int y, int z, ItemStack icon) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
        this.icon = icon;
    }

    public String toString() {
        return "DirectoryEntry{name='" + this.name + '\'' + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", icon=" + this.icon + '}';
    }

    public String getName() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return StringHelper.localize((String)"gui.thermaldynamics.transport.unnamed");
        }
        return this.name;
    }
}

