/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.botania.handlers;

import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import com.blamejared.mtlib.utils.BaseListAddition;
import com.blamejared.mtlib.utils.BaseListRemoval;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePetals;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

@ZenClass(value="mods.botania.Apothecary")
@ModOnly(value="botania")
@ZenRegister
public class Apothecary {
    protected static final String name = "Botania Petal";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(new RecipePetals(InputHelper.toStack((IItemStack)output), InputHelper.toObjects((IIngredient[])input))));
    }

    @ZenMethod
    public static void addRecipe(String output, IIngredient[] input) {
        Apothecary.addRecipe(InputHelper.toIItemStack((ItemStack)ItemBlockSpecialFlower.ofType((String)output)), input);
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(output));
    }

    @ZenMethod
    public static void removeRecipe(String output) {
        Apothecary.removeRecipe((IIngredient)InputHelper.toIItemStack((ItemStack)ItemBlockSpecialFlower.ofType((String)output)));
    }

    private static class Remove
    extends BaseListRemoval<RecipePetals> {
        final IIngredient output;

        public Remove(IIngredient output) {
            super(Apothecary.name, BotaniaAPI.petalRecipes, Collections.emptyList());
            this.output = output;
        }

        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }

        public void apply() {
            LinkedList<RecipePetals> result = new LinkedList<RecipePetals>();
            for (RecipePetals entry : BotaniaAPI.petalRecipes) {
                if (entry == null || entry.getOutput() == null || !StackHelper.matches((IIngredient)this.output, (IItemStack)InputHelper.toIItemStack((ItemStack)entry.getOutput()))) continue;
                result.add(entry);
            }
            if (!result.isEmpty()) {
                this.recipes.addAll(result);
                super.apply();
            } else {
                LogHelper.logWarning((String)String.format("No %s Recipe found for %s. Command ignored!", Apothecary.name, this.output.toString()));
            }
            CraftTweakerAPI.getLogger().logInfo(super.describe());
        }

        public String describe() {
            return "Attempting to remove apothecary recipe for " + this.output.getItems();
        }
    }

    private static class Add
    extends BaseListAddition<RecipePetals> {
        public Add(RecipePetals recipe) {
            super(Apothecary.name, BotaniaAPI.petalRecipes, Collections.singletonList(recipe));
        }

        public String getRecipeInfo(RecipePetals recipe) {
            return LogHelper.getStackDescription((Object)recipe.getOutput());
        }
    }
}

