/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.init;

import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import thaumcraft.common.world.biomes.BiomeHandler;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.world.BiomeMonitorColors;
import thecodex6824.thaumicaugmentation.api.world.BiomeTerrainBlocks;
import thecodex6824.thaumicaugmentation.api.world.IPurgeBiomeSpawns;
import thecodex6824.thaumicaugmentation.api.world.TABiomes;
import thecodex6824.thaumicaugmentation.api.world.TADimensions;
import thecodex6824.thaumicaugmentation.api.world.capability.CapabilityFractureLocations;
import thecodex6824.thaumicaugmentation.api.world.capability.IFractureLocations;
import thecodex6824.thaumicaugmentation.common.TAConfigHolder;
import thecodex6824.thaumicaugmentation.common.util.FractureLocatorSearchManager;
import thecodex6824.thaumicaugmentation.common.world.TAWorldGenerator;
import thecodex6824.thaumicaugmentation.common.world.WorldDataCache;
import thecodex6824.thaumicaugmentation.common.world.WorldProviderEmptiness;
import thecodex6824.thaumicaugmentation.common.world.feature.FractureUtils;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireComponentPlacer;

@Mod.EventBusSubscriber(modid="thaumicaugmentation")
public final class WorldHandler {
    private WorldHandler() {
    }

    private static int findFreeDimensionID() {
        for (int i = 2; i < Integer.MAX_VALUE; ++i) {
            if (DimensionManager.isDimensionRegistered((int)i)) continue;
            return i;
        }
        throw new IllegalStateException("Could not find a free dimension ID (there are over 2 billion used?!?!)");
    }

    private static int currentIDOrSubstitute(int id) {
        boolean conflict = false;
        for (DimensionType type : DimensionType.values()) {
            if (type.func_186068_a() != id) continue;
            conflict = true;
            break;
        }
        if (!conflict) {
            return id;
        }
        return WorldHandler.findFreeDimensionID();
    }

    public static void preInit() {
        if (!TAConfig.disableEmptiness.getValue().booleanValue()) {
            int emptinessID = WorldHandler.currentIDOrSubstitute(TAConfig.emptinessDimID.getValue());
            if (emptinessID != TAConfig.emptinessDimID.getValue()) {
                ThaumicAugmentation.getLogger().warn("The dimension ID {} was already taken. Assigning {} instead and updating the config...", (Object)TAConfig.emptinessDimID.getValue(), (Object)emptinessID);
                TAConfigHolder.world.emptinessDimID = emptinessID;
                TAConfigHolder.gameplay.augment.dimensionalModifierEmptinessDims = new Integer[]{emptinessID};
                TAConfigHolder.syncLocally();
                TAConfigHolder.syncConfig();
            }
            TADimensions.EMPTINESS = DimensionType.register((String)"emptiness", (String)"_emptiness", (int)emptinessID, WorldProviderEmptiness.class, (boolean)false);
            DimensionManager.registerDimension((int)emptinessID, (DimensionType)TADimensions.EMPTINESS);
            BiomeHandler.addDimBlacklist((int)emptinessID, (int)0);
        }
    }

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new TAWorldGenerator(), (int)20);
    }

    public static void postInit() {
        BiomeTerrainBlocks.init();
        BiomeTerrainBlocks.registerBiomeOverride(Biomes.field_76778_j, Blocks.field_150424_aL.func_176223_P(), Blocks.field_150424_aL.func_176223_P());
        BiomeTerrainBlocks.registerBiomeOverride(Biomes.field_76779_k, Blocks.field_150377_bs.func_176223_P(), Blocks.field_150377_bs.func_176223_P());
        BiomeMonitorColors.init();
        BiomeMonitorColors.registerMonitorColorOverride(Biomes.field_76778_j, 0x881100, 10506797, 16729344);
        BiomeMonitorColors.registerMonitorColorOverride(Biomes.field_76779_k, 16775388, -1, -1);
        BiomeMonitorColors.registerMonitorColorOverride(TABiomes.EMPTINESS, 0x5B005B, 0x3B003B, -1);
        BiomeMonitorColors.registerMonitorColorOverride(TABiomes.EMPTINESS_HIGHLANDS, 0x3B003B, -1, -1);
        BiomeMonitorColors.registerMonitorColorOverride(TABiomes.TAINTED_LANDS, 0x9B009B, 0xFF00FF, -1);
        for (Biome biome : TABiomes.getAllBiomes()) {
            if (!(biome instanceof IPurgeBiomeSpawns)) continue;
            ((IPurgeBiomeSpawns)biome).purgeSpawns();
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && !TAConfig.disableEmptiness.getValue().booleanValue()) {
            WorldDataCache.addOrUpdateData(event.getWorld());
            if (event.getWorld().field_73011_w.getDimension() == TADimensions.EMPTINESS.func_186068_a()) {
                EldritchSpireComponentPlacer.findTemplateVariants(((WorldServer)event.getWorld()).func_184163_y());
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        IFractureLocations loc;
        if (!event.getWorld().field_72995_K && !TAConfig.disableEmptiness.getValue().booleanValue() && FractureUtils.isDimAllowedForLinking(event.getWorld().field_73011_w.getDimension()) && (loc = (IFractureLocations)event.getChunk().getCapability(CapabilityFractureLocations.FRACTURE_LOCATIONS, null)) != null && loc.hasFracture()) {
            FractureLocatorSearchManager.addFractureLocations(event.getWorld(), loc.getFractureLocations());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        IFractureLocations loc;
        if (!event.getWorld().field_72995_K && !TAConfig.disableEmptiness.getValue().booleanValue() && FractureUtils.isDimAllowedForLinking(event.getWorld().field_73011_w.getDimension()) && (loc = (IFractureLocations)event.getChunk().getCapability(CapabilityFractureLocations.FRACTURE_LOCATIONS, null)) != null && loc.hasFracture()) {
            FractureLocatorSearchManager.removeFractureLocations(event.getWorld(), loc.getFractureLocations());
        }
    }
}

