/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.core.transformer;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import thecodex6824.thaumicaugmentation.core.transformer.TransformUtil;
import thecodex6824.thaumicaugmentation.core.transformer.Transformer;
import thecodex6824.thaumicaugmentation.core.transformer.TransformerException;

public class TransformerVoidRobesArmorBarFix
extends Transformer {
    private static final String CLASS = "thaumcraft.common.items.armor.ItemVoidRobeArmor";

    @Override
    public boolean needToComputeFrames() {
        return false;
    }

    @Override
    public boolean isTransformationNeeded(String transformedName) {
        return transformedName.equals(CLASS);
    }

    @Override
    public boolean isAllowedToFail() {
        return true;
    }

    @Override
    public boolean transform(ClassNode classNode, String name, String transformedName) {
        try {
            MethodNode disp = TransformUtil.findMethod(classNode, "getArmorDisplay", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/item/ItemStack;I)I");
            int offset = TransformUtil.findFirstInstanceOfOpcode(disp, 0, 172);
            if (offset == -1) {
                throw new TransformerException("Could not locate required instructions");
            }
            AbstractInsnNode insertAfter = disp.instructions.get(offset).getPrevious();
            disp.instructions.insert(insertAfter, (AbstractInsnNode)new InsnNode(3));
            return true;
        }
        catch (Throwable anything) {
            this.error = new RuntimeException(anything);
            return false;
        }
    }
}

