/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.structure;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thaumcraft.api.blocks.BlocksTC;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.block.property.ITAStoneType;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireBaseComponent;

public class EldritchSpirePillarComponent
extends EldritchSpireBaseComponent {
    protected PillarType type;

    public EldritchSpirePillarComponent() {
    }

    public EldritchSpirePillarComponent(TemplateManager templateManager, Template template, String templateName, boolean fillBelow, BlockPos position, Rotation rot, Mirror mi, UUID wardOwner, PillarType pillar) {
        super(templateManager, template, templateName, fillBelow, position, rot, mi, wardOwner);
        this.type = pillar;
    }

    public EldritchSpirePillarComponent(TemplateManager templateManager, String templateName, boolean fillBelow, BlockPos position, Rotation rot, Mirror mi, UUID wardOwner, PillarType pillar) {
        super(templateManager, templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", templateName)), templateName, fillBelow, position, rot, mi, wardOwner);
        this.type = pillar;
    }

    protected boolean isReplaceable(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a().func_76224_d()) {
            return true;
        }
        if (state.func_177230_c() == TABlocks.STONE) {
            ITAStoneType.StoneType type = (ITAStoneType.StoneType)((Object)state.func_177229_b(ITAStoneType.STONE_TYPE));
            return type == ITAStoneType.StoneType.STONE_VOID || type == ITAStoneType.StoneType.STONE_TAINT_NODECAY || type == ITAStoneType.StoneType.SOIL_STONE_TAINT_NODECAY;
        }
        return false;
    }

    @Override
    public void onPostGeneration(World world, StructureBoundingBox structurebb) {
        super.onPostGeneration(world, structurebb);
        if (structurebb.func_78884_a(this.field_74887_e)) {
            boolean maxX = false;
            boolean maxZ = false;
            Rotation rot = this.field_186177_b.func_186215_c();
            switch (rot) {
                case NONE: {
                    maxX = true;
                    maxZ = true;
                    break;
                }
                case CLOCKWISE_90: {
                    maxZ = true;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    maxX = true;
                    break;
                }
            }
            switch (this.field_186177_b.func_186212_b()) {
                case FRONT_BACK: {
                    if (rot == Rotation.CLOCKWISE_90 || rot == Rotation.COUNTERCLOCKWISE_90) {
                        maxZ = !maxZ;
                        break;
                    }
                    maxX = !maxX;
                    break;
                }
                case LEFT_RIGHT: {
                    if (rot == Rotation.NONE || rot == Rotation.CLOCKWISE_180) {
                        maxZ = !maxZ;
                        break;
                    }
                    maxX = !maxX;
                    break;
                }
            }
            switch (this.type) {
                case GENERIC: {
                    int posX = maxX ? this.field_74887_e.field_78893_d - this.field_74887_e.func_78883_b() / 2 : this.field_74887_e.field_78897_a + this.field_74887_e.func_78883_b() / 2;
                    int posZ = maxZ ? this.field_74887_e.field_78892_f - this.field_74887_e.func_78880_d() / 2 : this.field_74887_e.field_78896_c + this.field_74887_e.func_78880_d() / 2;
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(posX, this.field_74887_e.field_78894_e, posZ);
                    BlockPos center = mutable.func_185334_h();
                    for (int x = structurebb.field_78897_a; x <= structurebb.field_78893_d; ++x) {
                        block15: for (int z = structurebb.field_78896_c; z <= structurebb.field_78892_f; ++z) {
                            BlockPos distance;
                            int diff;
                            mutable.func_181079_c(x, this.field_74887_e.field_78894_e, z);
                            if (!this.field_74887_e.func_175898_b((Vec3i)mutable) || world.func_175623_d((BlockPos)mutable) || (diff = 4 - ((distance = new BlockPos(Math.abs(mutable.func_177958_n() - center.func_177958_n()), 0, Math.abs(mutable.func_177952_p() - center.func_177952_p()))).func_177958_n() + distance.func_177952_p())) < 0) continue;
                            IBlockState up = null;
                            if (diff == 0) {
                                if (distance.func_177958_n() == distance.func_177952_p()) {
                                    up = TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.ANCIENT_PILLAR));
                                } else {
                                    if (distance.func_177958_n() <= 0 || distance.func_177952_p() <= 0) continue;
                                    up = BlocksTC.stoneAncient.func_176223_P();
                                }
                            } else {
                                up = diff == 1 && (distance.func_177958_n() == 0 || distance.func_177952_p() == 0) ? BlocksTC.stoneEldritchTile.func_176223_P() : BlocksTC.stoneAncient.func_176223_P();
                            }
                            for (int y = this.field_74887_e.field_78894_e + 1; y < 256; ++y) {
                                mutable.func_185336_p(y);
                                if (!this.isReplaceable(world, (BlockPos)mutable)) continue block15;
                                this.setWardedBlockState(world, (BlockPos)mutable, up, 2);
                            }
                        }
                    }
                    break;
                }
                case MAZE: {
                    int posX = maxX ? this.field_74887_e.field_78893_d - this.field_74887_e.func_78883_b() / 2 : this.field_74887_e.field_78897_a + this.field_74887_e.func_78883_b() / 2;
                    int posZ = maxZ ? this.field_74887_e.field_78892_f - this.field_74887_e.func_78880_d() / 2 : this.field_74887_e.field_78896_c + this.field_74887_e.func_78880_d() / 2;
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(posX, this.field_74887_e.field_78894_e, posZ);
                    BlockPos center = mutable.func_185334_h();
                    for (int x = structurebb.field_78897_a; x <= structurebb.field_78893_d; ++x) {
                        block18: for (int z = structurebb.field_78896_c; z <= structurebb.field_78892_f; ++z) {
                            BlockPos distance;
                            int diff;
                            mutable.func_181079_c(x, this.field_74887_e.field_78894_e, z);
                            if (world.func_175623_d((BlockPos)mutable) || !this.field_74887_e.func_175898_b((Vec3i)mutable) || (diff = 2 - ((distance = new BlockPos(Math.abs(mutable.func_177958_n() - center.func_177958_n()), 0, Math.abs(mutable.func_177952_p() - center.func_177952_p()))).func_177958_n() + distance.func_177952_p())) < 0) continue;
                            IBlockState up = null;
                            up = diff == 0 ? (distance.func_177958_n() == 0 || distance.func_177952_p() == 0 ? BlocksTC.stoneEldritchTile.func_176223_P() : TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.ANCIENT_PILLAR))) : BlocksTC.stoneAncient.func_176223_P();
                            for (int y = this.field_74887_e.field_78894_e + 1; y < 256; ++y) {
                                mutable.func_185336_p(y);
                                if (!this.isReplaceable(world, (BlockPos)mutable)) continue block18;
                                this.setWardedBlockState(world, (BlockPos)mutable, up, 2);
                            }
                        }
                    }
                    break;
                }
                case LIBRARY: {
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                    Vec3d center = new Vec3d(maxX ? (double)this.field_74887_e.field_78893_d - (double)this.field_74887_e.func_78883_b() / 2.0 : (double)this.field_74887_e.field_78897_a + (double)this.field_74887_e.func_78883_b() / 2.0, (double)this.field_74887_e.field_78894_e, maxZ ? (double)this.field_74887_e.field_78892_f - (double)this.field_74887_e.func_78880_d() / 2.0 : (double)this.field_74887_e.field_78896_c + (double)this.field_74887_e.func_78880_d() / 2.0);
                    for (int x = structurebb.field_78897_a; x <= structurebb.field_78893_d; ++x) {
                        block21: for (int z = structurebb.field_78896_c; z <= structurebb.field_78892_f; ++z) {
                            BlockPos distance;
                            int diff;
                            mutable.func_181079_c(x, this.field_74887_e.field_78894_e, z);
                            if (world.func_175623_d((BlockPos)mutable) || !this.field_74887_e.func_175898_b((Vec3i)mutable) || (diff = 2 - ((distance = new BlockPos(Math.abs((double)mutable.func_177958_n() - center.field_72450_a), 0.0, Math.abs((double)mutable.func_177952_p() - center.field_72449_c))).func_177958_n() + distance.func_177952_p())) < 0) continue;
                            IBlockState up = null;
                            up = diff == 0 ? (distance.func_177958_n() == 0 || distance.func_177952_p() == 0 ? BlocksTC.stoneEldritchTile.func_176223_P() : TABlocks.STONE.func_176223_P().func_177226_a(ITAStoneType.STONE_TYPE, (Comparable)((Object)ITAStoneType.StoneType.ANCIENT_PILLAR))) : BlocksTC.stoneAncient.func_176223_P();
                            for (int y = this.field_74887_e.field_78894_e + 1; y < 256; ++y) {
                                mutable.func_185336_p(y);
                                if (!this.isReplaceable(world, (BlockPos)mutable)) continue block21;
                                this.setWardedBlockState(world, (BlockPos)mutable, up, 2);
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound tag) {
        super.func_143012_a(tag);
        tag.func_74768_a("pt", this.type.getID());
    }

    @Override
    protected void func_143011_b(NBTTagCompound tag, TemplateManager templateManager) {
        super.func_143011_b(tag, templateManager);
        this.type = PillarType.fromID(tag.func_74762_e("pt"));
    }

    public static enum PillarType {
        GENERIC(0),
        MAZE(1),
        LIBRARY(2);

        private final int id;

        private PillarType(int i) {
            this.id = i;
        }

        public int getID() {
            return this.id;
        }

        @Nullable
        public static PillarType fromID(int id) {
            for (PillarType t : PillarType.values()) {
                if (t.getID() != id) continue;
                return t;
            }
            return null;
        }
    }
}

