/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.world.structure;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import thecodex6824.thaumicaugmentation.common.util.maze.Maze;
import thecodex6824.thaumicaugmentation.common.util.maze.MazeCell;
import thecodex6824.thaumicaugmentation.common.util.maze.MazeGenerator;
import thecodex6824.thaumicaugmentation.common.world.ITAChunkGenerator;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireBaseComponent;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireComponent;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpireMazeComponent;
import thecodex6824.thaumicaugmentation.common.world.structure.EldritchSpirePillarComponent;

public class EldritchSpireComponentPlacer {
    protected static final String BASE = "spire/base_";
    protected static final String STAIR = "spire/stairs_";
    protected static final String GROUND_FLOOR = "spire/ground_floor_";
    protected static final String FIRST_FLOOR = "spire/first_floor_";
    protected static final String SECOND_FLOOR = "spire/second_floor_";
    protected static final String THIRD_FLOOR = "spire/third_floor_";
    protected static final String FOURTH_FLOOR = "spire/fourth_floor_";
    protected static final String PILLAR = "spire/pillar_";
    protected static final String PILLAR_BASE = "spire/pillar_b_";
    protected static final String CONNECTOR_MAZE = "spire/connector_maze_";
    protected static final String CONNECTOR_PRISON = "spire/connector_prison_";
    protected static final String CONNECTOR_LIBRARY = "spire/connector_library_";
    protected static final String CONNECTOR_BOSS = "spire/connector_boss_";
    protected static final String MAZE_SHELL_BL = "spire/maze/shell_bl_";
    protected static final String MAZE_SHELL_BR = "spire/maze/shell_br_";
    protected static final String MAZE_SHELL_FL = "spire/maze/shell_fl_";
    protected static final String MAZE_SHELL_FR = "spire/maze/shell_fr_";
    protected static final String MAZE_PILLAR = "spire/maze/pillar_";
    protected static final String MAZE_PILLAR_BASE = "spire/maze/pillar_b_";
    protected static final String MAZE_CELL_HALL_CROSS = "spire/maze/cell_hall_cross_";
    protected static final String MAZE_CELL_HALL_T = "spire/maze/cell_hall_t_";
    protected static final String MAZE_CELL_HALL_CORNER = "spire/maze/cell_hall_corner_";
    protected static final String MAZE_CELL_HALL_STRAIGHT = "spire/maze/cell_hall_straight_";
    protected static final String MAZE_CELL_HALL_END = "spire/maze/cell_hall_end_";
    protected static final String MAZE_CELL_ROOM_CROSS = "spire/maze/cell_room_cross_";
    protected static final String MAZE_CELL_ROOM_T = "spire/maze/cell_room_t_";
    protected static final String MAZE_CELL_ROOM_CORNER = "spire/maze/cell_room_corner_";
    protected static final String MAZE_CELL_ROOM_STRAIGHT = "spire/maze/cell_room_straight_";
    protected static final String MAZE_CELL_ROOM_END = "spire/maze/cell_room_end_";
    protected static final String MAZE_CELL_ENTRANCE_CROSS = "spire/maze/cell_entrance_cross_";
    protected static final String MAZE_CELL_ENTRANCE_T = "spire/maze/cell_entrance_t_";
    protected static final String MAZE_CELL_ENTRANCE_CORNER = "spire/maze/cell_entrance_corner_";
    protected static final String MAZE_CELL_ENTRANCE_STRAIGHT = "spire/maze/cell_entrance_straight_";
    protected static final String MAZE_CELL_ENTRANCE_END = "spire/maze/cell_entrance_end_";
    protected static final String MAZE_CELL_ROOM_END_CRAB = "spire/maze/cell_room_end_crab_";
    protected static final String MAZE_OVERLAY_ROOM = "spire/maze/cell_overlay_room_";
    protected static final String MAZE_OVERLAY_HALL = "spire/maze/cell_overlay_hall_";
    protected static final String MAZE_OVERLAY_WEB = "spire/maze/cell_overlay_web_";
    protected static final String MAZE_OVERLAY_KEY = "spire/maze/cell_overlay_key_";
    protected static final String PRISON_ENTRANCE = "spire/prison/entrance_";
    protected static final String PRISON_0 = "spire/prison/0_";
    protected static final String PRISON_0_CORNER = "spire/prison/0_cell_corner_";
    protected static final String PRISON_0_SIDE = "spire/prison/0_cell_side_";
    protected static final String PRISON_BLOCK_CONNECTOR = "spire/prison/connector_";
    protected static final String PRISON_1 = "spire/prison/1_";
    protected static final String PRISON_1_CORNER = "spire/prison/1_cell_corner_";
    protected static final String PRISON_1_SIDE = "spire/prison/1_cell_side_";
    protected static final String PRISON_EDGE = "spire/prison/cell_edge_";
    protected static final String LIBRARY_GROUND_FLOOR_FRONT = "spire/library/ground0_";
    protected static final String LIBRARY_GROUND_FLOOR_BACK = "spire/library/ground1_";
    protected static final String LIBRARY_FIRST_FLOOR_FRONT = "spire/library/first0_";
    protected static final String LIBRARY_FIRST_FLOOR_BACK = "spire/library/first1_";
    protected static final String LIBRARY_SECOND_FLOOR_FRONT = "spire/library/second0_";
    protected static final String LIBRARY_SECOND_FLOOR_BACK = "spire/library/second1_";
    protected static final String LIBRARY_BACK = "spire/library/back_";
    protected static final String LIBRARY_CORNER = "spire/library/corner_";
    protected static final String LIBRARY_SIDE_FRONT = "spire/library/side0_";
    protected static final String LIBRARY_SIDE_BACK = "spire/library/side1_";
    protected static final String LIBRARY_HALL_LOWER = "spire/library/lower_hall_";
    protected static final String LIBRARY_HALL_LOWER_BACK = "spire/library/lower_hall_back_";
    protected static final String LIBRARY_HALL_UPPER = "spire/library/upper_hall_";
    protected static final String LIBRARY_ALCOVE = "spire/library/alcove_";
    protected static final String LIBRARY_ALCOVE_KEY = "spire/library/alcove_key_";
    protected static final String LIBRARY_PILLAR = "spire/library/pillar_";
    protected static final String LIBRARY_PILLAR_BASE = "spire/library/pillar_b_";
    protected static final String BOSS = "spire/boss/boss_";
    protected static final ImmutableSet<String> TEMPLATE_PATHS = ImmutableSet.builder().add((Object[])new String[]{"spire/base_", "spire/stairs_", "spire/ground_floor_", "spire/first_floor_", "spire/second_floor_", "spire/third_floor_", "spire/fourth_floor_", "spire/connector_maze_", "spire/pillar_", "spire/pillar_b_", "spire/connector_prison_", "spire/connector_library_", "spire/connector_boss_", "spire/maze/shell_bl_", "spire/maze/shell_br_", "spire/maze/shell_fl_", "spire/maze/shell_fr_", "spire/maze/pillar_", "spire/maze/pillar_b_", "spire/maze/cell_hall_cross_", "spire/maze/cell_hall_t_", "spire/maze/cell_hall_corner_", "spire/maze/cell_hall_straight_", "spire/maze/cell_hall_end_", "spire/maze/cell_room_cross_", "spire/maze/cell_room_t_", "spire/maze/cell_room_corner_", "spire/maze/cell_room_straight_", "spire/maze/cell_room_end_", "spire/maze/cell_entrance_cross_", "spire/maze/cell_entrance_t_", "spire/maze/cell_entrance_corner_", "spire/maze/cell_entrance_straight_", "spire/maze/cell_entrance_end_", "spire/maze/cell_room_end_crab_", "spire/maze/cell_overlay_room_", "spire/maze/cell_overlay_hall_", "spire/maze/cell_overlay_web_", "spire/maze/cell_overlay_key_", "spire/prison/entrance_", "spire/prison/0_", "spire/prison/0_cell_corner_", "spire/prison/0_cell_side_", "spire/prison/connector_", "spire/prison/1_", "spire/prison/1_cell_corner_", "spire/prison/1_cell_side_", "spire/prison/cell_edge_", "spire/library/ground0_", "spire/library/ground1_", "spire/library/first0_", "spire/library/first1_", "spire/library/second0_", "spire/library/second1_", "spire/library/back_", "spire/library/corner_", "spire/library/side0_", "spire/library/side1_", "spire/library/lower_hall_", "spire/library/lower_hall_back_", "spire/library/upper_hall_", "spire/library/alcove_", "spire/library/alcove_key_", "spire/library/pillar_", "spire/library/pillar_b_", "spire/boss/boss_"}).build();
    protected static ImmutableMap<String, Integer> templateCounts = ImmutableMap.of();

    public static void register() {
        MapGenStructureIO.func_143031_a(EldritchSpireComponent.class, (String)"est");
        MapGenStructureIO.func_143031_a(EldritchSpireBaseComponent.class, (String)"estb");
        MapGenStructureIO.func_143031_a(EldritchSpireMazeComponent.class, (String)"estm");
        MapGenStructureIO.func_143031_a(EldritchSpirePillarComponent.class, (String)"estp");
    }

    public static void generate(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos position, Rotation rot, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        Mirror mirror = Mirror.values()[random.nextInt(Mirror.values().length)];
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos(position);
        BlockPos baseSize = EldritchSpireComponentPlacer.generateBase(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
        EldritchSpireComponentPlacer.generateGroundFloor(world, generator, templateManager, current, baseSize, rot, mirror, random, pieces, ward);
        EldritchSpireComponentPlacer.generateFirstFloor(world, generator, templateManager, current, baseSize, rot, mirror, random, pieces, ward);
        EldritchSpireComponentPlacer.generateSecondFloor(world, generator, templateManager, current, baseSize, rot, mirror, random, pieces, ward);
        EldritchSpireComponentPlacer.generateThirdFloor(world, generator, templateManager, current, baseSize, rot, mirror, random, pieces, ward);
        EldritchSpireComponentPlacer.generateFourthFloor(world, generator, templateManager, current, baseSize, rot, mirror, random, pieces, ward);
    }

    protected static BlockPos transformOffset(int x, int z, Rotation rot, Mirror mi) {
        return new BlockPos(mi == Mirror.FRONT_BACK ? -x : x, 0, mi == Mirror.LEFT_RIGHT ? -z : z).func_190942_a(rot);
    }

    protected static Rotation fromFacing(EnumFacing face) {
        switch (face) {
            case WEST: {
                return Rotation.CLOCKWISE_90;
            }
            case NORTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    protected static String pickTemplate(String type, Random rand) {
        int c = (Integer)templateCounts.get((Object)type);
        if (c == 1) {
            return type + "0";
        }
        return type + rand.nextInt(c);
    }

    protected static String getCellTypeHall(MazeCell cell) {
        switch (cell.getNumWalls()) {
            case 0: {
                return MAZE_CELL_HALL_CROSS;
            }
            case 1: {
                return MAZE_CELL_HALL_T;
            }
            case 2: {
                if (cell.isCorner()) {
                    return MAZE_CELL_HALL_CORNER;
                }
                return MAZE_CELL_HALL_STRAIGHT;
            }
            case 3: {
                return MAZE_CELL_HALL_END;
            }
        }
        return "spire/maze/cell_closed";
    }

    protected static String getCellTypeNormalRoom(MazeCell cell) {
        switch (cell.getNumWalls()) {
            case 0: {
                return MAZE_CELL_ROOM_CROSS;
            }
            case 1: {
                return MAZE_CELL_ROOM_T;
            }
            case 2: {
                if (cell.isCorner()) {
                    return MAZE_CELL_ROOM_CORNER;
                }
                return MAZE_CELL_ROOM_STRAIGHT;
            }
            case 3: {
                return MAZE_CELL_ROOM_END;
            }
        }
        return "spire/maze/cell_closed";
    }

    protected static String getCellTypeCrabRoom(MazeCell cell) {
        if (cell.getNumWalls() == 3) {
            return MAZE_CELL_ROOM_END_CRAB;
        }
        return "spire/maze/cell_closed";
    }

    protected static String getCellTypeEntrance(MazeCell cell) {
        switch (cell.getNumWalls()) {
            case 0: {
                return MAZE_CELL_ENTRANCE_CROSS;
            }
            case 1: {
                return MAZE_CELL_ENTRANCE_T;
            }
            case 2: {
                if (cell.isCorner()) {
                    return MAZE_CELL_ENTRANCE_CORNER;
                }
                return MAZE_CELL_ENTRANCE_STRAIGHT;
            }
            case 3: {
                return MAZE_CELL_ENTRANCE_END;
            }
        }
        return "spire/maze/cell_closed";
    }

    private static int findGroundBlockInPrimer(ChunkPrimer primer, int x, int z) {
        for (int y = 255; y >= 0; --y) {
            IBlockState state = primer.func_177856_a(x, y, z);
            if (state.func_185904_a() == Material.field_151579_a) continue;
            return y;
        }
        return 0;
    }

    public static void generateGenericPillar(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos backup = current.func_185334_h();
        String name = EldritchSpireComponentPlacer.pickTemplate(PILLAR, random);
        Template sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward));
        name = EldritchSpireComponentPlacer.pickTemplate(PILLAR_BASE, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(backup.func_177958_n() + add.func_177958_n(), backup.func_177956_o(), backup.func_177952_p() + add.func_177952_p());
        ChunkPrimer primer = new ChunkPrimer();
        generator.populatePrimerWithHeightmap(current.func_177958_n() >> 4, current.func_177952_p() >> 4, primer);
        current.func_185336_p(Math.max(EldritchSpireComponentPlacer.findGroundBlockInPrimer(primer, current.func_177958_n() & 0xF, current.func_177952_p() & 0xF), 1));
        pieces.add(new EldritchSpirePillarComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward, EldritchSpirePillarComponent.PillarType.GENERIC));
        current.func_189533_g((Vec3i)backup);
    }

    public static BlockPos generateBase(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos original = current.func_185334_h();
        EldritchSpireBaseComponent base = new EldritchSpireBaseComponent(templateManager, EldritchSpireComponentPlacer.pickTemplate(BASE, random), true, original, rot, mirror, ward);
        pieces.add(base);
        BlockPos offset = current.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(base.getTemplate().func_186259_a().func_177958_n() / 2, base.getTemplate().func_186259_a().func_177952_p() / 2, rot, mirror));
        current.func_189533_g((Vec3i)offset);
        for (EnumFacing f : EnumFacing.field_176754_o) {
            EnumFacing face = rot.func_185831_a(mirror.func_185803_b(f));
            String tName = EldritchSpireComponentPlacer.pickTemplate(STAIR, random);
            Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
            BlockPos add = EldritchSpireComponentPlacer.transformOffset(base.getTemplate().func_186259_a().func_177958_n() / 2 + 1, base.getTemplate().func_186259_a().func_177952_p() / 2 + 1, rot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(face)), mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            add = EldritchSpireComponentPlacer.transformOffset((-template.func_186259_a().func_177958_n() - base.getTemplate().func_186259_a().func_177958_n()) / 2, 0, rot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(face)), mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            pieces.add(new EldritchSpireBaseComponent(templateManager, template, tName, true, current.func_185334_h(), rot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(face)), mirror, ward));
            current.func_189533_g((Vec3i)offset);
        }
        current.func_189533_g((Vec3i)original.func_177981_b(base.getTemplate().func_186259_a().func_177956_o()));
        return base.getTemplate().func_186259_a();
    }

    public static void generateGroundFloor(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String tName = EldritchSpireComponentPlacer.pickTemplate(GROUND_FLOOR, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos original = current.func_185334_h();
        BlockPos add = EldritchSpireComponentPlacer.transformOffset((baseSize.func_177958_n() - template.func_186259_a().func_177958_n()) / 2, (baseSize.func_177952_p() - template.func_186259_a().func_177952_p()) / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponent floor = new EldritchSpireComponent(templateManager, template, tName, true, current.func_185334_h(), rot, mirror, ward);
        pieces.add(floor);
        current.func_189533_g((Vec3i)original.func_177981_b(floor.getTemplate().func_186259_a().func_177956_o()));
    }

    public static void generateFirstFloor(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String tName = EldritchSpireComponentPlacer.pickTemplate(FIRST_FLOOR, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos original = current.func_185334_h();
        BlockPos add = EldritchSpireComponentPlacer.transformOffset((baseSize.func_177958_n() - template.func_186259_a().func_177958_n()) / 2, (baseSize.func_177952_p() - template.func_186259_a().func_177952_p()) / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponent floor = new EldritchSpireComponent(templateManager, template, tName, true, current.func_185334_h(), rot, mirror, ward);
        pieces.add(floor);
        String cName = EldritchSpireComponentPlacer.pickTemplate(CONNECTOR_MAZE, random);
        Template cTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", cName));
        BlockPos backup = current.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(0, template.func_186259_a().func_177952_p() + cTemplate.func_186259_a().func_177952_p() + 1, rot, mirror));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2, template.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(cTemplate.func_186259_a().func_177958_n() / 2, cTemplate.func_186259_a().func_177952_p() - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        Rotation cRot = mirror == Mirror.LEFT_RIGHT ? rot.func_185830_a(Rotation.CLOCKWISE_180) : rot;
        pieces.add(new EldritchSpireComponent(templateManager, cTemplate, cName, false, current.func_185334_h(), cRot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(mirror.func_185803_b(EnumFacing.NORTH))), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        EldritchSpireComponentPlacer.generateMaze(world, generator, templateManager, current, cTemplate.func_186259_a(), rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)original.func_177981_b(floor.getTemplate().func_186259_a().func_177956_o()));
    }

    public static void generateMazePillar(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos backup = current.func_185334_h();
        String name = EldritchSpireComponentPlacer.pickTemplate(MAZE_PILLAR, random);
        Template sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward));
        name = EldritchSpireComponentPlacer.pickTemplate(MAZE_PILLAR_BASE, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 5 - 1, rot, mirror);
        current.func_181079_c(backup.func_177958_n() + add.func_177958_n(), backup.func_177956_o(), backup.func_177952_p() + add.func_177952_p());
        ChunkPrimer primer = new ChunkPrimer();
        generator.populatePrimerWithHeightmap(current.func_177958_n() >> 4, current.func_177952_p() >> 4, primer);
        current.func_185336_p(Math.max(EldritchSpireComponentPlacer.findGroundBlockInPrimer(primer, current.func_177958_n() & 0xF, current.func_177952_p() & 0xF), 1));
        pieces.add(new EldritchSpirePillarComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward, EldritchSpirePillarComponent.PillarType.MAZE));
        current.func_189533_g((Vec3i)backup);
    }

    public static void generateMaze(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos origin = current.func_185334_h().func_177979_c(4);
        String shellName = EldritchSpireComponentPlacer.pickTemplate(MAZE_SHELL_BL, random);
        Template sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", shellName));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(MathHelper.func_76123_f((float)((float)(sTemplate.func_186259_a().func_177958_n() - baseSize.func_177958_n()) / 2.0f)) + 1, sTemplate.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(origin.func_177958_n() + add.func_177958_n(), origin.func_177956_o(), origin.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, shellName, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(sTemplate.func_186259_a().func_177958_n() - 4, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateMazePillar(world, generator, templateManager, current, mirror != Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, random, pieces, ward);
        current.func_181079_c(current.func_177958_n() - add.func_177958_n(), current.func_177956_o(), current.func_177952_p() - add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(-1, sTemplate.func_186259_a().func_177952_p() - 4, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateMazePillar(world, generator, templateManager, current, rot.func_185830_a(Rotation.CLOCKWISE_180), mirror, random, pieces, ward);
        shellName = EldritchSpireComponentPlacer.pickTemplate(MAZE_SHELL_FL, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", shellName));
        add = EldritchSpireComponentPlacer.transformOffset(MathHelper.func_76123_f((float)((float)(sTemplate.func_186259_a().func_177958_n() - baseSize.func_177958_n()) / 2.0f)) + 1, -1, rot, mirror);
        current.func_181079_c(origin.func_177958_n() + add.func_177958_n(), origin.func_177956_o(), origin.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, shellName, false, current.func_185334_h(), rot, mirror, ward));
        shellName = EldritchSpireComponentPlacer.pickTemplate(MAZE_SHELL_BR, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", shellName));
        add = EldritchSpireComponentPlacer.transformOffset((-sTemplate.func_186259_a().func_177958_n() - baseSize.func_177958_n()) / 2 + 2, sTemplate.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(origin.func_177958_n() + add.func_177958_n(), origin.func_177956_o(), origin.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, shellName, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(3, -2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateMazePillar(world, generator, templateManager, current, mirror != Mirror.NONE ? rot.func_185830_a(Rotation.CLOCKWISE_90) : rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90), mirror, random, pieces, ward);
        shellName = EldritchSpireComponentPlacer.pickTemplate(MAZE_SHELL_FR, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", shellName));
        add = EldritchSpireComponentPlacer.transformOffset((-sTemplate.func_186259_a().func_177958_n() - baseSize.func_177958_n()) / 2 + 2, -1, rot, mirror);
        current.func_181079_c(origin.func_177958_n() + add.func_177958_n(), origin.func_177956_o(), origin.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, shellName, false, current.func_185334_h(), rot, mirror, ward));
        origin = origin.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(sTemplate.func_186259_a().func_177958_n() + 1, sTemplate.func_186259_a().func_177952_p() + baseSize.func_177952_p() + 6, rot, mirror).func_177981_b(2));
        Maze maze = new MazeGenerator().withSize(5, 5).generate(random);
        int keyX = random.nextInt(maze.getWidth());
        for (int z = 0; z < maze.getLength(); ++z) {
            for (int x = 0; x < maze.getWidth(); ++x) {
                MazeCell cell = maze.getCell(x, z);
                String cellName = null;
                String overlayName = null;
                if (z == maze.getLength() - 1 && x == maze.getWidth() / 2) {
                    cell.setWall(EnumFacing.SOUTH, false);
                    cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeEntrance(cell), random);
                } else if (z == 0 && x == keyX) {
                    cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeNormalRoom(cell), random);
                    overlayName = EldritchSpireComponentPlacer.pickTemplate(MAZE_OVERLAY_KEY, random);
                } else if (random.nextInt(4) == 0) {
                    if (cell.getNumWalls() == 3 && random.nextInt(2) == 0) {
                        cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeCrabRoom(cell), random);
                    } else {
                        cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeNormalRoom(cell), random);
                        overlayName = EldritchSpireComponentPlacer.pickTemplate(MAZE_OVERLAY_ROOM, random);
                    }
                } else if (cell.getNumWalls() == 3 && random.nextInt(2) == 0) {
                    cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeCrabRoom(cell), random);
                } else {
                    cellName = EldritchSpireComponentPlacer.pickTemplate(EldritchSpireComponentPlacer.getCellTypeHall(cell), random);
                    overlayName = random.nextInt(8) == 0 ? EldritchSpireComponentPlacer.pickTemplate(MAZE_OVERLAY_WEB, random) : EldritchSpireComponentPlacer.pickTemplate(MAZE_OVERLAY_HALL, random);
                }
                Rotation adjust = Rotation.NONE;
                if (cell.getNumWalls() == 1) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (!cell.hasWall(dir)) continue;
                        switch (mirror.func_185803_b(dir)) {
                            case EAST: {
                                adjust = Rotation.CLOCKWISE_90;
                                break;
                            }
                            case SOUTH: {
                                adjust = Rotation.CLOCKWISE_180;
                                break;
                            }
                            case WEST: {
                                adjust = Rotation.COUNTERCLOCKWISE_90;
                                break;
                            }
                        }
                        if (mirror != Mirror.LEFT_RIGHT) break;
                        adjust = adjust.func_185830_a(Rotation.CLOCKWISE_180);
                        break;
                    }
                } else if (cell.getNumWalls() == 2) {
                    if (cell.isCorner()) {
                        EnumFacing open1 = null;
                        EnumFacing open2 = null;
                        for (EnumFacing dir : EnumFacing.field_176754_o) {
                            if (cell.hasWall(dir)) continue;
                            if (open1 == null) {
                                open1 = mirror.func_185803_b(dir);
                                continue;
                            }
                            open2 = mirror.func_185803_b(dir);
                            break;
                        }
                        int angle1 = (int)open1.func_185119_l();
                        int angle2 = (int)open2.func_185119_l();
                        if (mirror == Mirror.FRONT_BACK) {
                            angle1 = (angle1 + 270) % 360;
                            angle2 = (angle2 + 270) % 360;
                        } else if (mirror == Mirror.LEFT_RIGHT) {
                            angle1 = (angle1 + 90) % 360;
                            angle2 = (angle2 + 90) % 360;
                        }
                        int temp = Math.min(angle1, angle2);
                        if (temp == angle2) {
                            angle2 = angle1;
                            angle1 = temp;
                        }
                        if (angle1 == 0 && angle2 == 90) {
                            adjust = Rotation.CLOCKWISE_90;
                        } else if (angle1 == 90 && angle2 == 180) {
                            adjust = Rotation.CLOCKWISE_180;
                        } else if (angle1 == 180 && angle2 == 270) {
                            adjust = Rotation.COUNTERCLOCKWISE_90;
                        }
                    } else {
                        boolean wallNorth = cell.hasWall(EnumFacing.NORTH);
                        if (wallNorth) {
                            adjust = Rotation.CLOCKWISE_90;
                        }
                    }
                } else if (cell.getNumWalls() == 3) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (cell.hasWall(dir)) continue;
                        switch (mirror.func_185803_b(dir.func_176734_d())) {
                            case EAST: {
                                adjust = Rotation.CLOCKWISE_90;
                                break;
                            }
                            case SOUTH: {
                                adjust = Rotation.CLOCKWISE_180;
                                break;
                            }
                            case WEST: {
                                adjust = Rotation.COUNTERCLOCKWISE_90;
                                break;
                            }
                        }
                        if (mirror != Mirror.LEFT_RIGHT) break;
                        adjust = adjust.func_185830_a(Rotation.CLOCKWISE_180);
                        break;
                    }
                }
                int offsetX = 0;
                int offsetZ = 0;
                switch (adjust) {
                    case NONE: {
                        offsetX = 0;
                        offsetZ = 0;
                        break;
                    }
                    case CLOCKWISE_90: {
                        offsetX = 10;
                        offsetZ = 0;
                        break;
                    }
                    case CLOCKWISE_180: {
                        offsetX = 10;
                        offsetZ = 10;
                        break;
                    }
                    case COUNTERCLOCKWISE_90: {
                        offsetX = 0;
                        offsetZ = 10;
                        break;
                    }
                }
                if (mirror != Mirror.NONE) {
                    int temp = offsetX;
                    offsetX = offsetZ;
                    offsetZ = temp;
                }
                BlockPos move = EldritchSpireComponentPlacer.transformOffset(-11, -11, Rotation.NONE, mirror);
                BlockPos offsets = EldritchSpireComponentPlacer.transformOffset(offsetX, offsetZ, rot, mirror);
                Rotation transformRot = rot;
                if (mirror != Mirror.NONE) {
                    switch (rot) {
                        case CLOCKWISE_90: {
                            transformRot = Rotation.COUNTERCLOCKWISE_90;
                            break;
                        }
                        case CLOCKWISE_180: {
                            transformRot = Rotation.CLOCKWISE_180;
                            break;
                        }
                        case COUNTERCLOCKWISE_90: {
                            transformRot = Rotation.CLOCKWISE_90;
                            break;
                        }
                        default: {
                            transformRot = Rotation.NONE;
                        }
                    }
                }
                BlockPos xz = EldritchSpireComponentPlacer.transformOffset(x, z, transformRot, Mirror.NONE);
                add = new BlockPos(xz.func_177958_n() * move.func_177958_n() + offsets.func_177958_n(), 0, xz.func_177952_p() * move.func_177952_p() + offsets.func_177952_p());
                BlockPos cellLoc = origin.func_177971_a((Vec3i)add);
                pieces.add(new EldritchSpireMazeComponent(templateManager, templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", cellName)), cellName, false, cellLoc, rot.func_185830_a(adjust), mirror, ward));
                if (overlayName == null) continue;
                pieces.add(new EldritchSpireMazeComponent(templateManager, templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", overlayName)), overlayName, false, cellLoc, rot.func_185830_a(adjust), mirror, ward));
            }
        }
    }

    public static void generateSecondFloor(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String tName = EldritchSpireComponentPlacer.pickTemplate(SECOND_FLOOR, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos original = current.func_185334_h();
        BlockPos add = EldritchSpireComponentPlacer.transformOffset((baseSize.func_177958_n() - template.func_186259_a().func_177958_n()) / 2, (baseSize.func_177952_p() - template.func_186259_a().func_177952_p()) / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponent floor = new EldritchSpireComponent(templateManager, template, tName, true, current.func_185334_h(), rot, mirror, ward);
        pieces.add(floor);
        String cName = EldritchSpireComponentPlacer.pickTemplate(CONNECTOR_PRISON, random);
        Template cTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", cName));
        BlockPos backup = current.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(cTemplate.func_186259_a().func_177958_n() / 2, 0, rot, mirror));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(cTemplate.func_186259_a().func_177958_n() / 2, -1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        Rotation cRot = mirror == Mirror.LEFT_RIGHT ? rot.func_185830_a(Rotation.CLOCKWISE_180) : rot;
        pieces.add(new EldritchSpireComponent(templateManager, cTemplate, cName, false, current.func_185334_h(), cRot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(mirror.func_185803_b(EnumFacing.NORTH))), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        EldritchSpireComponentPlacer.generatePrison(world, generator, templateManager, current, cTemplate.func_186259_a(), rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)original.func_177981_b(floor.getTemplate().func_186259_a().func_177956_o()));
    }

    public static void generatePrison(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_ENTRANCE, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n(), -template.func_186259_a().func_177952_p() - baseSize.func_177952_p(), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 3, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, piece, false, current.func_185334_h(), rot, mirror, ward));
        int entranceSizeX = template.func_186259_a().func_177958_n();
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        BlockPos backup = current.func_185334_h();
        Mirror reflection = null;
        Rotation reflectedRot = rot;
        switch (mirror) {
            case NONE: {
                reflection = Mirror.FRONT_BACK;
                break;
            }
            case LEFT_RIGHT: {
                reflection = Mirror.NONE;
                reflectedRot = reflectedRot.func_185830_a(Rotation.CLOCKWISE_180);
                break;
            }
            case FRONT_BACK: {
                reflection = Mirror.NONE;
                break;
            }
            default: {
                reflection = mirror;
            }
        }
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_EDGE, random);
        Template edge1 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(edge1.func_186259_a().func_177958_n() + entranceSizeX / 2, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, edge1, piece, false, current.func_185334_h(), reflectedRot, reflection, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_EDGE, random);
        Template edge2 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-edge2.func_186259_a().func_177958_n() - entranceSizeX / 2, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, edge2, piece, false, current.func_185334_h(), rot, mirror, ward));
        current.func_189533_g((Vec3i)backup);
        EldritchSpireComponentPlacer.generatePrisonBlock0(world, generator, templateManager, current, edge1.func_186259_a(), edge2.func_186259_a(), template.func_186259_a(), rot, mirror, random, pieces, ward);
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2, 0, rot, mirror);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_BLOCK_CONNECTOR, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() / 2, -template.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 5, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, piece, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 5, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generatePrisonBlock1(world, generator, templateManager, current, template.func_186259_a(), rot, mirror, random, pieces, ward);
    }

    public static void generatePrisonBlock0(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos edgeSize1, BlockPos edgeSize2, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos backup = current.func_185334_h();
        String piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_CORNER, random);
        Template corner1 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(corner1.func_186259_a().func_177958_n() + edgeSize1.func_177958_n() + baseSize.func_177958_n() / 2, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner1, piece, false, current.func_185334_h(), rot.func_185830_a(Rotation.CLOCKWISE_180), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_CORNER, random);
        Template corner2 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner2.func_186259_a().func_177958_n() - edgeSize2.func_177958_n() - baseSize.func_177958_n() / 2, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner2, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_SIDE, random);
        Template side1 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(corner1.func_186259_a().func_177958_n() + edgeSize1.func_177958_n() + baseSize.func_177958_n() / 2, -side1.func_186259_a().func_177958_n() - corner1.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, side1, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.CLOCKWISE_90) : rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_SIDE, random);
        Template side2 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner2.func_186259_a().func_177958_n() - edgeSize2.func_177958_n() - baseSize.func_177958_n() / 2, -corner1.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, side2, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_CORNER, random);
        Template corner3 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(corner3.func_186259_a().func_177958_n() + edgeSize1.func_177958_n() + baseSize.func_177958_n() / 2, -corner3.func_186259_a().func_177952_p() - side1.func_186259_a().func_177958_n() - corner1.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner3, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.CLOCKWISE_90) : rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0_CORNER, random);
        Template corner4 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner4.func_186259_a().func_177958_n() - edgeSize2.func_177958_n() - baseSize.func_177958_n() / 2, -corner4.func_186259_a().func_177952_p() - side2.func_186259_a().func_177958_n() - corner2.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner4, piece, false, current.func_185334_h(), rot, mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_0, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() / 2, -template.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 5, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, piece, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 - baseSize.func_177958_n() / 2, 0, rot, mirror);
        BlockPos resume = new BlockPos(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 5, current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, template.func_186259_a().func_177952_p() / 2 + 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateGenericPillar(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)resume);
    }

    public static void generatePrisonBlock1(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos backup = current.func_185334_h();
        String piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_CORNER, random);
        Template corner1 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(corner1.func_186259_a().func_177958_n() + baseSize.func_177958_n() / 2, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner1, piece, false, current.func_185334_h(), rot.func_185830_a(Rotation.CLOCKWISE_180), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_CORNER, random);
        Template corner2 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner2.func_186259_a().func_177958_n() - baseSize.func_177958_n() / 2, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner2, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_SIDE, random);
        Template side1 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(corner1.func_186259_a().func_177958_n() + baseSize.func_177958_n() / 2, -side1.func_186259_a().func_177958_n() - corner1.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, side1, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.CLOCKWISE_90) : rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_SIDE, random);
        Template side2 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner2.func_186259_a().func_177958_n() - baseSize.func_177958_n() / 2, -corner1.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, side2, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_CORNER, random);
        Template corner3 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(corner3.func_186259_a().func_177958_n() + baseSize.func_177958_n() / 2, -corner3.func_186259_a().func_177952_p() - side1.func_186259_a().func_177958_n() - corner1.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner3, piece, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.CLOCKWISE_90) : rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_CORNER, random);
        Template corner4 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-corner4.func_186259_a().func_177958_n() - baseSize.func_177958_n() / 2, -corner4.func_186259_a().func_177952_p() - side2.func_186259_a().func_177958_n() - corner2.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, corner4, piece, false, current.func_185334_h(), rot, mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1_SIDE, random);
        Template side3 = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-side3.func_186259_a().func_177958_n() / 2, -corner4.func_186259_a().func_177952_p() - side2.func_186259_a().func_177958_n() - corner2.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, side3, piece, false, current.func_185334_h(), rot, mirror, ward));
        current.func_189533_g((Vec3i)backup);
        piece = EldritchSpireComponentPlacer.pickTemplate(PRISON_1, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", piece));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() / 2, -template.func_186259_a().func_177952_p(), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 5, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, piece, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, template.func_186259_a().func_177952_p() / 2 + 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateGenericPillar(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
    }

    public static void generateThirdFloor(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String tName = EldritchSpireComponentPlacer.pickTemplate(THIRD_FLOOR, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos original = current.func_185334_h();
        BlockPos add = EldritchSpireComponentPlacer.transformOffset((baseSize.func_177958_n() - template.func_186259_a().func_177958_n()) / 2, (baseSize.func_177952_p() - template.func_186259_a().func_177952_p()) / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponent floor = new EldritchSpireComponent(templateManager, template, tName, true, current.func_185334_h(), rot, mirror, ward);
        pieces.add(floor);
        String cName = EldritchSpireComponentPlacer.pickTemplate(CONNECTOR_LIBRARY, random);
        Template cTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", cName));
        BlockPos backup = current.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177952_p() - cTemplate.func_186259_a().func_177952_p(), 0, rot, mirror));
        add = EldritchSpireComponentPlacer.transformOffset(0, template.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(-cTemplate.func_186259_a().func_177952_p(), cTemplate.func_186259_a().func_177958_n() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        Rotation cRot = mirror == Mirror.LEFT_RIGHT ? rot.func_185830_a(Rotation.CLOCKWISE_180) : rot;
        pieces.add(new EldritchSpireComponent(templateManager, cTemplate, cName, false, current.func_185334_h(), cRot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(mirror.func_185803_b(EnumFacing.EAST))), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        EldritchSpireComponentPlacer.generateLibrary(world, generator, templateManager, current, cTemplate.func_186259_a(), rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)original.func_177981_b(floor.getTemplate().func_186259_a().func_177956_o()));
    }

    public static void generateLibraryPillar(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        BlockPos backup = current.func_185334_h();
        String name = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_PILLAR, random);
        Template sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward));
        name = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_PILLAR_BASE, random);
        sTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", name));
        add = EldritchSpireComponentPlacer.transformOffset(-sTemplate.func_186259_a().func_177958_n() / 2 - 1, -sTemplate.func_186259_a().func_177952_p() / 2 + 2, rot, mirror);
        current.func_181079_c(backup.func_177958_n() + add.func_177958_n(), backup.func_177956_o(), backup.func_177952_p() + add.func_177952_p());
        ChunkPrimer primer = new ChunkPrimer();
        generator.populatePrimerWithHeightmap(current.func_177958_n() >> 4, current.func_177952_p() >> 4, primer);
        current.func_185336_p(Math.max(EldritchSpireComponentPlacer.findGroundBlockInPrimer(primer, current.func_177958_n() & 0xF, current.func_177952_p() & 0xF), 1));
        pieces.add(new EldritchSpirePillarComponent(templateManager, sTemplate, name, false, current.func_185334_h(), rot, mirror, ward, EldritchSpirePillarComponent.PillarType.LIBRARY));
        current.func_189533_g((Vec3i)backup);
    }

    public static void generateLibrary(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos connectorSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        int i;
        int i2;
        BlockPos backup = current.func_185334_h();
        String tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_GROUND_FLOOR_FRONT, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - 1, -2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 3, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        BlockPos.MutableBlockPos mainSize = new BlockPos.MutableBlockPos(template.func_186259_a());
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_GROUND_FLOOR_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177952_p() - 1, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), template.func_186259_a().func_177952_p() / 2 - 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 13, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        int backSizeZ = template.func_186259_a().func_177952_p();
        BlockPos cornerSideBackup = current.func_185334_h();
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_CORNER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(0, template.func_186259_a().func_177952_p() - (template.func_186259_a().func_177952_p() - backSizeZ), rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 11, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SIDE_FRONT, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - 1, backSizeZ + template.func_186259_a().func_177952_p() + 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 13, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        BlockPos sideSize = template.func_186259_a();
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SIDE_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        Mirror reflection = null;
        Rotation reflectedRot = rot;
        switch (mirror) {
            case NONE: {
                reflection = Mirror.LEFT_RIGHT;
                break;
            }
            case LEFT_RIGHT: {
                reflection = Mirror.NONE;
                break;
            }
            case FRONT_BACK: {
                reflection = Mirror.NONE;
                reflectedRot = reflectedRot.func_185830_a(Rotation.CLOCKWISE_180);
                break;
            }
            default: {
                reflection = mirror;
            }
        }
        current.func_189533_g((Vec3i)cornerSideBackup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_CORNER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(0, -1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 11, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SIDE_FRONT, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - 1, -3, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 13, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SIDE_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(connectorSize.func_177952_p() / 2, -template.func_186259_a().func_177952_p() - 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        BlockPos pillarTemp = current.func_185334_h();
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateLibraryPillar(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)pillarTemp);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateLibraryPillar(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(connectorSize.func_177952_p() / 2, mainSize.func_177952_p() + template.func_186259_a().func_177952_p() - 3, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        pillarTemp = current.func_185334_h();
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, 5, reflectedRot, reflection);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateLibraryPillar(world, generator, templateManager, current, reflectedRot, reflection, random, pieces, ward);
        current.func_189533_g((Vec3i)pillarTemp);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_LOWER_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n(), 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() / 2 + 1, 5, reflectedRot, reflection);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateLibraryPillar(world, generator, templateManager, current, reflectedRot, reflection, random, pieces, ward);
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_UPPER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() - 2, -template.func_186259_a().func_177952_p() - sideSize.func_177952_p() - 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 14, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        for (i2 = 0; i2 < 2; ++i2) {
            tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_UPPER, random);
            template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
            add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() - 8, 0, rot, mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        }
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_UPPER, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n() - 2, mainSize.func_177952_p() + template.func_186259_a().func_177952_p() + sideSize.func_177952_p() - 3, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + 14, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        for (i2 = 0; i2 < 2; ++i2) {
            tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_HALL_UPPER, random);
            template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
            add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() - 8, 0, rot, mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        }
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_FIRST_FLOOR_FRONT, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - 1, -2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + mainSize.func_177956_o() - 3, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_FIRST_FLOOR_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177952_p() - 1, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        int heightAdd = template.func_186259_a().func_177956_o();
        int keyAlcove = random.nextInt(14);
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == 0 ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(connectorSize.func_177952_p() / 2 + template.func_186259_a().func_177958_n() + 1, -template.func_186259_a().func_177952_p() - 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + mainSize.func_177956_o() + template.func_186259_a().func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        for (i = 1; i < 6; ++i) {
            tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == i ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
            template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
            add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() - (i == 3 ? 2 : 1), 0, rot, mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        }
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == 6 ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(connectorSize.func_177952_p() / 2 + template.func_186259_a().func_177958_n() + 1, mainSize.func_177952_p() + template.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + mainSize.func_177956_o() + template.func_186259_a().func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        for (i = 7; i < 12; ++i) {
            tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == i ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
            template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
            add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177958_n() - (i == 9 ? 2 : 1), 0, rot, mirror);
            current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
            pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), reflectedRot, reflection, ward));
        }
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == 12 ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - mainSize.func_177958_n() - template.func_186259_a().func_177952_p() - 1, template.func_186259_a().func_177958_n() + 5, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + mainSize.func_177956_o() + template.func_186259_a().func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(keyAlcove == 13 ? LIBRARY_ALCOVE_KEY : LIBRARY_ALCOVE, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(0, template.func_186259_a().func_177958_n() + 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), mirror == Mirror.NONE ? rot.func_185830_a(Rotation.COUNTERCLOCKWISE_90) : rot.func_185830_a(Rotation.CLOCKWISE_90), mirror, ward));
        mainSize.func_185336_p(mainSize.func_177956_o() + heightAdd);
        current.func_189533_g((Vec3i)backup);
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SECOND_FLOOR_FRONT, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-connectorSize.func_177952_p() / 2 - 1, -2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() + mainSize.func_177956_o() - 3, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
        tName = EldritchSpireComponentPlacer.pickTemplate(LIBRARY_SECOND_FLOOR_BACK, random);
        template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        add = EldritchSpireComponentPlacer.transformOffset(-template.func_186259_a().func_177952_p() - 1, 0, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, template, tName, false, current.func_185334_h(), rot, mirror, ward));
    }

    public static void generateFourthFloor(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String tName = EldritchSpireComponentPlacer.pickTemplate(FOURTH_FLOOR, random);
        Template template = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", tName));
        BlockPos original = current.func_185334_h();
        BlockPos add = EldritchSpireComponentPlacer.transformOffset((baseSize.func_177958_n() - template.func_186259_a().func_177958_n()) / 2, (baseSize.func_177952_p() - template.func_186259_a().func_177952_p()) / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponent floor = new EldritchSpireComponent(templateManager, template, tName, true, current.func_185334_h(), rot, mirror, ward);
        pieces.add(floor);
        String cName = EldritchSpireComponentPlacer.pickTemplate(CONNECTOR_BOSS, random);
        Template cTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", cName));
        BlockPos backup = current.func_177971_a((Vec3i)EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177952_p() + cTemplate.func_186259_a().func_177952_p() + 1, 0, rot, mirror));
        add = EldritchSpireComponentPlacer.transformOffset(template.func_186259_a().func_177958_n(), template.func_186259_a().func_177952_p() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        add = EldritchSpireComponentPlacer.transformOffset(cTemplate.func_186259_a().func_177952_p() - 1, -cTemplate.func_186259_a().func_177958_n() / 2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o(), current.func_177952_p() + add.func_177952_p());
        Rotation cRot = mirror == Mirror.LEFT_RIGHT ? rot.func_185830_a(Rotation.CLOCKWISE_180) : rot;
        pieces.add(new EldritchSpireComponent(templateManager, cTemplate, cName, false, current.func_185334_h(), cRot.func_185830_a(EldritchSpireComponentPlacer.fromFacing(mirror.func_185803_b(EnumFacing.WEST))), mirror, ward));
        current.func_189533_g((Vec3i)backup);
        EldritchSpireComponentPlacer.generateBossRoom(world, generator, templateManager, current, cTemplate.func_186259_a(), rot, mirror, random, pieces, ward);
        current.func_189533_g((Vec3i)original.func_177981_b(floor.getTemplate().func_186259_a().func_177956_o()));
    }

    public static void generateBossRoom(World world, ITAChunkGenerator generator, TemplateManager templateManager, BlockPos.MutableBlockPos current, BlockPos baseSize, Rotation rot, Mirror mirror, Random random, List<EldritchSpireComponent> pieces, UUID ward) {
        String bossName = EldritchSpireComponentPlacer.pickTemplate(BOSS, random);
        Template bTemplate = templateManager.func_189942_b(FMLCommonHandler.instance().getMinecraftServerInstance(), new ResourceLocation("thaumicaugmentation", bossName));
        BlockPos add = EldritchSpireComponentPlacer.transformOffset(-1, -2, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 2, current.func_177952_p() + add.func_177952_p());
        pieces.add(new EldritchSpireComponent(templateManager, bTemplate, bossName, false, current.func_185334_h(), rot, mirror, ward));
        add = EldritchSpireComponentPlacer.transformOffset(bTemplate.func_186259_a().func_177958_n() / 2 + 1, bTemplate.func_186259_a().func_177952_p() / 2 + 1, rot, mirror);
        current.func_181079_c(current.func_177958_n() + add.func_177958_n(), current.func_177956_o() - 1, current.func_177952_p() + add.func_177952_p());
        EldritchSpireComponentPlacer.generateGenericPillar(world, generator, templateManager, current, rot, mirror, random, pieces, ward);
    }

    public static void findTemplateVariants(TemplateManager manager) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (String s : TEMPLATE_PATHS) {
            int i = 0;
            while (manager.func_189942_b(server, new ResourceLocation("thaumicaugmentation", s + i)) != null) {
                ++i;
            }
            builder.put((Object)s, (Object)i);
        }
        templateCounts = builder.build();
    }
}

