/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.tile;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.entities.EntityFluxRift;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.block.property.IDirectionalBlock;
import thecodex6824.thaumicaugmentation.api.block.property.IEnabledBlock;
import thecodex6824.thaumicaugmentation.api.util.RiftHelper;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class TileRiftFeeder
extends TileEntity
implements ITickable,
IEssentiaTransport {
    protected static final int MAX_ESSENTIA = 200;
    protected int storedEssentia;
    protected int ticks = ThreadLocalRandom.current().nextInt(20);

    protected double getDistForFace(EnumFacing face, Entity entity) {
        return this.getDistForFace(face, entity.func_174791_d());
    }

    protected double getDistForFace(EnumFacing face, Vec3d vec) {
        if (face.func_176740_k() == EnumFacing.Axis.X) {
            return Math.abs((double)this.field_174879_c.func_177958_n() - vec.field_72450_a);
        }
        if (face.func_176740_k() == EnumFacing.Axis.Y) {
            return Math.abs((double)this.field_174879_c.func_177956_o() - vec.field_72448_b);
        }
        return Math.abs((double)this.field_174879_c.func_177952_p() - vec.field_72449_c);
    }

    @Nullable
    protected EntityFluxRift findClosestRift(EnumFacing face) {
        BlockPos pos1 = this.field_174879_c.func_177972_a(face).func_177963_a(1.0 - (double)face.func_82601_c(), 1.0 - (double)face.func_96559_d(), 1.0 - (double)face.func_82599_e());
        BlockPos pos2 = this.field_174879_c.func_177967_a(face, 12).func_177963_a(1.0 + (double)face.func_82601_c(), 1.0 + (double)face.func_96559_d(), 1.0 + (double)face.func_82599_e());
        List rifts = this.field_145850_b.func_72872_a(EntityFluxRift.class, new AxisAlignedBB((double)(pos1.func_177958_n() - 1), (double)(pos1.func_177956_o() - 1), (double)(pos1.func_177952_p() - 1), (double)(pos2.func_177958_n() + 2), (double)(pos2.func_177956_o() + 2), (double)(pos2.func_177952_p() + 2)));
        if (!rifts.isEmpty()) {
            rifts.sort((rift1, rift2) -> Double.compare(this.getDistForFace(face, (Entity)rift1), this.getDistForFace(face, (Entity)rift2)));
            RayTraceResult trace = this.field_145850_b.func_72933_a(new Vec3d((Vec3i)this.field_174879_c.func_177972_a(face)), new Vec3d((Vec3i)this.field_174879_c.func_177967_a(face, 10)));
            EntityFluxRift chosenOne = (EntityFluxRift)rifts.get(0);
            if (trace == null || trace.field_72307_f == null || this.getDistForFace(face, (Entity)chosenOne) < this.getDistForFace(face, trace.field_72307_f)) {
                return chosenOne;
            }
        }
        return null;
    }

    public void func_73660_a() {
        IBlockState state;
        EntityFluxRift rift;
        if (!this.field_145850_b.field_72995_K) {
            int required;
            EntityFluxRift rift2;
            IBlockState state2 = this.field_145850_b.func_180495_p(this.field_174879_c);
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                IEssentiaTransport t;
                TileEntity tile;
                if (facing == state2.func_177229_b((IProperty)IDirectionalBlock.DIRECTION) || (tile = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)facing)) == null || !(t = (IEssentiaTransport)tile).canOutputTo(facing.func_176734_d()) || t.getEssentiaType(facing) != Aspect.FLUX || t.getEssentiaAmount(facing.func_176734_d()) <= 0 || t.getSuctionAmount(facing.func_176734_d()) >= this.getSuctionAmount(facing) || this.getSuctionAmount(facing) < t.getMinimumSuction()) continue;
                this.addEssentiaDirect(t.takeEssentia(Aspect.FLUX, 1, facing.func_176734_d()));
            }
            if (++this.ticks % 5 == 0 && this.storedEssentia > 0 && ((Boolean)state2.func_177229_b((IProperty)IEnabledBlock.ENABLED)).booleanValue() && (rift2 = this.findClosestRift((EnumFacing)state2.func_177229_b((IProperty)IDirectionalBlock.DIRECTION))) != null && rift2.getRiftSize() < 200 && !rift2.getCollapse() && this.storedEssentia >= (required = (int)Math.sqrt(rift2.getRiftSize()))) {
                this.storedEssentia -= required;
                rift2.setRiftSize(rift2.getRiftSize() + 1);
                Vec3d particlePos = RiftHelper.getRiftCenter(rift2).func_72441_c(rift2.field_70165_t, rift2.field_70163_u, rift2.field_70161_v);
                TANetwork.INSTANCE.sendToAllAround((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.ESSENTIA_TRAIL, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), particlePos.field_72450_a, particlePos.field_72448_b, particlePos.field_72449_c, Aspect.FLUX.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 48.0));
                this.field_145850_b.func_184138_a(this.field_174879_c, state2, state2, 2);
                this.func_70296_d();
            }
        } else if (++this.ticks % 20 == 0 && (rift = this.findClosestRift((EnumFacing)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((IProperty)IDirectionalBlock.DIRECTION))) != null && state.func_177227_a().contains(IDirectionalBlock.DIRECTION)) {
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)IDirectionalBlock.DIRECTION);
            Vec3d ourPos = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5 + (double)face.func_82601_c() * 0.5, (double)this.field_174879_c.func_177956_o() + 0.5 + (double)face.func_96559_d() * 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)face.func_82599_e() * 0.5);
            Vec3d sub = rift.func_174791_d().func_178788_d(ourPos);
            Vec3d dir = sub.func_72432_b();
            double speed = sub.func_72433_c() / 40.0;
            ThaumicAugmentation.proxy.getRenderHelper().renderParticleTrail(this.field_145850_b, ourPos.field_72450_a, ourPos.field_72448_b, ourPos.field_72449_c, dir.field_72450_a * speed, dir.field_72448_b * speed, dir.field_72449_c * speed, 0.35f, 0.0f, 0.35f);
        }
    }

    protected void addEssentiaDirect(int amount) {
        if (amount > 0) {
            this.storedEssentia += amount;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            this.func_70296_d();
        }
    }

    public int addEssentia(Aspect aspect, int amount, EnumFacing face) {
        int taken = this.canInputFrom(face) ? Math.min(amount, 200 - this.storedEssentia) : 0;
        this.addEssentiaDirect(taken);
        return taken;
    }

    public boolean canInputFrom(EnumFacing face) {
        return this.isConnectable(face);
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.isConnectable(face) ? this.storedEssentia : 0;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return this.isConnectable(face) ? Aspect.FLUX : null;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        if (this.isConnectable(face)) {
            return this.storedEssentia < 200 ? 128 : 0;
        }
        return 0;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return Aspect.FLUX;
    }

    public boolean isConnectable(EnumFacing face) {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)IDirectionalBlock.DIRECTION) != face;
    }

    public void setSuction(Aspect aspect, int suction) {
    }

    public int takeEssentia(Aspect aspect, int amount, EnumFacing face) {
        return 0;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("essentia", this.storedEssentia);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.storedEssentia = pkt.func_148857_g().func_74762_e("essentia");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("essentia", this.storedEssentia);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storedEssentia = compound.func_74762_e("essentia");
    }
}

