/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.foci;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.NodeSetting;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thaumcraft.common.lib.network.fx.PacketFXFocusPartImpact;
import thaumcraft.common.tiles.TileThaumcraft;
import thecodex6824.thaumicaugmentation.api.TASounds;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationBotania;
import thecodex6824.thaumicaugmentation.common.integration.IntegrationHandler;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class FocusEffectWater
extends FocusEffect {
    private static final Predicate<TileEntity> IS_APOTHECARY = tile -> FocusEffectWater.invokePredicate(t -> ((IntegrationBotania)IntegrationHandler.getIntegration("botania")).isPetalApothecary((TileEntity)t), tile);
    private static final Consumer<TileEntity> FILL_APOTHECARY = tile -> FocusEffectWater.invoke(t -> ((IntegrationBotania)IntegrationHandler.getIntegration("botania")).fillPetalApothecary((TileEntity)t), tile);

    private static void invoke(Consumer<TileEntity> c, TileEntity t) {
        c.accept(t);
    }

    private static boolean invokePredicate(Predicate<TileEntity> c, TileEntity t) {
        return c.test(t);
    }

    public Aspect getAspect() {
        return Aspect.WATER;
    }

    public String getKey() {
        return "focus.thaumicaugmentation.water";
    }

    public NodeSetting[] createSettings() {
        return new NodeSetting[]{new NodeSetting("power", "focus.common.power", (NodeSetting.INodeSettingType)new NodeSetting.NodeSettingIntRange(0, 5))};
    }

    public int getComplexity() {
        return 3 + this.getSettingValue("power") * 2;
    }

    public float getDamageForDisplay(float finalPower) {
        return (float)(this.getSettingValue("power") + 1) * finalPower;
    }

    public String getResearch() {
        return "FOCUS_WATER";
    }

    public boolean execute(RayTraceResult result, @Nullable Trajectory trajectory, float power, int something) {
        World world = this.getPackage().world;
        Vec3d hit = result.field_72307_f;
        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketFXFocusPartImpact(hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, new String[]{this.getKey()}), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, 64.0));
        double rangeMod = 1.0;
        BlockPos.MutableBlockPos pos = null;
        Entity exclude = null;
        if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != null) {
            rangeMod = 0.5;
            exclude = result.field_72308_g;
            pos = new BlockPos.MutableBlockPos(result.field_72308_g.func_180425_c());
            if ((result.field_72308_g instanceof EntityCreature || result.field_72308_g instanceof EntityWaterMob || result.field_72308_g instanceof EntityPlayer) && ((EntityLivingBase)result.field_72308_g).func_70648_aU()) {
                EntityLivingBase base = (EntityLivingBase)result.field_72308_g;
                base.func_70050_g(Math.max(base.func_70086_ai(), 300));
            } else {
                float damageMultiplier;
                float f = damageMultiplier = world.field_73011_w.func_177500_n() ? 0.75f : 1.0f;
                if (result.field_72308_g instanceof EntityBlaze || result.field_72308_g instanceof EntityMagmaCube) {
                    damageMultiplier = 2.0f;
                } else if (result.field_72308_g instanceof EntitySlime || result.field_72308_g instanceof EntityWitch) {
                    damageMultiplier = 1.5f;
                }
                if (result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)(result.field_72308_g != null ? result.field_72308_g : this.getPackage().getCaster()), (Entity)this.getPackage().getCaster()), this.getDamageForDisplay(power) * damageMultiplier)) {
                    if (result.field_72308_g instanceof EntityWolf) {
                        ((EntityWolf)result.field_72308_g).field_70925_g = true;
                    }
                    if (damageMultiplier > 1.0f) {
                        world.func_184133_a(null, (BlockPos)pos, SoundEvents.field_187541_bC, result.field_72308_g.func_184176_by(), Math.min(damageMultiplier - 1.0f, 1.0f), 1.0f);
                        Vec3d eyes = result.field_72308_g.func_174824_e(1.0f);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SMOKE_LARGE, eyes.field_72450_a, eyes.field_72448_b, eyes.field_72449_c), result.field_72308_g);
                    }
                }
                if (result.field_72308_g.func_70027_ad()) {
                    result.field_72308_g.func_70066_B();
                    world.func_184133_a(null, (BlockPos)pos, TASounds.FOCUS_WATER_IMPACT, result.field_72308_g.func_184176_by(), 0.25f, 1.0f);
                }
            }
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            pos = new BlockPos.MutableBlockPos(result.func_178782_a().func_177972_a(result.field_178784_b));
        }
        if (pos != null) {
            int maxDist = (int)((double)(this.getSettingValue("power") + 1) * rangeMod);
            if (world.field_73011_w.func_177500_n()) {
                maxDist = MathHelper.func_76123_f((float)((float)maxDist / 2.0f));
            }
            if (maxDist > 0) {
                BlockPos start = pos.func_185334_h();
                List entities = world.func_175674_a(exclude, new AxisAlignedBB((double)(start.func_177958_n() - maxDist / 2), (double)(start.func_177956_o() - maxDist / 2), (double)(start.func_177952_p() - maxDist / 2), (double)start.func_177958_n() + Math.ceil((double)maxDist / 2.0), (double)start.func_177956_o() + Math.ceil((double)maxDist / 2.0), (double)start.func_177952_p() + Math.ceil((double)maxDist / 2.0)), entity -> entity != null && (entity.func_70027_ad() || entity instanceof EntityWolf));
                ArrayList<Vec3d> splashPositions = new ArrayList<Vec3d>();
                for (Entity e : entities) {
                    if (!(e.func_174818_b(start) <= (double)(maxDist * maxDist))) continue;
                    e.func_70066_B();
                    world.func_184133_a(null, (BlockPos)pos, TASounds.FOCUS_WATER_IMPACT, e.func_184176_by(), 0.25f, 1.0f);
                    splashPositions.add(e.func_174791_d());
                    if (!(e instanceof EntityWolf)) continue;
                    ((EntityWolf)e).field_70925_g = true;
                }
                for (int x = -maxDist; x < maxDist + 1; ++x) {
                    for (int z = -maxDist; z < maxDist + 1; ++z) {
                        pos.func_181079_c(x + start.func_177958_n(), 0, z + start.func_177952_p());
                        for (int y = -maxDist; y < maxDist + 1; ++y) {
                            pos.func_185336_p(y + start.func_177956_o());
                            if (x * x + y * y + z * z > maxDist * maxDist) continue;
                            IBlockState state = world.func_180495_p((BlockPos)pos);
                            if (state.func_185904_a() == Material.field_151581_o) {
                                world.func_175698_g((BlockPos)pos);
                                world.func_184133_a(null, (BlockPos)pos, TASounds.FOCUS_WATER_IMPACT, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                splashPositions.add(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
                                continue;
                            }
                            if (world.field_73011_w.func_177500_n()) continue;
                            if (state.func_185904_a() == Material.field_151587_i && state.func_177227_a().contains(BlockLiquid.field_176367_b) && x == 0 && y == 0 && z == 0) {
                                if ((Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                                    world.func_175656_a((BlockPos)pos, Blocks.field_150343_Z.func_176223_P());
                                } else {
                                    world.func_175656_a((BlockPos)pos, Blocks.field_150347_e.func_176223_P());
                                }
                                world.func_184133_a(null, (BlockPos)pos, TASounds.FOCUS_WATER_IMPACT, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                splashPositions.add(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
                                continue;
                            }
                            if (state.func_177227_a().contains(BlockFarmland.field_176531_a)) {
                                world.func_175656_a((BlockPos)pos, state.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)));
                                world.func_184133_a(null, (BlockPos)pos, TASounds.FOCUS_WATER_IMPACT, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                splashPositions.add(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
                                continue;
                            }
                            if (state.func_177227_a().contains(BlockCauldron.field_176591_a)) {
                                world.func_175656_a((BlockPos)pos, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf(Math.min((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) + 1, 3))));
                                world.func_184133_a(null, (BlockPos)pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 0.25f, 1.0f);
                                splashPositions.add(new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5));
                                continue;
                            }
                            TileEntity tile = world.func_175625_s((BlockPos)pos);
                            if (tile == null) continue;
                            if (IntegrationHandler.isIntegrationPresent("botania") && IS_APOTHECARY.test(tile)) {
                                FILL_APOTHECARY.accept(tile);
                                continue;
                            }
                            IFluidHandler fluid = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                            if (fluid == null) continue;
                            fluid.fill(new FluidStack(FluidRegistry.WATER, 334), true);
                            if (!(tile instanceof TileThaumcraft)) continue;
                            tile.func_70296_d();
                            ((TileThaumcraft)tile).syncTile(false);
                        }
                    }
                }
                List list = splashPositions;
                if (list.size() * 3 > PacketParticleEffect.maxPacketData) {
                    list = list.subList(0, PacketParticleEffect.maxPacketData / 3);
                }
                double[] coords = new double[list.size() * 3];
                for (int i = 0; i < list.size(); ++i) {
                    Vec3d vec = (Vec3d)list.get(i);
                    coords[i * 3] = vec.field_72450_a;
                    coords[i * 3 + 1] = vec.field_72448_b;
                    coords[i * 3 + 2] = vec.field_72449_c;
                }
                TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.SPLASH_BATCH, coords), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)start.func_177958_n(), (double)start.func_177956_o(), (double)start.func_177952_p(), 64.0));
            }
            return true;
        }
        return false;
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187547_bF, SoundCategory.PLAYERS, 0.2f, 1.2f);
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_187542_ac, SoundCategory.PLAYERS, 0.2f, 1.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric bubble = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        bubble.func_187114_a(25 + world.field_73012_v.nextInt(30));
        bubble.setScale(new float[]{world.field_73012_v.nextFloat() * 0.3f + 0.3f});
        bubble.setAlphaF(new float[]{1.0f, 0.0f});
        bubble.setParticle(64);
        bubble.setGravity(-0.001f);
        int color = this.getAspect().getColor();
        bubble.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        bubble.setRotationSpeed(world.field_73012_v.nextFloat(), 0.0f);
        bubble.setFinalFrames(new int[]{65, 66, 66});
        ParticleEngine.addEffect((World)world, (Particle)bubble);
    }
}

