/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item.foci;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.casters.FocusEffect;
import thaumcraft.api.casters.Trajectory;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.particles.FXGeneric;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.block.property.IUnwardableBlock;
import thecodex6824.thaumicaugmentation.api.ward.entity.CapabilityWardOwnerProvider;
import thecodex6824.thaumicaugmentation.api.ward.entity.IWardOwnerProvider;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;
import thecodex6824.thaumicaugmentation.common.network.PacketParticleEffect;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class FocusEffectWard
extends FocusEffect {
    public Aspect getAspect() {
        return Aspect.PROTECT;
    }

    public int getComplexity() {
        return 23;
    }

    public String getKey() {
        return "focus.thaumicaugmentation.ward";
    }

    public String getResearch() {
        return "FOCUS_WARD";
    }

    public boolean execute(RayTraceResult result, @Nullable Trajectory trajectory, float finalPower, int whatever) {
        if (!TAConfig.disableWardFocus.getValue().booleanValue()) {
            World world = this.getPackage().getCaster().func_130014_f_();
            if (!world.field_72995_K && result.field_72313_a == RayTraceResult.Type.BLOCK && this.getPackage().getCaster() instanceof EntityPlayer && world.func_175660_a((EntityPlayer)this.getPackage().getCaster(), result.func_178782_a()) && !world.func_175623_d(result.func_178782_a())) {
                IWardStorage wardStorage;
                BlockPos pos = result.func_178782_a();
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() instanceof IUnwardableBlock && ((IUnwardableBlock)state.func_177230_c()).shouldBeUnwardable(world, pos, state, (Entity)this.getPackage().getCaster())) {
                    return false;
                }
                Chunk chunk = this.getPackage().getCaster().func_130014_f_().func_175726_f(pos);
                if (TAConfig.tileWardMode.getValue() != TAConfig.TileWardMode.ALL) {
                    TileEntity tile = chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
                    if (TAConfig.tileWardMode.getValue() == TAConfig.TileWardMode.NOTICK && tile instanceof ITickable) {
                        return false;
                    }
                    if (TAConfig.tileWardMode.getValue() == TAConfig.TileWardMode.NONE && tile != null) {
                        return false;
                    }
                }
                if ((wardStorage = (IWardStorage)chunk.getCapability(CapabilityWardStorage.WARD_STORAGE, null)) instanceof IWardStorageServer) {
                    UUID maybe;
                    IWardStorageServer storage = (IWardStorageServer)wardStorage;
                    UUID owner = this.getPackage().getCasterUUID();
                    IWardOwnerProvider provider = (IWardOwnerProvider)this.getPackage().getCaster().getCapability(CapabilityWardOwnerProvider.WARD_OWNER, null);
                    if (provider != null && (maybe = provider.getWardOwnerUUID()) != null) {
                        owner = maybe;
                    }
                    if (!storage.hasWard(pos)) {
                        storage.setWard(pos, owner, world);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.POOF, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Aspect.PROTECT.getColor(), result.field_178784_b.func_176745_a()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0));
                    } else if (storage.getWard(pos).equals(owner)) {
                        storage.clearWard(pos, world);
                        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketParticleEffect(PacketParticleEffect.ParticleEffect.POOF, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), Aspect.PROTECT.getColor(), result.field_178784_b.func_176745_a()), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 64.0));
                    }
                }
            }
        }
        return false;
    }

    public void onCast(Entity caster) {
        caster.field_70170_p.func_184133_a(null, caster.func_180425_c().func_177984_a(), SoundEvents.field_190021_aL, SoundCategory.PLAYERS, 0.2f, 1.2f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderParticleFX(World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
        FXGeneric fb = new FXGeneric(world, posX, posY, posZ, velX, velY, velZ);
        fb.func_187114_a(40 + world.field_73012_v.nextInt(40));
        fb.setParticles(16, 1, 1);
        fb.setSlowDown(0.5);
        fb.setAlphaF(new float[]{1.0f, 0.0f});
        fb.setScale(new float[]{(float)((double)0.7f + world.field_73012_v.nextGaussian() * (double)0.3f)});
        int color = this.getAspect().getColor();
        fb.func_70538_b((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        fb.setRotationSpeed(world.field_73012_v.nextFloat(), 0.0f);
        ParticleEngine.addEffectWithDelay((World)world, (Particle)fb, (int)0);
    }
}

