/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.casters.CasterTriggerRegistry;
import thaumcraft.api.casters.FocusEngine;
import thaumcraft.api.casters.FocusPackage;
import thaumcraft.api.casters.ICaster;
import thaumcraft.api.casters.IFocusBlockPicker;
import thaumcraft.api.casters.IFocusElement;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.api.items.IArchitect;
import thaumcraft.api.items.IWarpingGear;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.items.casters.ItemFocus;
import thaumcraft.common.items.casters.foci.FocusEffectExchange;
import thaumcraft.common.lib.network.misc.PacketAuraToClient;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraHandler;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAConfig;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.TAMaterials;
import thecodex6824.thaumicaugmentation.api.augment.AugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.event.CastEvent;
import thecodex6824.thaumicaugmentation.api.item.IDyeableItem;
import thecodex6824.thaumicaugmentation.api.item.ITieredCaster;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProvider;
import thecodex6824.thaumicaugmentation.common.item.foci.FocusEffectExchangeCompat;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class ItemTieredCasterGauntlet
extends ItemTABase
implements IArchitect,
IDyeableItem,
ITieredCaster,
IWarpingGear {
    protected static final DecimalFormat VIS_FORMATTER = new DecimalFormat("#######.#");
    protected static final Method CASTER_IS_ON_COOLDOWN;
    protected static final float EPSILON = 1.0E-5f;

    public ItemTieredCasterGauntlet() {
        super("thaumium", "void");
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("thaumicaugmentation", "focus"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
                return ItemTieredCasterGauntlet.this.isStoringFocus(stack) ? 1.0f : 0.0f;
            }
        });
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        SimpleCapabilityProvider<IAugmentableItem> provider = new SimpleCapabilityProvider<IAugmentableItem>(new AugmentableItem(3), CapabilityAugmentableItem.AUGMENTABLE_ITEM);
        if (nbt != null && nbt.func_150297_b("Parent", 10)) {
            provider.deserializeNBT(nbt.func_74775_l("Parent"));
        }
        return provider;
    }

    public boolean consumeVis(ItemStack stack, EntityPlayer user, float amount, boolean crafting, boolean simulate) {
        if (stack.func_77960_j() == 0 || TAConfig.voidseerArea.getValue() <= 1) {
            if (amount <= AuraHelper.getVis((World)user.func_130014_f_(), (BlockPos)user.func_180425_c())) {
                return (amount -= AuraHelper.drainVis((World)user.func_130014_f_(), (BlockPos)user.func_180425_c(), (float)amount, (boolean)simulate)) <= 1.0E-5f;
            }
            return false;
        }
        int voidseerArea = TAConfig.voidseerArea.getValue();
        float totalVis = 0.0f;
        TreeMap<Float, BlockPos> visAmounts = new TreeMap<Float, BlockPos>((f1, f2) -> Float.compare(f1.floatValue(), f2.floatValue()));
        for (int x = -voidseerArea / 2; x < (int)Math.ceil((double)voidseerArea / 2.0); ++x) {
            for (int z = -voidseerArea / 2; z < (int)Math.ceil((double)voidseerArea / 2.0); ++z) {
                BlockPos loc = user.func_180425_c().func_177982_a(x * 16, 0, z * 16);
                if (!user.func_130014_f_().func_175668_a(loc, true)) continue;
                float vis = AuraHelper.getVis((World)user.func_130014_f_(), (BlockPos)loc);
                totalVis += vis;
                visAmounts.put(Float.valueOf(vis), loc);
            }
        }
        if (totalVis >= amount) {
            float step = amount / (float)visAmounts.size();
            float drawn = 0.0f;
            int index = 0;
            for (Map.Entry entry : visAmounts.entrySet()) {
                float actuallyDrawn = AuraHelper.drainVis((World)user.func_130014_f_(), (BlockPos)((BlockPos)entry.getValue()), (float)step, (boolean)false);
                drawn += actuallyDrawn;
                if (actuallyDrawn < step) {
                    step = (amount - drawn) / (float)(visAmounts.size() - (index + 1));
                }
                ++index;
            }
            return Math.abs(drawn - amount) <= 1.0E-5f;
        }
        return false;
    }

    public float getConsumptionModifier(ItemStack stack, EntityPlayer user, boolean crafting) {
        float baseModifier = 1.0f;
        if (user != null) {
            baseModifier -= CasterManager.getTotalVisDiscount((EntityPlayer)user);
        }
        if (stack.func_77973_b() == this) {
            baseModifier -= this.getCasterVisDiscount(stack);
        }
        return Math.max(baseModifier, 0.1f);
    }

    public Item getFocus(ItemStack stack) {
        ItemStack focusStack = this.getFocusStack(stack);
        if (focusStack != null && !focusStack.func_190926_b()) {
            return focusStack.func_77973_b();
        }
        return null;
    }

    public ItemStack getFocusStack(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("storedFocus")) {
            return new ItemStack(stack.func_77978_p().func_74775_l("storedFocus"));
        }
        return null;
    }

    protected boolean isStoringFocus(ItemStack stack) {
        return stack.func_77973_b() instanceof ICaster && ((ICaster)stack.func_77973_b()).getFocus(stack) instanceof ItemFocus;
    }

    public void setFocus(ItemStack stack, ItemStack focus) {
        if (focus == null || focus.func_190926_b()) {
            stack.func_77978_p().func_82580_o("storedFocus");
        } else {
            stack.func_77983_a("storedFocus", (NBTBase)focus.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public float getCasterVisDiscount(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            switch (stack.func_77960_j()) {
                case 0: {
                    return (float)TAConfig.gauntletVisDiscounts.getValue()[0];
                }
                case 1: {
                    return (float)TAConfig.gauntletVisDiscounts.getValue()[1];
                }
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @Override
    public float getCasterCooldownModifier(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            switch (stack.func_77960_j()) {
                case 0: {
                    return (float)TAConfig.gauntletCooldownModifiers.getValue()[0];
                }
                case 1: {
                    return (float)TAConfig.gauntletCooldownModifiers.getValue()[1];
                }
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public ArrayList<BlockPos> getArchitectBlocks(ItemStack stack, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        FocusPackage fPackage;
        if (this.isStoringFocus(stack) && (fPackage = ItemFocus.getPackage((ItemStack)this.getFocusStack(stack))) != null) {
            for (IFocusElement element : fPackage.nodes) {
                if (!(element instanceof IArchitect)) continue;
                return ((IArchitect)element).getArchitectBlocks(stack, world, pos, side, player);
            }
        }
        return null;
    }

    public RayTraceResult getArchitectMOP(ItemStack stack, World world, EntityLivingBase user) {
        FocusPackage fPackage;
        if (this.isStoringFocus(stack) && (fPackage = ItemFocus.getPackage((ItemStack)this.getFocusStack(stack))) != null && FocusEngine.doesPackageContainElement((FocusPackage)fPackage, (String)"thaumcraft.PLAN")) {
            return ((IArchitect)FocusEngine.getElement((String)"thaumcraft.PLAN")).getArchitectMOP(stack, world, user);
        }
        return null;
    }

    public ItemStack getPickedBlock(ItemStack stack) {
        ItemStack focus;
        FocusPackage fPackage;
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = null;
        if (this.isStoringFocus(stack) && (fPackage = ItemFocus.getPackage((ItemStack)(focus = this.getFocusStack(stack)))) != null && focus.func_77942_o() && focus.func_77978_p().func_150297_b("pickedBlock", 10)) {
            for (IFocusElement element : fPackage.nodes) {
                if (!(element instanceof IFocusBlockPicker)) continue;
                ret = ItemStack.field_190927_a;
                try {
                    ret = new ItemStack(focus.func_77978_p().func_74775_l("pickedBlock"));
                }
                catch (Exception exception) {}
            }
        }
        return ret;
    }

    public boolean showAxis(ItemStack stack, World world, EntityPlayer player, EnumFacing side, IArchitect.EnumAxis axis) {
        FocusPackage fPackage;
        if (this.isStoringFocus(stack) && (fPackage = ItemFocus.getPackage((ItemStack)this.getFocusStack(stack))) != null) {
            for (IFocusElement element : fPackage.nodes) {
                if (!(element instanceof IArchitect)) continue;
                return ((IArchitect)element).showAxis(stack, world, player, side, axis);
            }
        }
        return false;
    }

    public int getWarp(ItemStack stack, EntityPlayer player) {
        return stack.func_77973_b() == this && stack.func_77960_j() == 1 ? 2 : 0;
    }

    @Override
    public int getDefaultDyedColorForMeta(int meta) {
        return meta < TAConfig.defaultGauntletColors.getValue().length ? TAConfig.defaultGauntletColors.getValue()[meta] : 0;
    }

    @Override
    public int getDyedColor(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_150297_b("color", 3)) {
            return stack.func_77978_p().func_74762_e("color");
        }
        stack.func_77978_p().func_74768_a("color", this.getDefaultDyedColorForMeta(stack.func_77960_j()));
        return stack.func_77978_p().func_74762_e("color");
    }

    @Override
    public void setDyedColor(ItemStack stack, int color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color);
    }

    public boolean useBlockHighlight(ItemStack stack) {
        return false;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() instanceof ICaster && newStack.func_77973_b() instanceof ICaster && this.isStoringFocus(oldStack) && this.isStoringFocus(newStack)) {
            ItemStack oldFocus = ((ICaster)oldStack.func_77973_b()).getFocusStack(oldStack);
            ItemStack newFocus = ((ICaster)newStack.func_77973_b()).getFocusStack(newStack);
            if (oldFocus == null && newFocus != null || oldFocus != null && newFocus == null) {
                return true;
            }
            if (oldFocus != null && newFocus != null) {
                return ((ItemFocus)oldFocus.func_77973_b()).getSortingHelper(oldFocus).hashCode() != ((ItemFocus)newFocus.func_77973_b()).getSortingHelper(newFocus).hashCode();
            }
            return false;
        }
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77960_j() != newStack.func_77960_j();
    }

    public IRarity getForgeRarity(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return TAMaterials.RARITY_ARCANE;
            }
            case 1: {
                return TAMaterials.RARITY_ELDRITCH;
            }
        }
        return TAMaterials.RARITY_ARCANE;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && entity.field_70173_aa % 10 == 0 && entity instanceof EntityPlayerMP) {
            for (ItemStack held : entity.func_184214_aD()) {
                AuraChunk chunk;
                if (held == null || held.func_190926_b() || !(held.func_77973_b() instanceof ICaster) || (chunk = AuraHandler.getAuraChunk((int)world.field_73011_w.getDimension(), (int)entity.field_70176_ah, (int)entity.field_70164_aj)) == null) continue;
                TANetwork.INSTANCE.sendTo((IMessage)new PacketAuraToClient(chunk), (EntityPlayerMP)entity);
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack focus;
        FocusPackage fPackage;
        ItemStack stack = player.func_184586_b(hand);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IInteractWithCaster && ((IInteractWithCaster)state.func_177230_c()).onCasterRightClick(world, stack, player, pos, side, hand)) {
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() == Blocks.field_150383_bp && (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) > 0 && this.getDyedColor(stack) != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            this.setDyedColor(stack, this.getDefaultDyedColorForMeta(stack.func_77960_j()));
            world.func_175656_a(pos, state.func_177226_a((IProperty)BlockCauldron.field_176591_a, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) - 1)));
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f);
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInteractWithCaster && ((IInteractWithCaster)tile).onCasterRightClick(world, stack, player, pos, side, hand)) {
            return EnumActionResult.SUCCESS;
        }
        if (CasterTriggerRegistry.hasTrigger((IBlockState)state)) {
            return CasterTriggerRegistry.performTrigger((World)world, (ItemStack)stack, (EntityPlayer)player, (BlockPos)pos, (EnumFacing)side, (IBlockState)state) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        if (this.isStoringFocus(stack) && (fPackage = ItemFocus.getPackage((ItemStack)(focus = this.getFocusStack(stack)))) != null) {
            for (IFocusElement element : fPackage.nodes) {
                if (!(element instanceof IFocusBlockPicker) || !player.func_70093_af() || world.func_175625_s(pos) != null) continue;
                if (!world.field_72995_K) {
                    ItemStack toStore = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
                    try {
                        ItemStack toCopy;
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)world, pos) && (toCopy = BlockUtils.getSilkTouchDrop((IBlockState)state)) != null && !toCopy.func_190926_b()) {
                            toStore = toCopy.func_77946_l();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    focus.func_77978_p().func_74782_a("pickedBlock", (NBTBase)toStore.func_77955_b(new NBTTagCompound()));
                    return EnumActionResult.SUCCESS;
                }
                player.func_184609_a(hand);
                return EnumActionResult.PASS;
            }
        }
        return EnumActionResult.PASS;
    }

    protected boolean isCasterOnCooldown(EntityLivingBase entity) {
        try {
            return (Boolean)CASTER_IS_ON_COOLDOWN.invoke(null, entity);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            FMLCommonHandler.instance().raiseException((Throwable)ex, "Failed to invoke Thaumcraft's CasterManager#isOnCooldown", true);
            return true;
        }
    }

    protected void fixFoci(FocusPackage p) {
        for (int i = 0; i < p.nodes.size(); ++i) {
            if (!((IFocusElement)p.nodes.get(i)).getClass().equals(FocusEffectExchange.class)) continue;
            p.nodes.set(i, new FocusEffectExchangeCompat((FocusEffectExchange)p.nodes.get(i)));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack caster = player.func_184586_b(hand);
        if (this.isStoringFocus(caster) && !this.isCasterOnCooldown((EntityLivingBase)player)) {
            ItemStack focus = this.getFocusStack(caster);
            FocusPackage core = ItemFocus.getPackage((ItemStack)focus).copy((EntityLivingBase)player);
            if (player.func_70093_af()) {
                for (IFocusElement element : core.nodes) {
                    if (!(element instanceof IFocusBlockPicker) || !player.func_70093_af()) continue;
                    return new ActionResult(EnumActionResult.PASS, (Object)caster);
                }
            }
            float visCost = ((ItemFocus)focus.func_77973_b()).getVisCost(focus) * this.getConsumptionModifier(caster, player, false);
            CastEvent.Pre preEvent = new CastEvent.Pre((EntityLivingBase)player, caster, new FocusWrapper(core, (int)((float)((ItemFocus)focus.func_77973_b()).getActivationTime(focus) * this.getCasterCooldownModifier(caster)), visCost));
            MinecraftForge.EVENT_BUS.post((Event)preEvent);
            if (world.field_72995_K) {
                CasterManager.setCooldown((EntityLivingBase)player, (int)preEvent.getFocus().getCooldown());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)caster);
            }
            if (!preEvent.isCanceled() && this.consumeVis(caster, player, preEvent.getFocus().getVisCost(), false, false)) {
                this.fixFoci(core);
                FocusEngine.castFocusPackage((EntityLivingBase)player, (FocusPackage)core, (boolean)true);
                CasterManager.setCooldown((EntityLivingBase)player, (int)preEvent.getFocus().getCooldown());
                MinecraftForge.EVENT_BUS.post((Event)new CastEvent.Post((EntityLivingBase)player, caster, preEvent.getFocus()));
                player.func_184609_a(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)caster);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)caster);
        }
        return super.func_77659_a(world, player, hand);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p().func_74737_b());
        }
        tag.func_74782_a("cap", (NBTBase)((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((AugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            if (this.subItemNames.length > 0) {
                for (int i = 0; i < this.subItemNames.length; ++i) {
                    ItemStack toAdd = new ItemStack((Item)this, 1, i);
                    toAdd.func_77982_d(new NBTTagCompound());
                    this.setDyedColor(toAdd, this.getDefaultDyedColorForMeta(i));
                    if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                        toAdd.func_77978_p().func_74782_a("cap", (NBTBase)((AugmentableItem)toAdd.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)).serializeNBT());
                    }
                    items.add((Object)toAdd);
                }
            } else {
                super.func_150895_a(tab, items);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        int color = this.getDyedColor(stack);
        if (color != this.getDefaultDyedColorForMeta(stack.func_77960_j())) {
            if (flag.func_194127_a()) {
                tooltip.add(new TextComponentTranslation("item.color", new Object[]{TextFormatting.GRAY + String.format("#%06X", color)}).func_150254_d());
            } else {
                tooltip.add(TextFormatting.ITALIC + new TextComponentTranslation("item.dyed", new Object[0]).func_150254_d());
            }
        }
        if (this.isStoringFocus(stack)) {
            ItemStack focus = this.getFocusStack(stack);
            float visCost = ((ItemFocus)focus.func_77973_b()).getVisCost(focus);
            if (visCost > 0.0f) {
                tooltip.add(TextFormatting.ITALIC + "" + TextFormatting.AQUA + new TextComponentTranslation("tc.vis.cost", new Object[0]).func_150254_d() + " " + TextFormatting.RESET + VIS_FORMATTER.format(visCost) + " " + new TextComponentTranslation("item.Focus.cost1", new Object[0]).func_150254_d());
            }
            tooltip.add(TextFormatting.BOLD + "" + TextFormatting.ITALIC + "" + TextFormatting.GREEN + focus.func_82833_r());
            ((ItemFocus)focus.func_77973_b()).addFocusInformation(focus, world, tooltip, flag);
        }
    }

    static {
        Method cooldown = null;
        try {
            cooldown = CasterManager.class.getDeclaredMethod("isOnCooldown", EntityLivingBase.class);
            cooldown.setAccessible(true);
        }
        catch (Exception ex) {
            ThaumicAugmentation.getLogger().error("Failed to access Thaumcraft's CasterManager#isOnCooldown");
            throw new RuntimeException(ex);
        }
        CASTER_IS_ON_COOLDOWN = cooldown;
    }
}

