/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thecodex6824.thaumicaugmentation.ThaumicAugmentation;
import thecodex6824.thaumicaugmentation.api.TAItems;
import thecodex6824.thaumicaugmentation.api.item.BiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.CapabilityBiomeSelector;
import thecodex6824.thaumicaugmentation.api.item.IBiomeSelector;
import thecodex6824.thaumicaugmentation.common.capability.provider.SimpleCapabilityProvider;
import thecodex6824.thaumicaugmentation.common.item.prefab.ItemTABase;

public class ItemBiomeSelector
extends ItemTABase {
    public ItemBiomeSelector() {
        super(new String[0]);
        this.func_77627_a(true);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        NBTTagCompound data;
        SimpleCapabilityProvider<IBiomeSelector> provider = new SimpleCapabilityProvider<IBiomeSelector>(new BiomeSelector(), CapabilityBiomeSelector.BIOME_SELECTOR);
        if (nbt != null && !(data = nbt.func_74775_l("Parent")).func_82582_d()) {
            provider.deserializeNBT(nbt);
        }
        return provider;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        IBiomeSelector biome;
        if (player != null && hand != null && (biome = (IBiomeSelector)(stack = player.func_184586_b(hand)).getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)) != null) {
            if (biome.getBiomeID().equals((Object)IBiomeSelector.EMPTY)) {
                biome.setBiomeID(world.func_180494_b(player.func_180425_c()).getRegistryName());
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (player.func_70093_af() && !biome.getBiomeID().equals((Object)IBiomeSelector.EMPTY)) {
                biome.setBiomeID(IBiomeSelector.EMPTY);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = new NBTTagCompound();
        if (stack.func_77942_o()) {
            tag.func_74782_a("item", (NBTBase)stack.func_77978_p().func_74737_b());
        }
        tag.func_74782_a("cap", (NBTBase)((BiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).serializeNBT());
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            if (nbt.func_150297_b("cap", 10)) {
                ((BiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).deserializeNBT(nbt.func_74775_l("cap"));
            }
            if (nbt.func_150297_b("item", 10)) {
                stack.func_77982_d(nbt.func_74775_l("item"));
            } else if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                nbt.func_82580_o("cap");
                if (!nbt.func_82582_d()) {
                    stack.func_77982_d(nbt);
                }
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer()) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)nbt.func_74775_l("cap"));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        IBiomeSelector selected = (IBiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null);
        if (selected != null) {
            String biomeName = "";
            ResourceLocation id = selected.getBiomeID();
            Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)id);
            biomeName = id.equals((Object)IBiomeSelector.EMPTY) ? new TextComponentTranslation("thaumicaugmentation.text.biome_empty", new Object[0]).func_150254_d() : (id.equals((Object)IBiomeSelector.RESET) ? new TextComponentTranslation("thaumicaugmentation.text.biome_reset", new Object[0]).func_150254_d() : (biome != null ? biome.func_185359_l() : id.func_110623_a()));
            tooltip.add(new TextComponentTranslation("thaumicaugmentation.text.selected_biome", new Object[]{biomeName}).func_150254_d());
        }
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TAItems.BIOME_SELECTOR_CREATIVE_TAB || tab == CreativeTabs.field_78027_g) {
            boolean capWorkaround = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && !ThaumicAugmentation.proxy.isSingleplayer();
            ItemStack stack = new ItemStack((Item)this);
            ((IBiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).setBiomeID(IBiomeSelector.EMPTY);
            if (capWorkaround) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)((BiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).serializeNBT());
            }
            items.add((Object)stack);
            stack = new ItemStack((Item)this);
            ((IBiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).setBiomeID(IBiomeSelector.RESET);
            if (capWorkaround) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74782_a("cap", (NBTBase)((BiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).serializeNBT());
            }
            items.add((Object)stack);
            for (Biome b : Biome.field_185377_q) {
                stack = new ItemStack((Item)this);
                ((IBiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).setBiomeID(b.getRegistryName());
                if (capWorkaround) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74782_a("cap", (NBTBase)((BiomeSelector)stack.getCapability(CapabilityBiomeSelector.BIOME_SELECTOR, null)).serializeNBT());
                }
                items.add((Object)stack);
            }
        }
    }
}

