/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.block;

import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thecodex6824.thaumicaugmentation.common.block.prefab.BlockTABase;
import thecodex6824.thaumicaugmentation.common.block.trait.IItemBlockProvider;
import thecodex6824.thaumicaugmentation.common.item.block.ItemBlockNoImpetusNodeNBT;
import thecodex6824.thaumicaugmentation.common.tile.TileVoidRechargePedestal;
import thecodex6824.thaumicaugmentation.common.util.ItemHelper;

public class BlockVoidRechargePedestal
extends BlockTABase
implements IItemBlockProvider {
    public BlockVoidRechargePedestal() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public ItemBlock createItemBlock() {
        return new ItemBlockNoImpetusNodeNBT(this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            IItemHandler inventory;
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && (inventory = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) != null) {
                boolean didSomething = false;
                ItemStack old = inventory.extractItem(0, 1, false);
                if (hand != null && player != null && inventory.isItemValid(0, player.func_184586_b(hand))) {
                    ItemStack copy = player.func_184586_b(hand).func_77946_l();
                    copy.func_190920_e(1);
                    inventory.insertItem(0, copy, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    didSomething = true;
                }
                if (!old.func_190926_b()) {
                    if (hand != null && player.func_184586_b(hand).func_190926_b()) {
                        player.func_184611_a(hand, old);
                    } else if (!player.field_71071_by.func_70441_a(old)) {
                        world.func_72838_d(ItemHelper.makeItemEntity(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, old));
                    }
                    didSomething = true;
                }
                return didSomething;
            }
        } else if (world.field_72995_K) {
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileVoidRechargePedestal();
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IItemHandler inv;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && !world.field_72995_K && (inv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5 + world.field_73012_v.nextGaussian() / 2.0, (double)pos.func_177956_o() + 0.5 + Math.abs(world.field_73012_v.nextGaussian() / 2.0), (double)pos.func_177952_p() + 0.5 + world.field_73012_v.nextGaussian() / 2.0, stack));
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

