/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.client.event;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import thaumcraft.api.casters.ICaster;
import thaumcraft.common.config.ModConfig;
import thecodex6824.thaumicaugmentation.api.augment.CapabilityAugmentableItem;
import thecodex6824.thaumicaugmentation.api.augment.IAugmentableItem;
import thecodex6824.thaumicaugmentation.api.impetus.CapabilityImpetusStorage;
import thecodex6824.thaumicaugmentation.api.impetus.IImpetusStorage;
import thecodex6824.thaumicaugmentation.client.renderer.texture.TATextures;
import thecodex6824.thaumicaugmentation.client.shader.TAShaderManager;
import thecodex6824.thaumicaugmentation.client.shader.TAShaders;
import thecodex6824.thaumicaugmentation.common.util.MorphicArmorHelper;

@Mod.EventBusSubscriber(modid="thaumicaugmentation", value={Side.CLIENT})
public class HUDEventHandler {
    protected static void renderHeldImpetusLevel(ItemStack stack, IImpetusStorage storage) {
        double yMin;
        boolean bottom = ModConfig.CONFIG_GRAPHICS.dialBottom;
        boolean caster = stack.func_77973_b() instanceof ICaster;
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        double d = caster ? (bottom ? (double)res.func_78328_b() - 37.5 : 32.5) : (yMin = bottom ? (double)res.func_78328_b() - 10.5 : 5.5);
        double yMax = caster ? (bottom ? (double)res.func_78328_b() - 32.5 : 37.5) : (bottom ? (double)res.func_78328_b() - 5.5 : 10.5);
        float height = 30.0f * (float)(Math.ceil((double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored() * 10.0) / 10.0);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder buffer = t.func_178180_c();
        if (TAShaderManager.shouldUseShaders()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.RIFT);
            TAShaderManager.enableShader(TAShaders.FLUX_RIFT_HUD, TAShaders.SHADER_CALLBACK_CONSTANT_SPHERE_ZOOMED_20);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(8.0, yMax, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            buffer.func_181662_b(8.0 + (double)height, yMax, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            buffer.func_181662_b(8.0 + (double)height, yMin, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            buffer.func_181662_b(8.0, yMin, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            t.func_78381_a();
            TAShaderManager.disableShader();
            GlStateManager.func_179147_l();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.TC_HUD);
        } else {
            GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.5f, (float)0.8f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TATextures.TC_HUD);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(8.0, yMax, 0.0).func_187315_a(0.40625, 0.1171875).func_181675_d();
            buffer.func_181662_b(8.0 + (double)height, yMax, 0.0).func_187315_a(0.40625, 0.0).func_181675_d();
            buffer.func_181662_b(8.0 + (double)height, yMin, 0.0).func_187315_a(0.4375, 0.0).func_181675_d();
            buffer.func_181662_b(8.0, yMin, 0.0).func_187315_a(0.4375, 0.1171875).func_181675_d();
            t.func_78381_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(41.5, yMin - 1.75, 0.0).func_187315_a(0.28125, 0.0078125).func_181675_d();
        buffer.func_181662_b(4.5, yMin - 1.75, 0.0).func_187315_a(0.28125, 0.16796875).func_181675_d();
        buffer.func_181662_b(4.5, yMax + 1.75, 0.0).func_187315_a(0.34375, 0.16796875).func_181675_d();
        buffer.func_181662_b(41.5, yMax + 1.75, 0.0).func_187315_a(0.34375, 0.0078125).func_181675_d();
        t.func_78381_a();
    }

    @Nullable
    protected static IImpetusStorage findStorage(ItemStack stack) {
        IAugmentableItem item;
        IImpetusStorage s = (IImpetusStorage)stack.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
        if (s == null && (item = (IAugmentableItem)stack.getCapability(CapabilityAugmentableItem.AUGMENTABLE_ITEM, null)) != null) {
            for (ItemStack a : item.getAllAugments()) {
                s = (IImpetusStorage)a.getCapability(CapabilityImpetusStorage.IMPETUS_STORAGE, null);
                if (s == null) continue;
                return s;
            }
        }
        return s;
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS && mc.field_71415_G && Minecraft.func_71382_s()) {
            ItemStack held = mc.field_71439_g.func_184614_ca();
            IImpetusStorage storage = HUDEventHandler.findStorage(held);
            if (storage == null) {
                held = mc.field_71439_g.func_184592_cb();
                storage = HUDEventHandler.findStorage(held);
            }
            if (storage != null) {
                HUDEventHandler.renderHeldImpetusLevel(held, storage);
            }
        }
    }

    @SubscribeEvent
    public static void onRenderHUDPre(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiIngame ingame = mc.field_71456_v;
        if (ingame.field_92017_k > 0 && MorphicArmorHelper.hasMorphicArmor(mc.field_71439_g.field_71071_by.func_70448_g())) {
            ingame.field_92017_k = 0;
        }
    }
}

