/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.world;

import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public final class BiomeTerrainBlocks {
    private static final TerrainBlocks NULL_ENTRY = new TerrainBlocks(Blocks.field_150349_c.func_176223_P(), Blocks.field_150346_d.func_176223_P());
    private static HashMap<String, TerrainBlocks> terrain = new HashMap();
    private static HashMap<Block, Function<IBlockState, IBlockState>> blockReplacements = new HashMap();

    private BiomeTerrainBlocks() {
    }

    public static void init() {
        blockReplacements.put((Block)Blocks.field_150354_m, state -> {
            if (state.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND) {
                return Blocks.field_180395_cM.func_176223_P();
            }
            return Blocks.field_150322_A.func_176223_P();
        });
        blockReplacements.put(Blocks.field_150351_n, state -> Blocks.field_150347_e.func_176223_P());
        Biome.field_185377_q.forEach(biome -> BiomeTerrainBlocks.registerBiomeOverride(biome, biome.field_76752_A, biome.field_76753_B));
    }

    private static IBlockState handleReplacements(IBlockState in) {
        if (blockReplacements.containsKey(in.func_177230_c())) {
            return blockReplacements.get(in.func_177230_c()).apply(in);
        }
        return in;
    }

    public static void registerBiomeOverride(Biome biome, IBlockState top, IBlockState filler) {
        top = BiomeTerrainBlocks.handleReplacements(top);
        filler = BiomeTerrainBlocks.handleReplacements(filler);
        terrain.put(biome.getRegistryName().toString(), new TerrainBlocks(top, filler));
    }

    public static TerrainBlocks getTerrainBlocksForBiome(Biome biome) {
        return terrain.getOrDefault(biome.getRegistryName().toString(), NULL_ENTRY);
    }

    private static void updateReplacements() {
        for (TerrainBlocks blocks : terrain.values()) {
            boolean noMoreReplacements = true;
            do {
                noMoreReplacements = true;
                IBlockState newTop = BiomeTerrainBlocks.handleReplacements(blocks.top);
                if (newTop != blocks.top) {
                    blocks.top = newTop;
                    noMoreReplacements = false;
                }
                IBlockState newFiller = BiomeTerrainBlocks.handleReplacements(blocks.filler);
                if (newTop == blocks.filler) continue;
                blocks.filler = newFiller;
                noMoreReplacements = false;
            } while (!noMoreReplacements);
        }
    }

    public static void registerBlockReplacement(Block toReplace, Function<IBlockState, IBlockState> replacer) {
        blockReplacements.put(toReplace, replacer);
        BiomeTerrainBlocks.updateReplacements();
    }

    public static class TerrainBlocks {
        private IBlockState top;
        private IBlockState filler;

        public TerrainBlocks(IBlockState t, IBlockState f) {
            this.top = t;
            this.filler = f;
        }

        public IBlockState getTopState() {
            return this.top;
        }

        public IBlockState getFillerState() {
            return this.filler;
        }
    }
}

