/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.impetus.node.prefab;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusGraph;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusProvider;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public class ImpetusGraph
implements IImpetusGraph {
    protected Map<DimensionalBlockPos, IImpetusNode> nodes = new HashMap<DimensionalBlockPos, IImpetusNode>();

    @Override
    public boolean addNode(IImpetusNode node) {
        IImpetusGraph graph = (IImpetusGraph)node.getGraph();
        if (graph != null && graph != this) {
            this.addAndMergeGraph(node);
            return true;
        }
        return this.nodes.put(node.getLocation(), node) == null;
    }

    @Override
    public boolean removeNode(IImpetusNode node) {
        if (this.nodes.containsKey(node.getLocation())) {
            this.removeAndSplitGraph(node);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public Set<IImpetusNode> getNodes() {
        return ImmutableSet.copyOf(this.nodes.values());
    }

    @Override
    public Set<IImpetusNode> getInputs(IImpetusNode node) {
        return node.getInputs();
    }

    @Override
    public Set<IImpetusNode> getOutputs(IImpetusNode node) {
        return node.getOutputs();
    }

    @Override
    public boolean addInput(IImpetusNode node, IImpetusNode input) {
        return node.addInput(input);
    }

    @Override
    public boolean addOutput(IImpetusNode node, IImpetusNode output) {
        return node.addOutput(output);
    }

    @Override
    public boolean removeInput(IImpetusNode node, IImpetusNode input) {
        return node.removeInput(input);
    }

    @Override
    public boolean removeOutput(IImpetusNode node, IImpetusNode output) {
        return node.removeOutput(output);
    }

    @Override
    @Nullable
    public IImpetusNode findNodeByPosition(DimensionalBlockPos pos) {
        return this.nodes.get(pos);
    }

    @Override
    @Nullable
    public Deque<IImpetusNode> findPath(IImpetusNode start, IImpetusNode end) {
        if (start == end) {
            ArrayDeque<IImpetusNode> ret = new ArrayDeque<IImpetusNode>(1);
            ret.add(start);
            return ret;
        }
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        ArrayDeque toCheck = new ArrayDeque();
        ArrayDeque<IImpetusNode> sPath = new ArrayDeque<IImpetusNode>();
        sPath.add(start);
        toCheck.add(sPath);
        visited.add(start);
        while (!toCheck.isEmpty()) {
            ArrayDeque currentPath = (ArrayDeque)toCheck.poll();
            for (IImpetusNode n : ((IImpetusNode)currentPath.getLast()).getOutputs()) {
                if (visited.contains(n)) continue;
                if (n == end) {
                    currentPath.add(n);
                    return currentPath;
                }
                ArrayDeque<IImpetusNode> copy = new ArrayDeque<IImpetusNode>(currentPath);
                copy.add(n);
                toCheck.add(copy);
                visited.add(n);
            }
        }
        return null;
    }

    @Override
    public Set<IImpetusProvider> findDirectProviders(IImpetusNode node) {
        Set<IImpetusProvider> providers = Collections.newSetFromMap(new IdentityHashMap());
        Set visited = Collections.newSetFromMap(new IdentityHashMap());
        ArrayDeque<IImpetusNode> toCheck = new ArrayDeque<IImpetusNode>();
        toCheck.add(node);
        while (!toCheck.isEmpty()) {
            IImpetusNode check = (IImpetusNode)toCheck.pop();
            if (visited.contains(check)) continue;
            visited.add(check);
            if (check != node && check instanceof IImpetusProvider) {
                providers.add((IImpetusProvider)check);
                continue;
            }
            toCheck.addAll(check.getInputs());
        }
        return providers;
    }

    protected void addAndMergeGraph(IImpetusNode adding) {
        if (this.nodes.size() > ((IImpetusGraph)adding.getGraph()).size()) {
            IImpetusGraph otherGraph = (IImpetusGraph)adding.getGraph();
            for (IImpetusNode node : otherGraph.getNodes()) {
                otherGraph.removeNode(node);
                node.setGraph(this);
                this.nodes.put(node.getLocation(), node);
            }
        } else {
            IImpetusGraph otherGraph = (IImpetusGraph)adding.getGraph();
            for (IImpetusNode node : this.nodes.values()) {
                node.setGraph(otherGraph);
                otherGraph.addNode(node);
            }
            this.nodes.clear();
        }
    }

    protected void removeAndSplitGraph(IImpetusNode splitAt) {
        Set<IImpetusNode> notify = Collections.newSetFromMap(new IdentityHashMap());
        notify.addAll(splitAt.getInputs());
        notify.addAll(splitAt.getOutputs());
        for (IImpetusNode other : notify) {
            other.onDisconnected(splitAt);
        }
        this.nodes.remove(splitAt.getLocation());
        if (!this.nodes.isEmpty()) {
            IdentityHashMap<IImpetusNode, Integer> tags = new IdentityHashMap<IImpetusNode, Integer>();
            int tag = 0;
            while (tags.size() < this.nodes.size()) {
                ArrayDeque<IImpetusNode> toCheck = new ArrayDeque<IImpetusNode>();
                toCheck.add(this.nodes.values().stream().filter(node -> !tags.containsKey(node)).findFirst().get());
                while (!toCheck.isEmpty()) {
                    IImpetusNode node2 = (IImpetusNode)toCheck.pop();
                    if (tags.containsKey(node2)) continue;
                    tags.put(node2, tag);
                    toCheck.addAll(node2.getInputs());
                    toCheck.addAll(node2.getOutputs());
                }
                ++tag;
            }
            if (tag > 0) {
                int i = 0;
                while (i < tag) {
                    int currentTag = i++;
                    ImpetusGraph newGraph = new ImpetusGraph();
                    tags.entrySet().removeIf(entry -> {
                        if ((Integer)entry.getValue() == currentTag) {
                            newGraph.addNode((IImpetusNode)entry.getKey());
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
    }
}

