/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.config;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import thecodex6824.thaumicaugmentation.api.config.ConfigOption;

public class ConfigOptionStringList
extends ConfigOption<String[]> {
    protected String[] value;

    public ConfigOptionStringList(boolean enforceServer, String[] defaultValue) {
        super(enforceServer);
        this.value = new String[defaultValue.length];
        System.arraycopy(defaultValue, 0, this.value, 0, this.value.length);
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.value.length);
        for (String i : this.value) {
            byte[] encoded = i.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(encoded.length);
            buf.writeBytes(encoded);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int size = buf.readInt();
        this.value = new String[Math.min(size, 256)];
        for (int i = 0; i < this.value.length; ++i) {
            byte[] data = new byte[Math.min(buf.readInt(), Short.MAX_VALUE)];
            buf.readBytes(data);
            this.value[i] = new String(data, StandardCharsets.UTF_8);
        }
    }

    @Override
    public String[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(String[] value) {
        this.value = new String[value.length];
        System.arraycopy(value, 0, this.value, 0, this.value.length);
    }
}

