/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.config;

import io.netty.buffer.ByteBuf;
import thecodex6824.thaumicaugmentation.api.config.ConfigOption;

public class ConfigOptionDoubleList
extends ConfigOption<double[]> {
    protected double[] value;

    public ConfigOptionDoubleList(boolean enforceServer, double[] defaultValue) {
        super(enforceServer);
        this.value = defaultValue;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.value.length);
        for (double d : this.value) {
            buf.writeDouble(d);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int size = buf.readInt();
        this.value = new double[size <= 256 ? size : 256];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = buf.readDouble();
        }
    }

    @Override
    public double[] getValue() {
        return this.value;
    }

    @Override
    public void setValue(double[] value) {
        this.value = value;
    }
}

