/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.client;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;

public final class ImpetusRenderingManager {
    private static Int2ObjectOpenHashMap<Map<DimensionalBlockPos, IImpetusNode>> nodes = new Int2ObjectOpenHashMap();
    private static final ImmutableMap<DimensionalBlockPos, IImpetusNode> EMPTY = ImmutableMap.of();

    private ImpetusRenderingManager() {
    }

    public static void registerRenderableNode(IImpetusNode node) {
        HashMap<DimensionalBlockPos, IImpetusNode> map = (HashMap<DimensionalBlockPos, IImpetusNode>)nodes.get(node.getLocation().getDimension());
        if (map == null) {
            map = new HashMap<DimensionalBlockPos, IImpetusNode>();
            nodes.put(node.getLocation().getDimension(), map);
        }
        map.put(node.getLocation(), node);
    }

    public static boolean deregisterRenderableNode(IImpetusNode node) {
        return ((Map)nodes.getOrDefault((Object)node.getLocation().getDimension(), EMPTY)).remove(node.getLocation()) != null;
    }

    public static Collection<IImpetusNode> getAllRenderableNodes(int dim) {
        return ((Map)nodes.getOrDefault((Object)dim, EMPTY)).values();
    }

    @Nullable
    public static IImpetusNode findNodeByPosition(DimensionalBlockPos pos) {
        return (IImpetusNode)((Map)nodes.getOrDefault((Object)pos.getDimension(), EMPTY)).get(pos);
    }
}

