/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.api.internal.heat.HeatNodeKt;
import com.cout970.magneticraft.misc.fluid.Tank;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020%H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006&"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSteamBoiler;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "node", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "inputTank", "Lcom/cout970/magneticraft/misc/fluid/Tank;", "outputTank", "maxProduction", "", "name", "", "(Lcom/cout970/magneticraft/api/heat/IHeatNode;Lcom/cout970/magneticraft/misc/fluid/Tank;Lcom/cout970/magneticraft/misc/fluid/Tank;ILjava/lang/String;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getInputTank", "()Lcom/cout970/magneticraft/misc/fluid/Tank;", "getMaxProduction", "()I", "maxWaterPerTick", "getMaxWaterPerTick", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/heat/IHeatNode;", "getOutputTank", "production", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "update", "", "Magneticraft_1.12"})
public final class ModuleSteamBoiler
implements IModule {
    @NotNull
    public IModuleContainer container;
    private final int maxWaterPerTick;
    @NotNull
    private final ValueAverage production;
    @NotNull
    private final IHeatNode node;
    @NotNull
    private final Tank inputTank;
    @NotNull
    private final Tank outputTank;
    private final int maxProduction;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final int getMaxWaterPerTick() {
        return this.maxWaterPerTick;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update() {
        void $this$fromCelsiusToKelvin$iv;
        void $this$fromCelsiusToKelvin$iv2;
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        this.production.tick();
        int waterLimit = this.inputTank.getFluidAmount();
        if (waterLimit <= 0) {
            return;
        }
        int spaceLimit = (this.outputTank.getCapacity() - this.outputTank.getFluidAmount()) / (int)Config.INSTANCE.getWaterToSteam();
        if (spaceLimit <= 0) {
            return;
        }
        int n = 100;
        double d = this.node.getTemperature();
        boolean $i$f$fromCelsiusToKelvin = false;
        double d2 = (double)$this$fromCelsiusToKelvin$iv2 + 273.15;
        if (d < d2) {
            return;
        }
        int n2 = 100;
        double d3 = this.node.getTemperature();
        IHeatNode iHeatNode = this.node;
        boolean $i$f$fromCelsiusToKelvin2 = false;
        double d4 = (double)$this$fromCelsiusToKelvin$iv + 273.15;
        double heatEnergy = HeatNodeKt.tempToEnergy(iHeatNode, d3 - d4);
        int heatLimit = (int)(heatEnergy / Config.INSTANCE.getSteamToJoules() / Config.INSTANCE.getWaterToSteam());
        int n3 = 0;
        n3 = Math.min(waterLimit, spaceLimit);
        int n4 = this.maxWaterPerTick;
        boolean bl = false;
        n4 = Math.min(n4, heatLimit);
        bl = false;
        int water = Math.min(n3, n4);
        if (water <= 0) {
            return;
        }
        Fluid fluid = FluidRegistry.getFluid((String)"steam");
        if (fluid == null) {
            return;
        }
        Fluid fluid2 = fluid;
        int steam = (int)((double)water * Config.INSTANCE.getWaterToSteam());
        this.inputTank.drainInternal(water, true);
        this.outputTank.fillInternal(new FluidStack(fluid2, steam), true);
        this.production.plusAssign(steam);
        this.node.applyHeat((double)(-steam) * Config.INSTANCE.getSteamToJoules());
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object)this.production.toSyncVariable(5));
    }

    @NotNull
    public final IHeatNode getNode() {
        return this.node;
    }

    @NotNull
    public final Tank getInputTank() {
        return this.inputTank;
    }

    @NotNull
    public final Tank getOutputTank() {
        return this.outputTank;
    }

    public final int getMaxProduction() {
        return this.maxProduction;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleSteamBoiler(@NotNull IHeatNode node, @NotNull Tank inputTank, @NotNull Tank outputTank, int maxProduction, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)((Object)inputTank), (String)"inputTank");
        Intrinsics.checkParameterIsNotNull((Object)((Object)outputTank), (String)"outputTank");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.node = node;
        this.inputTank = inputTank;
        this.outputTank = outputTank;
        this.maxProduction = maxProduction;
        this.name = name;
        this.maxWaterPerTick = (int)((double)this.maxProduction / Config.INSTANCE.getWaterToSteam());
        this.production = new ValueAverage(0, 1, null);
    }

    public /* synthetic */ ModuleSteamBoiler(IHeatNode iHeatNode, Tank tank2, Tank tank3, int n, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            string = "module_steam_boiler";
        }
        this(iHeatNode, tank2, tank3, n, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        IModule.DefaultImpls.deserializeNBT(this, nbt2);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return IModule.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }
}

