/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.heat.IHeatNode;
import com.cout970.magneticraft.misc.HeatKt;
import com.cout970.magneticraft.misc.gui.ValueAverage;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.misc.vector.EnumFacingKt;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import com.cout970.magneticraft.systems.tileentities.TileBase;
import com.cout970.magneticraft.systems.tilemodules.ModuleSolarMirror;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0006\u0010)\u001a\u00020#J\u0006\u0010*\u001a\u00020#J\b\u0010+\u001a\u00020#H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\rR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006,"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleSolarTower;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "node", "Lcom/cout970/magneticraft/api/heat/IHeatNode;", "facingGetter", "Lkotlin/Function0;", "Lnet/minecraft/util/EnumFacing;", "active", "", "name", "", "(Lcom/cout970/magneticraft/api/heat/IHeatNode;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Ljava/lang/String;)V", "getActive", "()Lkotlin/jvm/functions/Function0;", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "getFacingGetter", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/heat/IHeatNode;", "production", "Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "getProduction", "()Lcom/cout970/magneticraft/misc/gui/ValueAverage;", "searchMirrors", "getSearchMirrors", "()Z", "setSearchMirrors", "(Z)V", "applyHeat", "", "heat", "", "getGuiSyncVariables", "", "Lcom/cout970/magneticraft/misc/network/SyncVariable;", "meltDown", "orientateNearMirrors", "update", "Magneticraft_1.12"})
public final class ModuleSolarTower
implements IModule {
    @NotNull
    public IModuleContainer container;
    private boolean searchMirrors;
    @NotNull
    private final ValueAverage production;
    @NotNull
    private final IHeatNode node;
    @NotNull
    private final Function0<EnumFacing> facingGetter;
    @NotNull
    private final Function0<Boolean> active;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    public final boolean getSearchMirrors() {
        return this.searchMirrors;
    }

    public final void setSearchMirrors(boolean bl) {
        this.searchMirrors = bl;
    }

    @NotNull
    public final ValueAverage getProduction() {
        return this.production;
    }

    @Override
    public void update() {
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        this.production.tick();
        if (this.searchMirrors) {
            this.searchMirrors = false;
            this.orientateNearMirrors();
        }
        float $this$fromCelsiusToKelvin$iv = 3500.0f;
        double d = this.node.getTemperature();
        boolean $i$f$fromCelsiusToKelvin = false;
        double d2 = (double)$this$fromCelsiusToKelvin$iv + 273.15;
        if (d > d2) {
            double diff = this.node.getTemperature() - HeatKt.getSTANDARD_AMBIENT_TEMPERATURE();
            this.node.applyHeat(-diff * 0.25);
        }
        if (Config.INSTANCE.getAllowSolarTowerMeltdown()) {
            $this$fromCelsiusToKelvin$iv = 4000.0f;
            d = this.node.getTemperature();
            $i$f$fromCelsiusToKelvin = false;
            d2 = (double)$this$fromCelsiusToKelvin$iv + 273.15;
            if (d > d2) {
                this.meltDown();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void meltDown() {
        int n;
        void rangeX$iv;
        EnumFacing dir = ((EnumFacing)this.facingGetter.invoke()).func_176734_d();
        int n2 = -1;
        IntRange intRange = new IntRange(n2, 1);
        int n3 = 0;
        IntRange intRange2 = new IntRange(n3, 2);
        int n4 = 0;
        IntRange rangeZ$iv = new IntRange(n4, 2);
        boolean $i$f$iterateVolume = false;
        void v0 = rangeX$iv;
        int n5 = v0.getFirst();
        if (n5 <= (n = v0.getLast())) {
            while (true) {
                void i$iv;
                int n6;
                void rangeY$iv;
                void v1 = rangeY$iv;
                int n7 = v1.getFirst();
                if (n7 <= (n6 = v1.getLast())) {
                    while (true) {
                        void j$iv;
                        int n8;
                        IntRange intRange3 = rangeZ$iv;
                        int n9 = intRange3.getFirst();
                        if (n9 <= (n8 = intRange3.getLast())) {
                            void z$iv;
                            do {
                                void k;
                                void j;
                                void var12_15 = ++z$iv;
                                void var13_16 = j$iv;
                                void i = i$iv;
                                boolean bl = false;
                                if (i == false && j == false && k == false) continue;
                                EnumFacing enumFacing = dir;
                                Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing, (String)"dir");
                                BlockPos blockPos = BlockPos.field_177992_a;
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"BlockPos.ORIGIN");
                                BlockPos relPos = EnumFacingKt.rotatePoint(enumFacing, blockPos, new BlockPos((int)i, (int)j, (int)k));
                                World world = this.getWorld();
                                BlockPos blockPos2 = BlockPosKt.plus(this.getPos(), relPos);
                                BlockStaticLiquid blockStaticLiquid = Blocks.field_150353_l;
                                Intrinsics.checkExpressionValueIsNotNull((Object)blockStaticLiquid, (String)"Blocks.LAVA");
                                world.func_175656_a(blockPos2, blockStaticLiquid.func_176223_P());
                            } while (z$iv != n8);
                        }
                        if (j$iv == n6) break;
                        ++j$iv;
                    }
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        World world = this.getWorld();
        BlockPos blockPos = this.getPos();
        BlockStaticLiquid blockStaticLiquid = Blocks.field_150353_l;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockStaticLiquid, (String)"Blocks.LAVA");
        world.func_175656_a(blockPos, blockStaticLiquid.func_176223_P());
    }

    public final void applyHeat(float heat) {
        if (((Boolean)this.active.invoke()).booleanValue()) {
            this.production.plusAssign(heat);
            this.node.applyHeat(heat);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void orientateNearMirrors() {
        int n;
        BlockPos area = new BlockPos(25, 20, 25);
        BlockPos center = BlockPosKt.plus(this.getPos(), EnumFacingKt.toBlockPos((EnumFacing)this.facingGetter.invoke()));
        int n2 = -area.func_177958_n();
        if (n2 <= (n = area.func_177958_n())) {
            while (true) {
                void x;
                int n3;
                int n4;
                if ((n4 = 0) <= (n3 = area.func_177956_o())) {
                    while (true) {
                        void y;
                        int n5;
                        int n6;
                        if ((n6 = -area.func_177952_p()) <= (n5 = area.func_177952_p())) {
                            while (true) {
                                ModuleSolarMirror moduleSolarMirror;
                                TileBase tile$iv;
                                void z;
                                BlockPos otherPos = BlockPosKt.plus(center, new BlockPos((int)x, (int)(-y), (int)z));
                                IBlockAccess $this$getModule$iv = (IBlockAccess)this.getWorld();
                                boolean $i$f$getModule = false;
                                IBlockAccess $this$getTile$iv$iv = $this$getModule$iv;
                                boolean $i$f$getTile = false;
                                TileEntity tile$iv$iv = $this$getTile$iv$iv.func_175625_s(otherPos);
                                TileEntity tileEntity = tile$iv$iv;
                                if (!(tileEntity instanceof TileBase)) {
                                    tileEntity = null;
                                }
                                if ((tile$iv = (TileBase)tileEntity) != null) {
                                    Object v2;
                                    Object v1;
                                    block13: {
                                        TileBase $this$getModule$iv$iv;
                                        boolean $i$f$getModule2 = false;
                                        Iterable iterable = $this$getModule$iv$iv.getContainer().getModules();
                                        boolean bl = false;
                                        Iterable iterable2 = iterable;
                                        boolean bl2 = false;
                                        for (Object t : iterable2) {
                                            IModule it$iv$iv = (IModule)t;
                                            boolean bl3 = false;
                                            if (!(it$iv$iv instanceof ModuleSolarMirror)) continue;
                                            v1 = t;
                                            break block13;
                                        }
                                        v1 = v2 = null;
                                    }
                                    if (!(v1 instanceof ModuleSolarMirror)) {
                                        v2 = null;
                                    }
                                    moduleSolarMirror = v2;
                                } else {
                                    moduleSolarMirror = null;
                                }
                                if (moduleSolarMirror == null) {
                                } else {
                                    ModuleSolarMirror mod = moduleSolarMirror;
                                    mod.setTargetTower(center, this.getPos());
                                }
                                if (z == n5) break;
                                ++z;
                            }
                        }
                        if (y == n3) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return CollectionsKt.listOf((Object)this.production.toSyncVariable(4));
    }

    @NotNull
    public final IHeatNode getNode() {
        return this.node;
    }

    @NotNull
    public final Function0<EnumFacing> getFacingGetter() {
        return this.facingGetter;
    }

    @NotNull
    public final Function0<Boolean> getActive() {
        return this.active;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleSolarTower(@NotNull IHeatNode node, @NotNull Function0<? extends EnumFacing> facingGetter, @NotNull Function0<Boolean> active, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(facingGetter, (String)"facingGetter");
        Intrinsics.checkParameterIsNotNull(active, (String)"active");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.node = node;
        this.facingGetter = facingGetter;
        this.active = active;
        this.name = name;
        this.production = new ValueAverage(0, 1, null);
    }

    public /* synthetic */ ModuleSolarTower(IHeatNode iHeatNode, Function0 function0, Function0 function02, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "module_solar_tower";
        }
        this(iHeatNode, (Function0<? extends EnumFacing>)function0, (Function0<Boolean>)function02, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        IModule.DefaultImpls.deserializeNBT(this, nbt2);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return IModule.DefaultImpls.serializeNBT(this);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }
}

