/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.systems.tilemodules;

import com.cout970.magneticraft.api.core.ITileRef;
import com.cout970.magneticraft.api.internal.energy.ElectricNode;
import com.cout970.magneticraft.features.computers.Blocks;
import com.cout970.magneticraft.misc.NBTKt;
import com.cout970.magneticraft.misc.inventory.InventoriesKt;
import com.cout970.magneticraft.misc.network.IBD;
import com.cout970.magneticraft.misc.network.SyncVariable;
import com.cout970.magneticraft.misc.vector.BlockPosKt;
import com.cout970.magneticraft.systems.computer.DeviceRobotControl;
import com.cout970.magneticraft.systems.computer.IMiningRobot;
import com.cout970.magneticraft.systems.config.Config;
import com.cout970.magneticraft.systems.tileentities.IModule;
import com.cout970.magneticraft.systems.tileentities.IModuleContainer;
import com.cout970.magneticraft.systems.tilemodules.ModuleInternalStorage;
import com.cout970.magneticraft.systems.tilemodules.mining_robot.FailReason;
import com.cout970.magneticraft.systems.tilemodules.mining_robot.RequestStatus;
import com.cout970.magneticraft.systems.tilemodules.mining_robot.RequestStatusKt;
import com.cout970.magneticraft.systems.tilemodules.mining_robot.RobotAction;
import com.cout970.magneticraft.systems.tilemodules.mining_robot.RobotTask;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u00012\u00020\u0002BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010[\u001a\u00020\u00102\u0006\u0010\\\u001a\u00020]H\u0016J\b\u0010^\u001a\u00020\u0010H\u0016J\u0010\u0010_\u001a\u00020\u00102\u0006\u0010`\u001a\u00020aH\u0016J\b\u0010b\u001a\u00020\u0010H\u0016J\b\u0010c\u001a\u00020\u0010H\u0016J\b\u0010d\u001a\u00020\u0010H\u0016J\b\u0010e\u001a\u00020\u0010H\u0016J\u0006\u0010f\u001a\u00020\u0010J\b\u0010g\u001a\u00020\u0010H\u0016J\b\u0010h\u001a\u00020]H\u0016J\b\u0010i\u001a\u00020\u0010H\u0016J\u0006\u0010j\u001a\u00020\u0010R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0017R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u001dR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R$\u00109\u001a\u00020\r2\u0006\u00108\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010 \"\u0004\b;\u0010\"R\u0014\u0010<\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0017R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001c\u0010D\u001a\u0004\u0018\u00010EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\u0017\"\u0004\bL\u0010\u001dR\u001a\u0010M\u001a\u00020NX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010RR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010TR\u001c\u0010U\u001a\u0004\u0018\u00010VX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010Z\u00a8\u0006k"}, d2={"Lcom/cout970/magneticraft/systems/tilemodules/ModuleRobotControl;", "Lcom/cout970/magneticraft/systems/tileentities/IModule;", "Lcom/cout970/magneticraft/systems/computer/IMiningRobot;", "ref", "Lcom/cout970/magneticraft/api/core/ITileRef;", "inventory", "Lnet/minecraftforge/items/IItemHandler;", "storage", "Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;", "node", "Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "orientationGetter", "Lkotlin/Function0;", "Lcom/cout970/magneticraft/features/computers/Blocks$RobotOrientation;", "orientationSetter", "Lkotlin/Function1;", "", "name", "", "(Lcom/cout970/magneticraft/api/core/ITileRef;Lnet/minecraftforge/items/IItemHandler;Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Ljava/lang/String;)V", "batteryCharge", "", "getBatteryCharge", "()I", "batterySize", "getBatterySize", "clientCooldown", "getClientCooldown", "setClientCooldown", "(I)V", "clientOrientation", "getClientOrientation", "()Lcom/cout970/magneticraft/features/computers/Blocks$RobotOrientation;", "setClientOrientation", "(Lcom/cout970/magneticraft/features/computers/Blocks$RobotOrientation;)V", "container", "Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "getContainer", "()Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;", "setContainer", "(Lcom/cout970/magneticraft/systems/tileentities/IModuleContainer;)V", "cooldown", "getCooldown", "device", "Lcom/cout970/magneticraft/systems/computer/DeviceRobotControl;", "getDevice", "()Lcom/cout970/magneticraft/systems/computer/DeviceRobotControl;", "failReason", "getFailReason", "setFailReason", "getInventory", "()Lnet/minecraftforge/items/IItemHandler;", "getName", "()Ljava/lang/String;", "getNode", "()Lcom/cout970/magneticraft/api/internal/energy/ElectricNode;", "i", "orientation", "getOrientation", "setOrientation", "orientationFlag", "getOrientationFlag", "getOrientationGetter", "()Lkotlin/jvm/functions/Function0;", "getOrientationSetter", "()Lkotlin/jvm/functions/Function1;", "getRef", "()Lcom/cout970/magneticraft/api/core/ITileRef;", "requestedAction", "Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotAction;", "getRequestedAction", "()Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotAction;", "setRequestedAction", "(Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotAction;)V", "scanResult", "getScanResult", "setScanResult", "status", "Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RequestStatus;", "getStatus", "()Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RequestStatus;", "setStatus", "(Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RequestStatus;)V", "getStorage", "()Lcom/cout970/magneticraft/systems/tilemodules/ModuleInternalStorage;", "task", "Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotTask;", "getTask", "()Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotTask;", "setTask", "(Lcom/cout970/magneticraft/systems/tilemodules/mining_robot/RobotTask;)V", "deserializeNBT", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "mine", "move", "front", "", "rotateDown", "rotateLeft", "rotateRight", "rotateUp", "runTask", "scan", "serializeNBT", "update", "updateTask", "Magneticraft_1.12"})
public final class ModuleRobotControl
implements IModule,
IMiningRobot {
    @NotNull
    public IModuleContainer container;
    private final int batterySize;
    private final int batteryCharge;
    @NotNull
    private final DeviceRobotControl device;
    @NotNull
    private RequestStatus status;
    private int failReason;
    private int scanResult;
    @Nullable
    private RobotAction requestedAction;
    @Nullable
    private RobotTask task;
    @Nullable
    private Blocks.RobotOrientation clientOrientation;
    private int clientCooldown;
    @NotNull
    private final ITileRef ref;
    @NotNull
    private final IItemHandler inventory;
    @NotNull
    private final ModuleInternalStorage storage;
    @NotNull
    private final ElectricNode node;
    @NotNull
    private final Function0<Blocks.RobotOrientation> orientationGetter;
    @NotNull
    private final Function1<Blocks.RobotOrientation, Unit> orientationSetter;
    @NotNull
    private final String name;

    @Override
    @NotNull
    public IModuleContainer getContainer() {
        IModuleContainer iModuleContainer = this.container;
        if (iModuleContainer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        }
        return iModuleContainer;
    }

    @Override
    public void setContainer(@NotNull IModuleContainer iModuleContainer) {
        Intrinsics.checkParameterIsNotNull((Object)iModuleContainer, (String)"<set-?>");
        this.container = iModuleContainer;
    }

    @Override
    public int getBatterySize() {
        return this.batterySize;
    }

    @Override
    public int getBatteryCharge() {
        return this.batteryCharge;
    }

    @NotNull
    public final DeviceRobotControl getDevice() {
        return this.device;
    }

    @NotNull
    public final Blocks.RobotOrientation getOrientation() {
        return (Blocks.RobotOrientation)this.orientationGetter.invoke();
    }

    public final void setOrientation(@NotNull Blocks.RobotOrientation i) {
        Intrinsics.checkParameterIsNotNull((Object)i, (String)"i");
        this.orientationSetter.invoke((Object)i);
    }

    @Override
    public int getCooldown() {
        RobotTask robotTask = this.task;
        return (robotTask != null ? robotTask.getCooldown() : -1) + 1;
    }

    @Override
    public int getOrientationFlag() {
        return this.getOrientation().getLevel().ordinal() << 2 | this.getOrientation().getDirection().func_176736_b();
    }

    @Override
    @NotNull
    public RequestStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull RequestStatus requestStatus) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)requestStatus), (String)"<set-?>");
        this.status = requestStatus;
    }

    @Override
    public int getFailReason() {
        return this.failReason;
    }

    public void setFailReason(int n) {
        this.failReason = n;
    }

    @Override
    public int getScanResult() {
        return this.scanResult;
    }

    public void setScanResult(int n) {
        this.scanResult = n;
    }

    @Nullable
    public final RobotAction getRequestedAction() {
        return this.requestedAction;
    }

    public final void setRequestedAction(@Nullable RobotAction robotAction) {
        this.requestedAction = robotAction;
    }

    @Nullable
    public final RobotTask getTask() {
        return this.task;
    }

    public final void setTask(@Nullable RobotTask robotTask) {
        this.task = robotTask;
    }

    @Nullable
    public final Blocks.RobotOrientation getClientOrientation() {
        return this.clientOrientation;
    }

    public final void setClientOrientation(@Nullable Blocks.RobotOrientation robotOrientation) {
        this.clientOrientation = robotOrientation;
    }

    public final int getClientCooldown() {
        return this.clientCooldown;
    }

    public final void setClientCooldown(int n) {
        this.clientCooldown = n;
    }

    @Override
    public void update() {
        if (this.clientCooldown == 0) {
            this.clientOrientation = null;
        }
        if (this.clientCooldown > 0) {
            int n = this.clientCooldown;
            this.clientCooldown = n + -1;
        }
        World $this$isClient$iv = this.getWorld();
        boolean $i$f$isClient = false;
        if ($this$isClient$iv.field_72995_K) {
            return;
        }
        this.runTask();
        if (this.node.getVoltage() > 60.0) {
            this.node.applyPower(-Config.INSTANCE.getMiningRobotPassiveConsumption(), false);
        }
    }

    public final void updateTask() {
        block0: {
            RobotAction robotAction = this.requestedAction;
            if (robotAction == null) break block0;
            RobotAction robotAction2 = robotAction;
            boolean bl = false;
            boolean bl2 = false;
            RobotAction it = robotAction2;
            boolean bl3 = false;
            this.setFailReason(0);
            this.task = (RobotTask)it.getTaskFactory().invoke();
            this.setStatus(RequestStatus.RUNNING);
            this.getContainer().sendUpdateToNearPlayers();
        }
    }

    public final void runTask() {
        block1: {
            RobotTask robotTask = this.task;
            if (robotTask == null) break block1;
            RobotTask robotTask2 = robotTask;
            boolean bl = false;
            boolean bl2 = false;
            RobotTask it = robotTask2;
            boolean bl3 = false;
            it.tick(this);
            Integer n = it.getFinish();
            if (n != null) {
                Integer n2 = n;
                boolean bl4 = false;
                boolean bl5 = false;
                int it2 = ((Number)n2).intValue();
                boolean bl6 = false;
                this.task = null;
                this.setStatus(it2 == 0 ? RequestStatus.SUCCESSFUL : RequestStatus.FAILED);
            }
        }
    }

    @Override
    public void move(boolean front) {
        EnumFacing enumFacing;
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        EnumFacing enumFacing2 = this.getOrientation().getFacing();
        BlockPos blockPos = this.getPos();
        boolean bl = false;
        boolean bl2 = false;
        EnumFacing it = enumFacing2;
        boolean bl3 = false;
        EnumFacing enumFacing3 = enumFacing = front ? it : it.func_176734_d();
        Intrinsics.checkExpressionValueIsNotNull((Object)enumFacing3, (String)"orientation.facing.let {\u2026nt) it else it.opposite }");
        BlockPos newPos = BlockPosKt.plus(blockPos, enumFacing3);
        IBlockState state = this.getWorld().func_180495_p(newPos);
        if (this.getWorld().func_189509_E(newPos)) {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getBLOCKED());
            return;
        }
        IBlockState iBlockState = state;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"state");
        if (iBlockState.func_177230_c().func_176196_c(this.getWorld(), newPos)) {
            if (front) {
                this.requestedAction = RobotAction.MOVE_FRONT;
                this.updateTask();
            } else {
                this.requestedAction = RobotAction.MOVE_BACK;
                this.updateTask();
            }
        } else {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getBLOCKED());
        }
    }

    @Override
    public void rotateLeft() {
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        this.requestedAction = RobotAction.ROTATE_LEFT;
        this.updateTask();
    }

    @Override
    public void rotateRight() {
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        this.requestedAction = RobotAction.ROTATE_RIGHT;
        this.updateTask();
    }

    @Override
    public void rotateUp() {
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        if (this.getOrientation().getLevel() != Blocks.OrientationLevel.UP) {
            this.requestedAction = RobotAction.ROTATE_UP;
            this.updateTask();
        } else {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getLIMIT_REACHED());
        }
    }

    @Override
    public void rotateDown() {
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        if (this.getOrientation().getLevel() != Blocks.OrientationLevel.DOWN) {
            this.requestedAction = RobotAction.ROTATE_DOWN;
            this.updateTask();
        } else {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getLIMIT_REACHED());
        }
    }

    @Override
    public void mine() {
        NonNullList items;
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        BlockPos frontPos = BlockPosKt.plus(this.getPos(), this.getOrientation().getFacing());
        IBlockState frontBlock = this.getWorld().func_180495_p(frontPos);
        if (this.getWorld().func_175623_d(frontPos)) {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getAIR());
            return;
        }
        if (frontBlock.func_185887_b(this.getWorld(), frontPos) < 0.0f) {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getUNBREAKABLE());
            return;
        }
        NonNullList nonNullList = NonNullList.func_191196_a();
        boolean bl = false;
        boolean bl2 = false;
        NonNullList it = nonNullList;
        boolean bl3 = false;
        IBlockState iBlockState = frontBlock;
        Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"frontBlock");
        iBlockState.func_177230_c().getDrops(it, (IBlockAccess)this.getWorld(), frontPos, frontBlock, 0);
        NonNullList nonNullList2 = items = nonNullList;
        Intrinsics.checkExpressionValueIsNotNull((Object)nonNullList2, (String)"items");
        if (InventoriesKt.canAcceptAll(this.inventory, (List)nonNullList2)) {
            this.requestedAction = RobotAction.MINE;
            this.updateTask();
        } else {
            this.setStatus(RequestStatus.FAILED);
            this.setFailReason(FailReason.INSTANCE.getINVENTORY_FULL());
        }
    }

    @Override
    public void scan() {
        if (RequestStatusKt.isNotFinished(this.getStatus())) {
            return;
        }
        BlockPos frontPos = BlockPosKt.plus(this.getPos(), this.getOrientation().getFacing());
        this.setScanResult(this.getWorld().func_175623_d(frontPos) ? 0 : 1);
        this.setStatus(RequestStatus.SUCCESSFUL);
    }

    @Override
    @NotNull
    public NBTTagCompound serializeNBT() {
        return NBTKt.newNbt((Function1<? super NBTTagCompound, Unit>)((Function1)new Function1<NBTTagCompound, Unit>(this){
            final /* synthetic */ ModuleRobotControl this$0;

            public final void invoke(@NotNull NBTTagCompound $this$newNbt) {
                Intrinsics.checkParameterIsNotNull((Object)$this$newNbt, (String)"$receiver");
                NBTKt.add($this$newNbt, "device", NBTKt.toNBT(this.this$0.getDevice().serialize()));
                RobotAction robotAction = this.this$0.getRequestedAction();
                NBTKt.add($this$newNbt, "request", robotAction != null ? robotAction.ordinal() : -1);
                Object object = this.this$0.getTask();
                NBTKt.add($this$newNbt, "action", object != null && (object = ((RobotTask)object).getAction()) != null ? ((Enum)object).ordinal() : -1);
                RobotTask robotTask = this.this$0.getTask();
                NBTKt.add($this$newNbt, "cooldown", robotTask != null ? robotTask.getCooldown() : -1);
                Object object2 = this.this$0.getTask();
                NBTKt.add($this$newNbt, "finish", object2 != null && (object2 = ((RobotTask)object2).getFinish()) != null ? (Integer)object2 : -1);
                NBTKt.add($this$newNbt, "requestStatus", this.this$0.getStatus().ordinal());
                NBTKt.add($this$newNbt, "failReason", this.this$0.getFailReason());
                NBTKt.add($this$newNbt, "clientCooldown", this.this$0.getClientCooldown());
                Blocks.RobotOrientation robotOrientation = this.this$0.getClientOrientation();
                NBTKt.add($this$newNbt, "clientOrientation", robotOrientation != null ? robotOrientation.ordinal() : -1);
            }
            {
                this.this$0 = moduleRobotControl;
                super(1);
            }
        }));
    }

    @Override
    public void deserializeNBT(@NotNull NBTTagCompound nbt2) {
        RobotAction robotAction;
        Intrinsics.checkParameterIsNotNull((Object)nbt2, (String)"nbt");
        NBTTagCompound nBTTagCompound = nbt2.func_74775_l("device");
        Intrinsics.checkExpressionValueIsNotNull((Object)nBTTagCompound, (String)"nbt.getCompoundTag(\"device\")");
        this.device.deserialize((Map<String, ? extends Object>)NBTKt.toMap(nBTTagCompound));
        int n = nbt2.func_74762_e("request");
        ModuleRobotControl moduleRobotControl = this;
        boolean bl = false;
        boolean bl2 = false;
        int it = n;
        boolean bl3 = false;
        moduleRobotControl.requestedAction = robotAction = it == -1 ? null : RobotAction.values()[it];
        n = nbt2.func_74762_e("action");
        bl = false;
        bl2 = false;
        it = n;
        boolean bl4 = false;
        if (it != -1) {
            RobotAction action = RobotAction.values()[it];
            Object object = action.getTaskFactory().invoke();
            ModuleRobotControl moduleRobotControl2 = this;
            boolean bl5 = false;
            boolean bl6 = false;
            RobotTask it2 = (RobotTask)object;
            boolean bl7 = false;
            it2.setCooldown(nbt2.func_74762_e("cooldown"));
            int n2 = nbt2.func_74762_e("finish");
            RobotTask robotTask = it2;
            boolean bl8 = false;
            boolean bl9 = false;
            int it3 = n2;
            boolean bl10 = false;
            Integer n3 = it3 == -1 ? null : Integer.valueOf(it3);
            robotTask.setFinish(n3);
            Object object2 = object;
            moduleRobotControl2.task = (RobotTask)object2;
        } else {
            this.task = null;
        }
        this.setStatus(RequestStatus.values()[nbt2.func_74762_e("requestStatus")]);
        this.setFailReason(nbt2.func_74762_e("failReason"));
        this.clientCooldown = nbt2.func_74762_e("clientCooldown");
        n = nbt2.func_74762_e("clientOrientation");
        moduleRobotControl = this;
        bl = false;
        bl2 = false;
        it = n;
        boolean bl11 = false;
        robotAction = it == -1 ? null : Blocks.RobotOrientation.values()[it];
        moduleRobotControl.clientOrientation = robotAction;
    }

    @NotNull
    public final ITileRef getRef() {
        return this.ref;
    }

    @NotNull
    public final IItemHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final ModuleInternalStorage getStorage() {
        return this.storage;
    }

    @NotNull
    public final ElectricNode getNode() {
        return this.node;
    }

    @NotNull
    public final Function0<Blocks.RobotOrientation> getOrientationGetter() {
        return this.orientationGetter;
    }

    @NotNull
    public final Function1<Blocks.RobotOrientation, Unit> getOrientationSetter() {
        return this.orientationSetter;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public ModuleRobotControl(@NotNull ITileRef ref, @NotNull IItemHandler inventory2, @NotNull ModuleInternalStorage storage, @NotNull ElectricNode node, @NotNull Function0<? extends Blocks.RobotOrientation> orientationGetter, @NotNull Function1<? super Blocks.RobotOrientation, Unit> orientationSetter, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)ref, (String)"ref");
        Intrinsics.checkParameterIsNotNull((Object)inventory2, (String)"inventory");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(orientationGetter, (String)"orientationGetter");
        Intrinsics.checkParameterIsNotNull(orientationSetter, (String)"orientationSetter");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.ref = ref;
        this.inventory = inventory2;
        this.storage = storage;
        this.node = node;
        this.orientationGetter = orientationGetter;
        this.orientationSetter = orientationSetter;
        this.name = name;
        this.batterySize = this.storage.getCapacity();
        this.batteryCharge = this.storage.getEnergy();
        this.device = new DeviceRobotControl(this.ref, this);
        this.status = RequestStatus.SUCCESSFUL;
    }

    public /* synthetic */ ModuleRobotControl(ITileRef iTileRef, IItemHandler iItemHandler, ModuleInternalStorage moduleInternalStorage, ElectricNode electricNode, Function0 function0, Function1 function1, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            string = "module_network_card";
        }
        this(iTileRef, iItemHandler, moduleInternalStorage, electricNode, (Function0<? extends Blocks.RobotOrientation>)function0, (Function1<? super Blocks.RobotOrientation, Unit>)function1, string);
    }

    @Override
    @NotNull
    public World getWorld() {
        return IModule.DefaultImpls.getWorld(this);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return IModule.DefaultImpls.getPos(this);
    }

    @Override
    public void init() {
        IModule.DefaultImpls.init(this);
    }

    @Override
    public void onLoad() {
        IModule.DefaultImpls.onLoad(this);
    }

    @Override
    public void onBreak() {
        IModule.DefaultImpls.onBreak(this);
    }

    @Override
    @Nullable
    public <T> T getCapability(@NotNull Capability<T> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.getCapability(this, cap, facing);
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> cap, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(cap, (String)"cap");
        return IModule.DefaultImpls.hasCapability(this, cap, facing);
    }

    @Override
    public void receiveSyncData(@NotNull IBD ibd, @NotNull Side otherSide) {
        Intrinsics.checkParameterIsNotNull((Object)ibd, (String)"ibd");
        Intrinsics.checkParameterIsNotNull((Object)otherSide, (String)"otherSide");
        IModule.DefaultImpls.receiveSyncData(this, ibd, otherSide);
    }

    @Override
    @NotNull
    public List<SyncVariable> getGuiSyncVariables() {
        return IModule.DefaultImpls.getGuiSyncVariables(this);
    }
}

